/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.scheduled.layout_model;

import android.support.annotation.NonNull;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.taboola.android.utils.Logger;
import org.json.JSONObject;

public abstract class AbstractNotificationsLayoutModel {
    private static final String TAG = AbstractNotificationsLayoutModel.class.getSimpleName();
    private static final String PREFERRED_COLLAPSED_LAYOUT = "preferredCollapsedLayout";
    private static final String PREFERRED_EXPANDED_LAYOUT = "preferredExpandedLayout";
    static final String LAYOUT = "layout";
    static final String MIN_NUMBER_OF_ITEMS = "minNumberOfItems";
    static final String MAX_NUMBER_OF_ITEMS = "maxNumberOfItems";
    static final String COLLAPSED_LAYOUT = "collapsedLayout";
    static final String EXPANDED_LAYOUT = "expandedLayout";
    static final String COLLAPSE_LAYOUT_SPECIFIC_CONFIG = "collapseLayoutSpecificConfig";
    static final String EXPANDED_LAYOUT_SPECIFIC_CONFIG = "expandedLayoutSpecificConfig";
    protected final Gson gson = new Gson();

    public String generateUiMode(@NonNull String collapsedLayout, @NonNull String expandedLayout) {
        String uiMode = "";
        try {
            JSONObject object = new JSONObject();
            object.put(PREFERRED_COLLAPSED_LAYOUT, (Object)collapsedLayout);
            object.put(PREFERRED_EXPANDED_LAYOUT, (Object)expandedLayout);
            uiMode = object.toString();
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
        return uiMode;
    }

    public String getModelString() {
        String modelString = "";
        try {
            modelString = this.getJsonObject().toString();
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
        return modelString;
    }

    @NonNull
    abstract JsonElement getJsonObject() throws Exception;
}

