/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.core.kill_switch;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.taboola.android.utils.Logger;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class KillSwitchStorage {
    private static final String TAG = "KillSwitchStorage";
    private static final String SHARED_PREF_KEY = "com.taboola.android.reader.EXCEPTION_PREFERENCES_KEY";
    private static final String CRASH_LIST_KEY = "crash_list";
    private static final String LAST_CRASH_TIMESTAMP = "last_crash_timestamp";
    private final SharedPreferences preferences;
    private final Gson gson;

    KillSwitchStorage(Context applicationContext) {
        this.preferences = applicationContext.getSharedPreferences(SHARED_PREF_KEY, 0);
        this.gson = new Gson();
    }

    void addExceptionOccurred(long OccurrenceTimestamp) {
        try {
            List<Long> crashList = this.getCrashList();
            crashList.add(OccurrenceTimestamp);
            String json = this.gson.toJson(crashList);
            this.preferences.edit().putString(CRASH_LIST_KEY, json).apply();
        }
        catch (Throwable e) {
            Logger.e((String)TAG, (String)("addExceptionOccurred: error " + e), (Throwable)e);
        }
    }

    int getCurrentExceptionCountForPeriod(long periodMs) {
        List<Long> crashList = this.getCrashList();
        if (crashList.isEmpty()) {
            return 0;
        }
        Iterator<Long> iterator = crashList.iterator();
        while (iterator.hasNext()) {
            Long crashTimeStamp = iterator.next();
            if (crashTimeStamp >= periodMs) continue;
            iterator.remove();
        }
        try {
            String json = this.gson.toJson(crashList);
            this.preferences.edit().putString(CRASH_LIST_KEY, json).apply();
        }
        catch (Throwable e) {
            Logger.e((String)TAG, (String)("getCurrentExceptionCountForPeriod: error " + e), (Throwable)e);
        }
        return crashList.size();
    }

    long getLastNotificationBlockTriggeredTimestamp() {
        return this.preferences.getLong(LAST_CRASH_TIMESTAMP, 0L);
    }

    void setLastNotificationBlockTriggeredTimestamp(long timestamp) {
        this.preferences.edit().putLong(LAST_CRASH_TIMESTAMP, timestamp).apply();
    }

    @NonNull
    private List<Long> getCrashList() {
        Type type;
        String json = this.preferences.getString(CRASH_LIST_KEY, null);
        List crashList = (List)this.gson.fromJson(json, type = new TypeToken<ArrayList<Long>>(){}.getType());
        if (crashList != null) {
            return crashList;
        }
        return new ArrayList<Long>();
    }
}

