package com.taboola.android.plus.core;

import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;

import java.util.List;

@RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
public abstract class TBLScheduledManager implements IFeatureModule {

    /**
     * Sets flag for <b>wifi only mode</b>  feature. If set to {@code true}, SDK+ will only fetch
     * new notification content if there is a wifi connection available (whether a connection is
     * metered or not is not taken into the account). <p>
     * Setting the flag to {@code false} will allow SDK+ to fetch new notification content regardless
     * of the type of the connection. <p>
     * Setting the flag to {@code null} will clear the current runtime flag value. In this case the
     * value from the remote config will be used if it is specified. If the remote config value is not
     * specified the default value will be used <p>
     * The default value is {@code false}
     *
     * @param isWifiOnlyMode value for the <b>wifi only mode</b> feature flag. Valid values are {@code true}, {@code false}, {@code null}
     * @return {@link TBLScheduledManager}
     */
    abstract public TBLScheduledManager setIsWifiOnlyMode(@Nullable Boolean isWifiOnlyMode);

    /**
     * Sets list of new categories for scheduled notifications
     *
     * @param categories minimum size of list is 1
     * @return {@link TBLScheduledManager}
     */
    abstract public TBLScheduledManager setCategories(@NonNull List<String> categories);

    /**
     * Enables scheduled notifications feature.<p>
     * NOTE: notifications categories list must not be empty to enable the feature.
     *
     * @return {@link TBLScheduledManager}
     */
    abstract public TBLScheduledManager enable();

    /**
     * Disables scheduled notifications feature.
     *
     * @return {@link TBLScheduledManager}
     */
    abstract public TBLScheduledManager disable();

    /**
     * Gets boolean value of scheduled notifications feature status
     *
     * @return {@code true} if scheduled notifications feature is enabled, and {@code false} otherwise.
     */
    abstract public boolean isEnabled();

    /**
     * Sets application icon, which will be displayed on scheduled notification
     *
     * @param iconId resource id of icon, which is set as application icon
     * @return {@link TBLScheduledManager}
     */
    abstract public TBLScheduledManager setNotificationAppIcon(int iconId);

    /**
     * Sets application name label, which will be displayed on scheduled notification
     *
     * @param applicationName name label, which is set as application name label
     * @return {@link TBLScheduledManager}
     */
    abstract public TBLScheduledManager setNotificationAppNameLabel(String applicationName);

}