/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.scheduled;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.taboola.android.plus.notifications.scheduled.ScheduledNotificationsConfig;
import com.taboola.android.plus.notifications.scheduled.ScheduledNotificationsLocalStorage;
import com.taboola.android.plus.notifications.scheduled.TBScheduledNotificationAnalyticsManager;
import com.taboola.android.plus.notifications.scheduled.util.ScheduledNotificationRenderingRestrictionsUtil;
import java.util.ArrayList;

public class EngagementGroupsHelper {
    private static final String TAG = EngagementGroupsHelper.class.getSimpleName();
    public static final String DEFAULT_GROUP_NAME = "Default";
    private final TBScheduledNotificationAnalyticsManager analyticsManager;
    private final ScheduledNotificationsLocalStorage localStore;
    private final ScheduledNotificationsConfig.SmartNotificationFrequency smartNotificationFrequency;

    public EngagementGroupsHelper(@NonNull TBScheduledNotificationAnalyticsManager analyticsManager, @NonNull ScheduledNotificationsLocalStorage localStore, @NonNull ScheduledNotificationsConfig.SmartNotificationFrequency smartNotificationFrequency) {
        this.analyticsManager = analyticsManager;
        this.localStore = localStore;
        this.smartNotificationFrequency = smartNotificationFrequency;
    }

    @NonNull
    public ScheduledNotificationsConfig.SmartNotificationFrequency.EngagementGroups getCurrentEngagementGroup() {
        ScheduledNotificationsConfig.SmartNotificationFrequency.EngagementGroups currentGroup = this.getEngagementGroupByName(this.localStore.getCurrentEngagedGroupName());
        if (currentGroup != null) {
            return currentGroup;
        }
        currentGroup = this.getEngagementGroupByName(DEFAULT_GROUP_NAME);
        if (currentGroup != null) {
            return currentGroup;
        }
        throw new IllegalArgumentException("default engagement group is missing");
    }

    @Nullable
    private ScheduledNotificationsConfig.SmartNotificationFrequency.EngagementGroups getEngagementGroupByName(@NonNull String name) {
        ArrayList<ScheduledNotificationsConfig.SmartNotificationFrequency.EngagementGroups> groups = this.smartNotificationFrequency.getEngagementGroups();
        for (ScheduledNotificationsConfig.SmartNotificationFrequency.EngagementGroups engagementGroup : groups) {
            if (!engagementGroup.getGroupName().equalsIgnoreCase(name)) continue;
            return engagementGroup;
        }
        return null;
    }

    void handleUserEngagedAction() {
        ScheduledNotificationsConfig.SmartNotificationFrequency.EngagementGroups currentGroup = this.getCurrentEngagementGroup();
        if (currentGroup != null) {
            boolean shouldUpgradeUserGroup;
            int countOfEngagedActions = this.localStore.getCountOfEngagedActions();
            if (shouldUpgradeUserGroup = this.shouldChangeUserGroup(++countOfEngagedActions, currentGroup.getEngagedNotificationThreshold())) {
                this.upgradeUserGroup(currentGroup);
            } else {
                this.localStore.setCountOfEngagedActions(countOfEngagedActions);
            }
        } else {
            Log.e((String)TAG, (String)"handleUserEngagedAction: cannot handle user action current group is null");
        }
    }

    void handleUserUnengagedAction() {
        int countOfUnengagedActions = this.localStore.getCountOfUnengagedActions();
        this.localStore.setCountOfUnengagedActions(++countOfUnengagedActions);
    }

    void downgradeUserGroupIfNeeded() {
        ScheduledNotificationsConfig.SmartNotificationFrequency.EngagementGroups currentGroup = this.getCurrentEngagementGroup();
        if (currentGroup != null) {
            boolean didActionsCountIntervalExpired = ScheduledNotificationRenderingRestrictionsUtil.didIntervalPass(this.localStore.getLastUserActionsCountIntervalMs(), currentGroup.getUserActionsCountIntervalMs(), System.currentTimeMillis());
            boolean shouldDowngradeUserGroup = this.shouldChangeUserGroup(this.localStore.getCountOfUnengagedActions(), currentGroup.getUnengagedNotificationThreshold());
            if (didActionsCountIntervalExpired) {
                if (shouldDowngradeUserGroup) {
                    this.downgradeUserGroup(currentGroup);
                } else {
                    this.resetEngagementCounters(true);
                }
            }
        } else {
            Log.e((String)TAG, (String)"downgradeUserGroupIfNeeded: cannot downgrade user group, current group is null");
        }
    }

    private void upgradeUserGroup(@NonNull ScheduledNotificationsConfig.SmartNotificationFrequency.EngagementGroups engagementGroup) {
        String upgradeTo = engagementGroup.getUpgradeTo();
        if (TextUtils.isEmpty((CharSequence)upgradeTo)) {
            upgradeTo = engagementGroup.getGroupName();
        }
        Log.i((String)TAG, (String)("promoteUserToNextGroup: promoted to " + upgradeTo));
        this.analyticsManager.sendUserNotificationEngagementGroupPromotedEvent(engagementGroup.getGroupName(), upgradeTo);
        this.localStore.setCurrentEngagedGroupName(upgradeTo);
        this.resetEngagementCounters(false);
    }

    private void downgradeUserGroup(@NonNull ScheduledNotificationsConfig.SmartNotificationFrequency.EngagementGroups engagementGroup) {
        String downgradeTo = engagementGroup.getDowngradeTo();
        if (TextUtils.isEmpty((CharSequence)downgradeTo)) {
            downgradeTo = engagementGroup.getGroupName();
        }
        this.analyticsManager.sendUserNotificationEngagementGroupDemotedEvent(engagementGroup.getGroupName(), downgradeTo);
        this.localStore.setCurrentEngagedGroupName(downgradeTo);
        this.resetEngagementCounters(true);
    }

    private void resetEngagementCounters(boolean shouldResetTimestamp) {
        if (shouldResetTimestamp) {
            this.localStore.setLastUserActionsCountIntervalMs(System.currentTimeMillis());
        }
        this.localStore.setCountOfEngagedActions(0);
        this.localStore.setCountOfUnengagedActions(0);
    }

    private boolean shouldChangeUserGroup(int actionsCount, int actionsLimit) {
        if (actionsLimit == -1) {
            return false;
        }
        return actionsCount >= actionsLimit;
    }
}

