/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.shared.network.handlers;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.taboola.android.plus.shared.network.handlers.BaseHandler;
import com.taboola.android.utils.Logger;
import com.taboola.lightnetwork.dynamic_url.DynamicRequest;
import com.taboola.lightnetwork.dynamic_url.NetworkExecutable;
import com.taboola.lightnetwork.dynamic_url.annotations.GET;
import com.taboola.lightnetwork.dynamic_url.annotations.Query;
import com.taboola.lightnetwork.protocols.http.HttpError;
import com.taboola.lightnetwork.protocols.http.HttpManager;

@Keep
public class KustoHandler
extends BaseHandler {
    private static final String KUSTO_TR_5_URL = "https://cdn.taboola.com/libtrc/tr5";
    private static final String TAG = "KustoHandler";
    private KustoApiService mKustoApiService;

    public KustoHandler() {
        super(TAG);
    }

    public void setHttpManager(HttpManager httpManager) {
        this.mKustoApiService = (KustoApiService)new NetworkExecutable(httpManager, KUSTO_TR_5_URL).create(KustoApiService.class);
    }

    public void sendEvent(@NonNull String tag, @NonNull String data, @Nullable String publisher, @Nullable HttpManager.NetworkResponse networkResponse) {
        this.sendEvent(tag, data, publisher, "", networkResponse);
    }

    public void sendEvent(@NonNull String tag, @NonNull String data, @Nullable String publisher, @Nullable String customData, @Nullable HttpManager.NetworkResponse networkResponse) {
        block4: {
            try {
                DynamicRequest request;
                if (TextUtils.isEmpty((CharSequence)publisher)) {
                    publisher = "";
                }
                DynamicRequest dynamicRequest = request = TextUtils.isEmpty((CharSequence)customData) ? this.mKustoApiService.sendEvent(tag, publisher, data) : this.mKustoApiService.sendEvent(tag, publisher, data, customData);
                if (TextUtils.equals((CharSequence)"release", (CharSequence)"debug")) {
                    Logger.d((String)TAG, (String)("sendEvent " + request.getFinalUrl()));
                }
                this.sendUrlToMonitor(request.getFinalUrl());
                request.execute(networkResponse);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("sendEvent: error " + e.getLocalizedMessage()), (Throwable)e);
                if (networkResponse == null) break block4;
                networkResponse.onError(new HttpError(e.getLocalizedMessage()));
            }
        }
    }

    static interface KustoApiService {
        @GET
        public DynamicRequest sendEvent(@Query(value="cat") String var1, @Query(value="publisher") String var2, @Query(value="data") String var3, @Query(value="custom_data") String var4);

        @GET
        public DynamicRequest sendEvent(@Query(value="cat") String var1, @Query(value="publisher") String var2, @Query(value="data") String var3);
    }
}

