/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.shared;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.customtabs.CustomTabsIntent;
import android.text.TextUtils;
import android.util.Log;
import com.taboola.android.plus.push_notifications.PushNotificationsAnalyticsManager;
import com.taboola.android.plus.push_notifications.models.BreakingNotificationContent;
import com.taboola.android.utils.OnClickHelper;

public class UrlOpenUtil {
    private static final String TAG = UrlOpenUtil.class.getSimpleName();
    private static final String CHROME_PACKAGE = "com.android.chrome";

    public static void handleAttributionClick(@NonNull Context appContext) {
        String locale = appContext.getResources().getConfiguration().locale.getCountry();
        String url = "https://popup.taboola.com/" + locale;
        UrlOpenUtil.openUrl(appContext, url);
    }

    public static void openBreakingUrl(@NonNull PushNotificationsAnalyticsManager analyticsManager, @NonNull BreakingNotificationContent content, @NonNull Context context, @Nullable String url) {
        Log.i((String)TAG, (String)"openBreakingUrl: trying to open breaking url and report event ");
        UrlOpenUtil.openUrl(context, url);
        analyticsManager.sendPushBreakingOpenedSuccessfullyEvent(content);
    }

    public static void openUrl(@NonNull Context context, @Nullable String url) {
        Log.i((String)TAG, (String)"openUrl: try to open url");
        if (TextUtils.isEmpty((CharSequence)url)) {
            Log.i((String)TAG, (String)"openUrl: empty url");
        } else if (OnClickHelper.areChromeCustomTabsSupported((Context)context)) {
            UrlOpenUtil.openUrlInChromeTab(context, url);
        } else {
            UrlOpenUtil.openUrlInBrowser(context, url);
        }
    }

    private static void openUrlInBrowser(@NonNull Context context, @NonNull String url) {
        Log.i((String)TAG, (String)"openUrl: open url in browser");
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10008000);
        }
        context.startActivity(intent);
    }

    private static void openUrlInChromeTab(@NonNull Context context, @NonNull String url) {
        Log.i((String)TAG, (String)"openUrlInChromeTab: open url in custom tab");
        CustomTabsIntent tabsIntent = new CustomTabsIntent.Builder().build();
        tabsIntent.intent.setPackage(CHROME_PACKAGE);
        if (!(context instanceof Activity)) {
            tabsIntent.intent.addFlags(0x10008000);
        }
        tabsIntent.launchUrl(context, Uri.parse((String)url));
    }
}

