/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.shared;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.taboola.android.plus.SdkPlusConfig;
import com.taboola.android.plus.shared.AbstractLocalStorage;
import com.taboola.android.plus.shared.LocalizationStrings;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SharedLocalStorage
extends AbstractLocalStorage {
    private static final String SHARED_PREFS_FILE_NAME = "shared_local_storage";
    static final String SHARED_PREFS_KEY_TB_NOTIFICATION_CATEGORIES = "tb_notification_categories";
    static final String SHARED_PREFS_KEY_LAST_EVENT_TIME = "tb_last_event_time";
    static final String SHARED_PREFS_KEY_TB_ICON_ID = "tb_notification_icon_id";
    static final String SHARED_PREFS_KEY_CONFIG_VARIANT = "tb_config_variant";
    static final String SHARED_PREFS_KEY_IS_NOTIFICATION_BLOCK_BY_SYSTEM = "is_notification_block_by_system";
    static final String SHARED_PREFS_KEY_TABOOLA_PLUS_EXTRA_PROPERTIES = "taboola_plus_extra_properties";
    static final String SHARED_PREFS_KEY_PUBLISHER = "tb_publisher";
    static final String SHARED_PREFS_KEY_CONFIG_ID = "tb_config_id";
    static final String SHARED_PREFS_KEY_APPLICATION_NAME = "tb_notification_application_name";
    static final String SHARED_PREFS_KEY_ONLY_WIFI_MODE = "tb_only_wifi_mode";
    static final String SHARED_PREFS_KEY_TB_NOTIFICATION_ENABLED = "tb_notification_enabled";
    static final String SHARED_PREFS_KEY_NON_CLICKABLE_URL_MARKER = "tb_non_clickable_url_marker";
    static final String SHARED_PREFS_KEY_SIM_COUNTRY = "sim_country";
    static final String SHARED_PREFS_KEY_LAST_CHECK_NOTIFICATION_DISABLED_STATUS_EVENT_TIME = "last_check_notification_disabled_status_event_time";
    static final String SHARED_PREFS_KEY_PREVIOUS_CONFIG = "tb_previous_config";
    static final String SHARED_PREFS_KEY_CURRENT_CONFIG = "tb_current_config";
    static final String CRASHES_EVENTS_NEED_TO_SEND_TO_KUSTO = "crahses_events_need_to_send_to_kusto";
    static final String SHARED_PREFS_KEY_IS_KUSTO_ENABLED = "is_kibana_analytics_enabled";
    static final String LOCAL_STORAGE_SCHEMA_VERSION = "local_storage_schema_version";
    private Gson gsonWithAdapter = new GsonBuilder().registerTypeAdapter(LocalizationStrings.class, (Object)new LocalizationStrings.LocalizationStringsJsonAdapter()).create();

    public SharedLocalStorage(@NonNull Context applicationContext) {
        super(applicationContext, SHARED_PREFS_FILE_NAME);
    }

    public void setNotificationCategories(@NonNull List<String> notificationCategories) {
        HashSet<String> categoriesSet = new HashSet<String>(notificationCategories);
        this.sharedPreferences.edit().putStringSet(SHARED_PREFS_KEY_TB_NOTIFICATION_CATEGORIES, categoriesSet).apply();
    }

    @NonNull
    public List<String> getNotificationCategories() {
        Set categoriesSet = this.sharedPreferences.getStringSet(SHARED_PREFS_KEY_TB_NOTIFICATION_CATEGORIES, new HashSet());
        return new ArrayList<String>(categoriesSet);
    }

    public long getLastEventTime() {
        return this.getLong(SHARED_PREFS_KEY_LAST_EVENT_TIME);
    }

    public void setLastEventTime(long lastEventTime) {
        this.putLong(SHARED_PREFS_KEY_LAST_EVENT_TIME, lastEventTime);
    }

    public boolean isNotificationEnabled() {
        return this.getBoolean(SHARED_PREFS_KEY_TB_NOTIFICATION_ENABLED);
    }

    public void setConfigVariant(String configVariant) {
        this.putString(SHARED_PREFS_KEY_CONFIG_VARIANT, configVariant);
    }

    @NonNull
    public String getConfigVariant() {
        String configVariant = this.getString(SHARED_PREFS_KEY_CONFIG_VARIANT);
        return configVariant == null ? "" : configVariant;
    }

    public void setEnabled(boolean isEnabled) {
        this.putBoolean(SHARED_PREFS_KEY_TB_NOTIFICATION_ENABLED, isEnabled);
    }

    public void setIsNotificationBlockBySystem(boolean isNotificationBlockBySystem) {
        this.putBoolean(SHARED_PREFS_KEY_IS_NOTIFICATION_BLOCK_BY_SYSTEM, isNotificationBlockBySystem);
    }

    public boolean isNotificationBlockBySystem() {
        return this.getBoolean(SHARED_PREFS_KEY_IS_NOTIFICATION_BLOCK_BY_SYSTEM);
    }

    @Nullable
    public String getApplicationName() {
        return this.getString(SHARED_PREFS_KEY_APPLICATION_NAME);
    }

    public void setApplicationName(String applicationName) {
        this.putString(SHARED_PREFS_KEY_APPLICATION_NAME, applicationName);
    }

    public void setWifiOnlyModeRuntimeFlag(boolean isOnlyWifi) {
        this.putBoolean(SHARED_PREFS_KEY_ONLY_WIFI_MODE, isOnlyWifi);
    }

    public boolean isWifiOnlyModeRuntimeFlag() {
        return this.getBoolean(SHARED_PREFS_KEY_ONLY_WIFI_MODE);
    }

    public int getNotificationIcon() {
        return this.getInt(SHARED_PREFS_KEY_TB_ICON_ID);
    }

    public void setNotificationIcon(int notificationIcon) {
        this.putInt(SHARED_PREFS_KEY_TB_ICON_ID, notificationIcon);
    }

    public void removeNotificationIcon() {
        this.removeKey(SHARED_PREFS_KEY_TB_ICON_ID);
    }

    public void setTaboolaPlusExtraProperties(@Nullable Map<String, String> extraProperties) {
        this.putString(SHARED_PREFS_KEY_TABOOLA_PLUS_EXTRA_PROPERTIES, this.gson.toJson(extraProperties));
    }

    @Nullable
    public HashMap<String, String> getTaboolaPlusExtraProperties() {
        String currentPropertiesStr = this.getString(SHARED_PREFS_KEY_TABOOLA_PLUS_EXTRA_PROPERTIES);
        if (!TextUtils.isEmpty((CharSequence)currentPropertiesStr)) {
            Type type = new TypeToken<HashMap<String, String>>(){}.getType();
            return (HashMap)this.gson.fromJson(currentPropertiesStr, type);
        }
        return null;
    }

    public void setPublisher(String publisher) {
        this.putString(SHARED_PREFS_KEY_PUBLISHER, publisher);
    }

    @Nullable
    public String getPublisher() {
        return this.getString(SHARED_PREFS_KEY_PUBLISHER);
    }

    public void setConfigId(String configId) {
        this.putString(SHARED_PREFS_KEY_CONFIG_ID, configId);
    }

    @Nullable
    public String getConfigId() {
        return this.getString(SHARED_PREFS_KEY_CONFIG_ID);
    }

    public void setKustoAnalyticsEnabled(boolean enabled) {
        this.putBoolean(SHARED_PREFS_KEY_IS_KUSTO_ENABLED, enabled);
    }

    public boolean isKustoEnabled() {
        return this.getBoolean(SHARED_PREFS_KEY_IS_KUSTO_ENABLED);
    }

    public boolean isKustoEnabled(boolean defValue) {
        return this.getBoolean(SHARED_PREFS_KEY_IS_KUSTO_ENABLED, defValue);
    }

    public void setNonClickableUrlMarker(String nonClickableUrlMarker) {
        this.putString(SHARED_PREFS_KEY_NON_CLICKABLE_URL_MARKER, nonClickableUrlMarker);
    }

    @NonNull
    public String getNonClickableUrlMarker() {
        String marker = this.getString(SHARED_PREFS_KEY_NON_CLICKABLE_URL_MARKER);
        return marker == null ? "" : marker;
    }

    public void setPreviousConfig(String previousConfig) {
        this.putString(SHARED_PREFS_KEY_PREVIOUS_CONFIG, previousConfig);
    }

    @Nullable
    public String getPreviousConfig() {
        return this.getString(SHARED_PREFS_KEY_PREVIOUS_CONFIG);
    }

    @Nullable
    public SdkPlusConfig getPreviousConfigObj() {
        String configJson = this.getString(SHARED_PREFS_KEY_PREVIOUS_CONFIG);
        if (configJson == null || configJson.isEmpty()) {
            return null;
        }
        return (SdkPlusConfig)this.gsonWithAdapter.fromJson(configJson, SdkPlusConfig.class);
    }

    public void setCurrentConfig(SdkPlusConfig currentConfig) {
        this.putString(SHARED_PREFS_KEY_CURRENT_CONFIG, this.gsonWithAdapter.toJson((Object)currentConfig));
    }

    @Nullable
    public String getCurrentConfig() {
        return this.getString(SHARED_PREFS_KEY_CURRENT_CONFIG);
    }

    @Nullable
    public SdkPlusConfig getCurrentConfigObj() {
        String configJson = this.getString(SHARED_PREFS_KEY_CURRENT_CONFIG);
        if (TextUtils.isEmpty((CharSequence)configJson)) {
            return null;
        }
        return (SdkPlusConfig)this.gsonWithAdapter.fromJson(configJson, SdkPlusConfig.class);
    }

    public void setSimCountry(@NonNull String simCountry) {
        this.putString(SHARED_PREFS_KEY_SIM_COUNTRY, simCountry);
    }

    public String getSimCountry() {
        return this.getString(SHARED_PREFS_KEY_SIM_COUNTRY);
    }

    public void addCrashEventThatNeedSendToKusto(String event) {
        HashSet<String> kustoCrashEventsThatNeedToSend = new HashSet<String>(this.sharedPreferences.getStringSet(CRASHES_EVENTS_NEED_TO_SEND_TO_KUSTO, new HashSet()));
        kustoCrashEventsThatNeedToSend.add(event);
        this.sharedPreferences.edit().putStringSet(CRASHES_EVENTS_NEED_TO_SEND_TO_KUSTO, kustoCrashEventsThatNeedToSend).apply();
    }

    public Set<String> getCrashEventsThatNeedSendToKusto() {
        return this.sharedPreferences.getStringSet(CRASHES_EVENTS_NEED_TO_SEND_TO_KUSTO, new HashSet());
    }

    public void clearCrashEventsThatNeedSendToKusto() {
        this.sharedPreferences.edit().putStringSet(CRASHES_EVENTS_NEED_TO_SEND_TO_KUSTO, new HashSet()).apply();
    }

    public void setLastCheckNotificationDisabledStatusEventTime(long lastCheckNotificationDisabledStatusEventTime) {
        this.putLong(SHARED_PREFS_KEY_LAST_CHECK_NOTIFICATION_DISABLED_STATUS_EVENT_TIME, lastCheckNotificationDisabledStatusEventTime);
    }

    public long getLastCheckNotificationDisabledStatusEventTime() {
        return this.getLong(SHARED_PREFS_KEY_LAST_CHECK_NOTIFICATION_DISABLED_STATUS_EVENT_TIME);
    }
}

