/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.push_notifications;

import android.content.Context;
import android.os.Build;
import android.support.annotation.AnyThread;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Log;
import com.google.firebase.messaging.RemoteMessage;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.ocamba.hoood.OcambaHoood;
import com.ocamba.hoood.transport.OcambaResponseCallback;
import com.taboola.android.plus.BridgeInternal;
import com.taboola.android.plus.TaboolaPlus;
import com.taboola.android.plus.notification.TBDeviceInfoUtil;
import com.taboola.android.plus.push_notifications.OcambaInitCallback;
import com.taboola.android.plus.push_notifications.PushNotificationsAnalyticsManager;
import com.taboola.android.plus.push_notifications.PushNotificationsConfig;
import com.taboola.android.plus.push_notifications.PushNotificationsUtil;
import com.taboola.android.plus.push_notifications.TBPushNotificationRenderer;
import com.taboola.android.plus.push_notifications.models.BreakingNotificationContent;
import com.taboola.android.plus.shared.ConditionCheckUtil;
import com.taboola.android.plus.shared.LocalizationStrings;
import com.taboola.android.plus.shared.SharedLocalStorage;
import com.taboola.android.plus.shared.TBNotificationExecutors;
import com.taboola.android.utils.Logger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;

@RequiresApi(api=21)
public class TBPushNotificationsManager {
    private static final String TAG = TBPushNotificationsManager.class.getSimpleName();
    static final String NOTIFICATION_RENDER_INTENT_ACTION = "com.taboola.android.plus.push_notification.PUSH_NOTIFICATION_MANUAL_RENDER";
    static final String NOTIFICATION_RENDER_INTENT_EXTRA = "com.taboola.android.plus.push_notification.PUSH_NOTIFICATION_MANUAL_RENDER_RAW_DATA";
    public static final String NOTIFICATION_TYPE_BREAKING = "breaking";
    public static final String NOTIFICATION_TYPE_WAKE = "wake";
    private static String savedFirebaseToken;
    private final PushNotificationsAnalyticsManager pushNotificationsAnalyticsManager;
    private final TBPushNotificationRenderer renderer;
    private final SharedLocalStorage sharedLocalStorage;
    private final Context appContext;
    private PushNotificationsConfig pushNotificationsConfig;
    private LocalizationStrings localizationStrings;
    private Boolean pushIsInit;
    private Executor mainThreadExecutor = new TBNotificationExecutors.MainThreadExecutor();
    private HashSet<String> reservedTrackDataKeys = new HashSet();

    @AnyThread
    public static boolean handleTaboolaPush(final RemoteMessage remoteMessage) {
        if (TBPushNotificationsManager.isTaboolaMessage(remoteMessage)) {
            Log.d((String)TAG, (String)"handleTaboolaPush: handling Push notification");
            BridgeInternal.restore(new TaboolaPlus.TaboolaPlusRetrievedCallback(){

                @Override
                public void onTaboolaPlusRetrieved(TaboolaPlus taboolaPlus) {
                    TBPushNotificationsManager manager = taboolaPlus.getPushNotificationsManager();
                    if (manager != null && manager.pushIsInit != null && manager.pushIsInit.booleanValue()) {
                        PushNotificationsConfig pushNotificationsConfig = manager.getPushNotificationsConfig();
                        boolean isPushFeatureEnabled = PushNotificationsUtil.shouldUsePushNotificationsFeature(pushNotificationsConfig);
                        if (isPushFeatureEnabled) {
                            OcambaHoood.notification().onMessageReceived(remoteMessage);
                        } else {
                            Log.v((String)TAG, (String)"handleTaboolaPush: Push notification ignored because Push Notifications feature is disabled");
                        }
                    } else {
                        Logger.e((String)TAG, (String)"handleTaboolaPush: Taboola Plus restore failed : push init failed");
                    }
                }
            }, new TaboolaPlus.TaboolaPlusRetrieveFailedCallback(){

                @Override
                public void onTaboolaPlusRetrieveFailed(Throwable throwable) {
                    Log.e((String)TAG, (String)("handleTaboolaPush: Taboola Plus restore failed : " + throwable.getMessage()), (Throwable)throwable);
                }
            });
            return true;
        }
        Log.v((String)TAG, (String)"handleTaboolaPush: Push notification ignored because it was not sent by Taboola server");
        return false;
    }

    public static boolean isTaboolaMessage(RemoteMessage remoteMessage) {
        return remoteMessage != null && !remoteMessage.getData().isEmpty() && OcambaHoood.notification().isOcambaMessage(remoteMessage);
    }

    @AnyThread
    public static void onNewFirebaseToken(final String token) {
        BridgeInternal.restore(new TaboolaPlus.TaboolaPlusRetrievedCallback(){

            @Override
            public void onTaboolaPlusRetrieved(TaboolaPlus taboolaPlus) {
                boolean isPushFeatureEnabled = false;
                TBPushNotificationsManager manager = taboolaPlus.getPushNotificationsManager();
                if (manager != null && manager.pushIsInit != null && manager.pushIsInit.booleanValue()) {
                    PushNotificationsConfig pushNotificationsConfig = manager.getPushNotificationsConfig();
                    isPushFeatureEnabled = PushNotificationsUtil.shouldUsePushNotificationsFeature(pushNotificationsConfig);
                }
                if (isPushFeatureEnabled) {
                    TBPushNotificationsManager.sendFirebaseToken(token);
                } else {
                    TBPushNotificationsManager.cacheFirebaseToken(token);
                }
            }
        }, new TaboolaPlus.TaboolaPlusRetrieveFailedCallback(){

            @Override
            public void onTaboolaPlusRetrieveFailed(Throwable throwable) {
                TBPushNotificationsManager.cacheFirebaseToken(token);
            }
        });
    }

    private static void sendFirebaseToken(String token) {
        try {
            Class.forName("com.ocamba.hoood.OcambaHoood");
            Logger.d((String)TAG, (String)("Refreshed token: " + token));
            OcambaHoood.notification().pushToken(token);
        }
        catch (Exception e) {
            Logger.d((String)TAG, (String)("onNewFirebaseToken error " + e));
        }
    }

    private static void cacheFirebaseToken(String token) {
        savedFirebaseToken = token;
    }

    public boolean isPushInitialized() {
        boolean isInitialized = this.pushIsInit != null && this.pushIsInit != false;
        Logger.d((String)TAG, (String)("isPushInitialized: " + isInitialized));
        return isInitialized;
    }

    @NonNull
    static String getNotificationAction(Map<String, String> data) {
        try {
            HashMap customDataMap = (HashMap)new Gson().fromJson(data.get("c"), new TypeToken<HashMap<String, String>>(){}.getType());
            return PushNotificationsUtil.getActionFromCustomData(customDataMap);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("getNotificationAction: parse error " + e.getMessage()));
            return "";
        }
    }

    TBPushNotificationsManager(@NonNull Context context, @NonNull PushNotificationsAnalyticsManager pushNotificationsAnalyticsManager, @NonNull SharedLocalStorage sharedLocalStorage) {
        this.appContext = context.getApplicationContext();
        this.pushNotificationsAnalyticsManager = pushNotificationsAnalyticsManager;
        this.sharedLocalStorage = sharedLocalStorage;
        this.renderer = new TBPushNotificationRenderer(context, this, this.getNotificationIcon());
        this.createReservedTrackDataKeys();
    }

    void applyConfig(@NonNull PushNotificationsConfig pushNotificationsConfig, @NonNull LocalizationStrings localizationStrings) {
        this.pushNotificationsConfig = pushNotificationsConfig;
        this.localizationStrings = localizationStrings;
    }

    void initPushNotifications(final @NonNull TBPushNotificationsManager tbPushNotificationsManager, final @NonNull String nonLocalizedPubId, final @NonNull String localizedPubId, final @NonNull String configVariant, final @Nullable OcambaInitCallback initCallback) {
        if (!TextUtils.isEmpty((CharSequence)savedFirebaseToken)) {
            TBPushNotificationsManager.sendFirebaseToken(savedFirebaseToken);
            savedFirebaseToken = null;
        }
        OcambaHoood.push().setPushResponse(new OcambaResponseCallback(){

            public void onFailure(Exception e) {
                Logger.e((String)TAG, (String)("initPushNotifications error while init push " + e.getLocalizedMessage()), (Throwable)e);
                tbPushNotificationsManager.getAnalyticsManager().sendInitFailedEvent(e);
                TBPushNotificationsManager.this.pushIsInit = false;
                TBPushNotificationsManager.this.mainThreadExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (initCallback != null) {
                            initCallback.onFailure();
                        }
                    }
                });
            }

            public void onResponse(int code, String response) {
                Logger.d((String)TAG, (String)("initPushNotifications.onResponse() called with: code = [" + code + "], response = [" + response + "]"));
                OcambaHoood.notification().customLayout();
                TBPushNotificationsManager.sendOcambaTrackingData(tbPushNotificationsManager.getSharedLocalStorage(), TBPushNotificationsManager.this.appContext, nonLocalizedPubId, localizedPubId, configVariant);
                TBPushNotificationsManager.this.pushIsInit = true;
                TBPushNotificationsManager.this.mainThreadExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (initCallback != null) {
                            initCallback.onSuccess();
                        }
                    }
                });
            }
        }).init(this.pushNotificationsConfig.getOcambaApiKey());
    }

    private static void sendOcambaTrackingData(SharedLocalStorage sharedLocalStorage, @NonNull Context appContext, @NonNull String nonLocalizedPublisher, @NonNull String localizedPublisherName, @NonNull String configVariant) {
        HashMap<String, String> trackData = new HashMap<String, String>();
        trackData.put("device_id", BridgeInternal.getAdvertisingIdInfo().getAdvertisingId());
        trackData.put("os_name", "Android");
        trackData.put("platform", "Android");
        trackData.put("os_version", Build.VERSION.RELEASE);
        trackData.put("device_model", TBDeviceInfoUtil.getDeviceName());
        trackData.put("app_version", TBDeviceInfoUtil.getAppVersion(appContext));
        trackData.put("appId", appContext.getPackageName());
        trackData.put("device_manufacturer", Build.MANUFACTURER);
        trackData.put("device_brand", Build.MANUFACTURER);
        trackData.put("carrier", TBDeviceInfoUtil.getCarrier(appContext));
        trackData.put("language", Locale.getDefault().getLanguage().toUpperCase());
        trackData.put("adid", BridgeInternal.getAdvertisingIdInfo().getAdvertisingId());
        trackData.put("sdk+(TaboolaPlus)version", "1.4.0");
        trackData.put("sdk(TaboolaApi)version", "2.3.7");
        trackData.put("simCountry", TBDeviceInfoUtil.getSimCountry(sharedLocalStorage, appContext).toUpperCase());
        trackData.put("publisher", nonLocalizedPublisher);
        trackData.put("localizedPublisher", localizedPublisherName);
        trackData.put("configVariant", configVariant);
        OcambaHoood.track(trackData);
        OcambaHoood.sendTrack();
        Logger.d((String)TAG, (String)("sendPushTrackingData() called with: = [" + trackData.toString() + "]"));
    }

    private void createReservedTrackDataKeys() {
        this.reservedTrackDataKeys = new HashSet();
        this.reservedTrackDataKeys.add("device_id");
        this.reservedTrackDataKeys.add("os_name");
        this.reservedTrackDataKeys.add("platform");
        this.reservedTrackDataKeys.add("os_version");
        this.reservedTrackDataKeys.add("device_model");
        this.reservedTrackDataKeys.add("app_version");
        this.reservedTrackDataKeys.add("appId");
        this.reservedTrackDataKeys.add("device_manufacturer");
        this.reservedTrackDataKeys.add("device_brand");
        this.reservedTrackDataKeys.add("carrier");
        this.reservedTrackDataKeys.add("language");
        this.reservedTrackDataKeys.add("adid");
        this.reservedTrackDataKeys.add("sdk+(TaboolaPlus)version");
        this.reservedTrackDataKeys.add("sdk(TaboolaApi)version");
        this.reservedTrackDataKeys.add("simCountry");
        this.reservedTrackDataKeys.add("publisher");
        this.reservedTrackDataKeys.add("localizedPublisher");
        this.reservedTrackDataKeys.add("configVariant");
    }

    @CheckResult
    private HashMap<String, Object> filterOutReservedKeys(Map<String, Object> trackingDataMap) {
        if (trackingDataMap == null || trackingDataMap.isEmpty()) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> newTrackingData = new HashMap<String, Object>();
        for (String key : trackingDataMap.keySet()) {
            Object value;
            if (this.reservedTrackDataKeys.contains(key) || (value = trackingDataMap.get(key)) == null) continue;
            newTrackingData.put(key, value);
        }
        return newTrackingData;
    }

    public void sendUserTrackingData(Map<String, Object> trackingData) {
        try {
            HashMap<String, Object> trackData = this.filterOutReservedKeys(trackingData);
            OcambaHoood.track(trackData);
            OcambaHoood.sendTrack();
            String trackingDataAsString = trackData.toString();
            Logger.d((String)TAG, (String)("sendUserTrackingData() called with: = [ " + trackingDataAsString + "]"));
            this.pushNotificationsAnalyticsManager.sendTrackingDataUpdateEvent(trackingDataAsString);
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("sendUserTrackingData error " + e.toString()), (Throwable)e);
        }
    }

    public void removeUserTrackingDataKey(String key) {
        try {
            if (this.reservedTrackDataKeys.contains(key)) {
                Logger.d((String)TAG, (String)"removeUserTrackingDataKey can't remove key");
                return;
            }
            OcambaHoood.removeTrack((String)key);
            OcambaHoood.sendTrack();
            Logger.d((String)TAG, (String)("removeUserTrackingDataKey() called with: = [ " + key + "]"));
            this.pushNotificationsAnalyticsManager.sendTrackingDataRemoveEvent(key);
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("removeUserTrackingDataKey error " + e.toString()), (Throwable)e);
        }
    }

    void renderBreakingNotification(BreakingNotificationContent breakingNotificationContent) {
        TBPushNotificationRenderer.RenderResult renderResult = this.renderer.renderNotification(breakingNotificationContent, this.pushNotificationsConfig);
        if (renderResult.isSuccessful()) {
            this.pushNotificationsAnalyticsManager.sendPushBreakingRenderEvent(breakingNotificationContent);
        } else {
            Log.e((String)TAG, (String)("Failed to renderContent with error: " + renderResult.getErrorMessage()));
            this.pushNotificationsAnalyticsManager.sendPushBreakingFailedToRenderEvent(breakingNotificationContent, renderResult.getErrorMessage());
        }
    }

    void dismissNotification() {
        Log.v((String)TAG, (String)"dismissPushNotification");
        this.renderer.dismissNotification();
    }

    PushNotificationsConfig getPushNotificationsConfig() {
        return this.pushNotificationsConfig;
    }

    boolean handleNotificationBlockByUser() {
        boolean areNotificationsBlockedByUser = ConditionCheckUtil.areNotificationsBlockedByUser(this.appContext, "Breaking news");
        this.pushNotificationsAnalyticsManager.sendCheckNotificationDisabledStatusEvent(areNotificationsBlockedByUser);
        if (areNotificationsBlockedByUser) {
            if (!this.sharedLocalStorage.isNotificationBlockBySystem()) {
                this.pushNotificationsAnalyticsManager.sendNotificationDisabledBySystemEvent();
                this.sharedLocalStorage.setIsNotificationBlockBySystem(true);
            }
            return true;
        }
        if (this.sharedLocalStorage.isNotificationBlockBySystem()) {
            this.pushNotificationsAnalyticsManager.sendNotificationEnabledBySystemEvent();
            this.sharedLocalStorage.setIsNotificationBlockBySystem(false);
        }
        return false;
    }

    private int getNotificationIcon() {
        if (this.sharedLocalStorage.getNotificationIcon() != -1) {
            return this.sharedLocalStorage.getNotificationIcon();
        }
        return this.appContext.getApplicationInfo().icon;
    }

    LocalizationStrings getLocalizationStrings() {
        return this.localizationStrings;
    }

    @NonNull
    SharedLocalStorage getSharedLocalStorage() {
        return this.sharedLocalStorage;
    }

    PushNotificationsAnalyticsManager getAnalyticsManager() {
        return this.pushNotificationsAnalyticsManager;
    }
}

