/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.push_notifications;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Log;
import com.google.firebase.messaging.RemoteMessage;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.ocamba.hoood.notifications.OcambaNotificationObject;
import com.ocamba.hoood.notifications.OcambaNotificationReceiver;
import com.taboola.android.plus.BridgeInternal;
import com.taboola.android.plus.TaboolaPlus;
import com.taboola.android.plus.notification.TBNotificationManager;
import com.taboola.android.plus.push_notifications.BridgeInternalPushNotification;
import com.taboola.android.plus.push_notifications.PushNotificationsAnalyticsManager;
import com.taboola.android.plus.push_notifications.PushNotificationsConfig;
import com.taboola.android.plus.push_notifications.PushNotificationsUtil;
import com.taboola.android.plus.push_notifications.PushValidationUtil;
import com.taboola.android.plus.push_notifications.TBPushNotificationsManager;
import com.taboola.android.plus.push_notifications.models.BreakingNotificationContent;
import com.taboola.android.plus.push_notifications.models.TBPushRawData;
import com.taboola.android.plus.push_notifications.models.WakeUpContent;
import com.taboola.android.utils.Logger;
import java.util.HashMap;

@RequiresApi(api=21)
public class OcambaPushReceiver
extends OcambaNotificationReceiver {
    private static final String TAG = OcambaPushReceiver.class.getSimpleName();

    public void ocambaNewToken(String token, Context context) {
        Logger.d((String)TAG, (String)"ocambaNewToken() called");
    }

    public void ocambaNotificationUser(RemoteMessage remoteMessage, Context context) {
        Logger.d((String)TAG, (String)"ocambaNotificationUser() called");
    }

    public void ocambaNotificationReceived(final OcambaNotificationObject ocambaNotificationObject, Context context) {
        Logger.d((String)TAG, (String)"ocambaNotificationReceived() called");
        BridgeInternal.restore(new TaboolaPlus.TaboolaPlusRetrievedCallback(){

            @Override
            @RequiresApi(api=21)
            public void onTaboolaPlusRetrieved(TaboolaPlus taboolaPlus) {
                OcambaPushReceiver.this.onTaboolaPlusRetrieved(taboolaPlus.getNotificationManager(), taboolaPlus.getPushNotificationsManager(), ocambaNotificationObject);
            }
        }, new TaboolaPlus.TaboolaPlusRetrieveFailedCallback(){

            @Override
            public void onTaboolaPlusRetrieveFailed(Throwable throwable) {
                Log.e((String)TAG, (String)("handleTaboolaPush: Taboola Plus restore failed : " + throwable.getMessage()), (Throwable)throwable);
            }
        });
    }

    private void onTaboolaPlusRetrieved(TBNotificationManager tbNotificationManager, TBPushNotificationsManager tbPushNotificationsManager, OcambaNotificationObject ocambaNotificationObject) {
        PushNotificationsAnalyticsManager analyticsManager;
        String pushAction = "";
        String messageId = "";
        String customDataString = ocambaNotificationObject.getCustomData();
        HashMap customDataMap = null;
        if (!TextUtils.isEmpty((CharSequence)customDataString)) {
            try {
                customDataMap = (HashMap)new Gson().fromJson(customDataString, new TypeToken<HashMap<String, String>>(){}.getType());
                Logger.d((String)TAG, (String)("ocambaNotificationReceived, customDataMap = [" + customDataMap.toString() + "]"));
                pushAction = PushNotificationsUtil.getActionFromCustomData(customDataMap);
                messageId = PushNotificationsUtil.getMessageIdFromCustomData(customDataMap);
            }
            catch (Exception e) {
                Logger.e((String)TAG, (String)("fail to parse push custom data " + e.getMessage()), (Throwable)e);
                customDataMap = null;
            }
        }
        if (PushValidationUtil.isOcambaPushActionValid(ocambaNotificationObject, customDataMap, pushAction, messageId, analyticsManager = BridgeInternalPushNotification.getAnalyticsManager(tbPushNotificationsManager))) {
            analyticsManager.sendPushReceivedEvent(ocambaNotificationObject.getTitle(), messageId, pushAction);
            switch (pushAction) {
                case "breaking": {
                    if (customDataMap != null && this.allowManualRendering(tbPushNotificationsManager.getPushNotificationsConfig())) {
                        this.handleManualRendering(ocambaNotificationObject, customDataMap);
                        break;
                    }
                    BreakingNotificationContent breakingNotificationContent = PushNotificationsUtil.parseOcambaObjectIntoBreaking(ocambaNotificationObject, customDataMap, messageId);
                    if (PushValidationUtil.isBreakingPushValid(breakingNotificationContent, analyticsManager)) {
                        tbPushNotificationsManager.renderBreakingNotification(breakingNotificationContent);
                        break;
                    }
                    Log.e((String)TAG, (String)"onTaboolaPlusRetrieved: Breaking push validation failed, push notification won't be shown");
                    break;
                }
                case "wake": {
                    WakeUpContent wakeUpContent = PushNotificationsUtil.parseOcambaObjectIntoWake(messageId);
                    if (PushValidationUtil.isWakePushValid(wakeUpContent, analyticsManager)) {
                        PushNotificationsUtil.onWakePushReceived(tbNotificationManager);
                        break;
                    }
                    Log.e((String)TAG, (String)"onTaboolaPlusRetrieved: Wake push validation failed, wake push will be ignored");
                    break;
                }
                default: {
                    Log.d((String)TAG, (String)"Unknown type of push notification");
                }
            }
        } else {
            Log.e((String)TAG, (String)"onTaboolaPlusRetrieved: Invalid action, push notification will be ignored");
        }
    }

    private void handleManualRendering(@NonNull OcambaNotificationObject ocambaNotificationObject, @NonNull HashMap<String, String> customDataMap) {
        Context appContext = BridgeInternal.getApplicationContext();
        if (appContext == null) {
            Logger.e((String)TAG, (String)"handleManualRendering error context is null");
            return;
        }
        TBPushRawData tbPushRawData = PushNotificationsUtil.parseOcambaObjectIntoTBPushRawData(ocambaNotificationObject, customDataMap);
        try {
            Intent intent = new Intent("com.taboola.android.plus.push_notification.PUSH_NOTIFICATION_MANUAL_RENDER");
            intent.putExtra("com.taboola.android.plus.push_notification.PUSH_NOTIFICATION_MANUAL_RENDER_RAW_DATA", (Parcelable)tbPushRawData);
            intent.setPackage(appContext.getPackageName());
            if (appContext.getPackageManager().resolveActivity(intent, 0) == null) {
                appContext.sendBroadcast(intent);
                Logger.d((String)TAG, (String)("handleManualRendering sendBroadcast" + tbPushRawData.toString()));
            } else {
                intent.setFlags(0x34000000);
                appContext.startActivity(intent);
                Logger.d((String)TAG, (String)("handleManualRendering startActivity" + tbPushRawData.toString()));
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
    }

    private boolean allowManualRendering(@NonNull PushNotificationsConfig pushNotificationsConfig) {
        return PushNotificationsUtil.shouldAllowManualRendering(pushNotificationsConfig);
    }

    public void ocambaNotificationClick(OcambaNotificationObject ocambaNotificationObject, Context context) {
        Log.d((String)TAG, (String)"ocambaNotificationClick() called");
    }

    public void ocambaNotificationActionButtons(String s, Context context) {
        Log.d((String)TAG, (String)("ocambaNotificationActionButtons() called with: s = [" + s + "]"));
    }

    public void ocambaNotificationDismissed(Context context) {
        Log.d((String)TAG, (String)"ocambaNotificationDismissed() called");
    }

    public void ocambaNotificationMultiMessageReceived() {
        Log.d((String)TAG, (String)"ocambaNotificationMultiMessageReceived() called");
    }

    public void ocambaNotificationCustomAction(String s, Context context) {
        Log.d((String)TAG, (String)"ocambaNotificationCustomAction() called");
    }
}

