package com.taboola.android.plus;

import android.support.annotation.NonNull;

import com.taboola.android.plus.notification.TBNotificationManager;

import java.util.List;

// todo docs
public interface PublicApi {

    interface PublicTaboolaPlus {

//        public static void init(@NonNull String publisherName,
//                         @NonNull String configId,
//                         @NonNull TaboolaPlus.TaboolaPlusRetrievedCallback onSuccessfulCallback);
//
//        public static void init(@NonNull String publisherName,
//                         @NonNull String configId,
//                         @NonNull TaboolaPlus.TaboolaPlusRetrievedCallback onSuccessfulCallback,
//                         @Nullable TaboolaPlus.TaboolaPlusRetrieveFailedCallback onFailedCallback);

        /**
         * @return fully initialized and ready to work TBNotificationManager instance.
         */
        TBNotificationManager getNotificationManager();
    }

    interface PublicTBNotificationManager {

//        String NOTIFICATION_CLICK_INTENT_ACTION = "com.taboola.android.plus.notification.NOTIFICATION_CLICK_EVENT";
//        String NOTIFICATION_CLICK_INTENT_EXTRA_PLACEMENT = "com.taboola.android.plus.notification.NOTIFICATION_CLICK_EVENT_PLACEMENT";
//        String NOTIFICATION_CLICK_INTENT_EXTRA_ITEM_INDEX = "com.taboola.android.plus.notification.NOTIFICATION_CLICK_EVENT_ITEM_INDEX";
//        String PLACEMENT_CLICK_URL_KEY = "url";

//         static void handleClick(Intent intent);

        /**
         * Sets which categories of recommendations will be displayed in the notification.
         * (News, Sports, Tech etc..)
         * <p>
         * NOTE: In order for notifications to appear, they also must be enabled via
         * {@link TBNotificationManager#enable()}
         *
         * @param categories the list of categories to be displayed in notification.
         */
        TBNotificationManager setCategories(@NonNull List<String> categories);

        /**
         * Sets an icon to be displayed in the notification. If not set, application's icon will be used.
         *
         * @param iconId resource id of an icon to be used in notification
         */
        TBNotificationManager setNotificationIcon(int iconId);

        /**
         * Sets an application name to be displayed in the notification. If not set in code,
         * the actual app name will be used. (Note: a value from the config will override the value
         * that is set this method).
         *
         * @param applicationName application name to be displayed in notification
         */
        TBNotificationManager setApplicationName(String applicationName);

        /**
         * If enabled, new content will only be loaded over Wifi.
         * (Doesn't take into an account if connection is metered or not)
         *
         * @param isWifiOnlyMode boolean indicating if WifiOnlyMode is enabled
         */
        TBNotificationManager setIsWifiOnlyMode(boolean isWifiOnlyMode);

        /**
         * Enables displaying notifications with Taboola recommendations.
         * <p>
         * NOTE: In order for notifications to appear, recommendations categories must be set via
         * {@link TBNotificationManager#setCategories(List)}
         */
        TBNotificationManager enable();

        /**
         * Disables displaying notifications with Taboola recommendations and removes currently
         * displayed notification if there is one
         */
        TBNotificationManager disable();

        /**
         * Indicates whether displaying notifications is enabled.
         * (NOTE: doesn't check if notification job was killed)
         */
        boolean isEnabled();
    }

}
