/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.shared;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBRecommendationItem;
import com.taboola.android.api.TaboolaApi;
import com.taboola.android.plus.BridgeInternal;
import com.taboola.android.plus.notification.TBDeviceInfoUtil;
import com.taboola.android.plus.shared.EventProperties;
import com.taboola.android.plus.shared.SharedLocalStorage;
import com.taboola.android.plus.shared.TBNotificationExecutors;
import com.taboola.android.plus.shared.network.SdkPlusNetworkManager;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.network.KibanaUtils;
import com.taboola.lightnetwork.protocols.http.HttpError;
import com.taboola.lightnetwork.protocols.http.HttpManager;
import com.taboola.lightnetwork.protocols.http.HttpResponse;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.json.JSONObject;

public class SharedAnalyticsManager {
    private static final String TAG = SharedAnalyticsManager.class.getSimpleName();
    public static final String TB_ANALYTICS_ACTION_NAME = "tb.analytics.action.name";
    public static final String TB_ANALYTICS_KEY_EVENT_NAME = "key_event_name";
    public static final String TB_ANALYTICS_KEY_EVENT_PROPERTIES = "key_event_properties";
    public static final String TB_ANALYTICS_KEY_USER_PROPERTIES = "key_user_properties";
    public static final String TB_ANALYTICS_KEY_RESPONSE_ITEM_COUNT = "response_item_count";
    private static final String NOTIFICATION_BLOCKED_BY_FREQUENT_CRASHES_EVENT = "FrqntCrshBlkdNotif";
    private static final String CHECK_NOTIFICATION_DISABLED_STATUS_EVENT_V3 = "ChkNotifDsbldStatus";
    private static final String NOTIFICATION_DISABLED_BY_SYSTEM_EVENT = "NotifDsbldBySys";
    private static final String NOTIFICATION_ENABLED_BY_SYSTEM_EVENT = "NotifEnbldBySys";
    private static final String NOTIFICATION_CONFIG_REFRESHED_EVENT = "NotifCfgRefresh";
    private static final String TABOOLA_API_NOT_INITIALIZED_EVENT = "TBApiNotInit";
    private static final String SDK_PLUS_TAG = "SDKPlus";
    private static final String COLLAPSED_NOTIFICATION_LAYOUT_PROPERTY_KEY = "collapsedNotificationLayout";
    private static final String EXPANDED_NOTIFICATION_LAYOUT_PROPERTY_KEY = "expandedNotificationLayout";
    private static final Object kustoCrashesDataLock = new Object();
    private Handler mReportingHandler;
    @NonNull
    private Context appContext;
    @NonNull
    private final SharedLocalStorage sharedLocalStorage;
    private final Executor networkExecutor;
    private final Executor mainThreadExecutor;
    private SdkPlusNetworkManager mNetworkManager;

    public SharedAnalyticsManager(@NonNull SdkPlusNetworkManager plusNetworkManager, @NonNull Context appContext, @NonNull SharedLocalStorage sharedLocalStorage) {
        this.appContext = appContext;
        this.sharedLocalStorage = sharedLocalStorage;
        this.mNetworkManager = plusNetworkManager;
        this.networkExecutor = Executors.newCachedThreadPool();
        Looper looper = this.createReportLooper();
        this.mReportingHandler = new Handler(looper);
        this.mainThreadExecutor = new TBNotificationExecutors.MainThreadExecutor();
    }

    private Looper createReportLooper() {
        HandlerThread handlerThread = new HandlerThread("SdkPlusExceptionHandler");
        handlerThread.start();
        return handlerThread.getLooper();
    }

    public void sendEvent(final @NonNull EventProperties eventProperties) {
        boolean isKustoEnabled = this.sharedLocalStorage.isKustoEnabled();
        if (isKustoEnabled) {
            this.networkExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    SharedAnalyticsManager.this.sendEventToKusto(SharedAnalyticsManager.this.appContext, eventProperties);
                }
            });
        }
        this.mainThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                SharedAnalyticsManager.this.sendEventToTrc(eventProperties);
                SharedAnalyticsManager.this.broadcastEvent(eventProperties);
            }
        });
    }

    public void sendGUEHExceptionToKusto(final @NonNull EventProperties eventProperties, final CountDownLatch countDownLatch) {
        try {
            if (this.sharedLocalStorage.isKustoEnabled(true)) {
                Logger.e((String)"SdkPlusExceptionHandler", (String)("sendGUEHExceptionToKusto. Message: " + eventProperties.getExceptionMessage()));
                final HttpManager.NetworkResponse networkResponse = new HttpManager.NetworkResponse(){

                    public void onResponse(HttpResponse response) {
                        Logger.d((String)"SdkPlusExceptionHandler", (String)("sendCrashEventsToKustoIfNeed Exception reported, response: " + response));
                        countDownLatch.countDown();
                    }

                    public void onError(HttpError httpError) {
                        Logger.e((String)"SdkPlusExceptionHandler", (String)("sendCrashEventsToKustoIfNeed Exception not reported, error: " + httpError));
                        countDownLatch.countDown();
                    }
                };
                this.mReportingHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        SharedAnalyticsManager.this.sendEventToKusto(SharedAnalyticsManager.this.appContext, eventProperties, networkResponse);
                    }
                });
            } else {
                Logger.e((String)"SdkPlusExceptionHandler", (String)("sendGUEHExceptionToKusto. cache crash for next session, Message: " + eventProperties.getExceptionMessage()));
                JsonObject event = this.getJsonObjectForKusto(this.appContext, eventProperties, this.sharedLocalStorage);
                this.sharedLocalStorage.addCrashEventThatNeedSendToKusto(String.valueOf(event));
                countDownLatch.countDown();
            }
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("sendGUEHExceptionToKusto fail [" + e.getMessage() + "]"), (Throwable)e);
        }
    }

    public void sendGUEHExceptionToKibana(Context appContext, EventProperties eventProperties, final CountDownLatch countDownLatch) {
        try {
            Logger.e((String)"SdkPlusExceptionHandler", (String)("Sending exception to Kibana. Message: " + eventProperties.getExceptionMessage()));
            JsonObject jsonReportBody = this.getJsonObjectForKusto(appContext, eventProperties, this.sharedLocalStorage);
            jsonReportBody.remove("time");
            String timeStamp = KibanaUtils.getISO8601currentTime();
            jsonReportBody.addProperty("timestamp", timeStamp);
            final JSONObject exceptionReportJsonObject = new JSONObject(jsonReportBody.toString());
            final HttpManager.NetworkResponse networkResponse = new HttpManager.NetworkResponse(){

                public void onResponse(HttpResponse response) {
                    Logger.d((String)"SdkPlusExceptionHandler", (String)("sendGUEHExceptionToKibana Exception reported, response: " + response));
                    countDownLatch.countDown();
                }

                public void onError(HttpError error) {
                    Logger.e((String)"SdkPlusExceptionHandler", (String)("sendGUEHExceptionToKibana Exception not reported, error: " + error));
                    countDownLatch.countDown();
                }
            };
            this.mReportingHandler.post(new Runnable(){

                @Override
                public void run() {
                    SharedAnalyticsManager.this.mNetworkManager.getKibanaHandler().sendGUEHExceptionToKibana(exceptionReportJsonObject, networkResponse);
                }
            });
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("sendGUEHExceptionToKibana fail [" + e.getMessage() + "]"), (Throwable)e);
        }
    }

    @WorkerThread
    private static void sendEventToKusto(@NonNull EventProperties eventProperties) {
        try {
            JsonObject event = new JsonObject();
            event.addProperty("device_id", "");
            event.addProperty("event_type", eventProperties.getEventName());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);
            event.addProperty("time", sdf.format(new Date(System.currentTimeMillis())));
            event.addProperty("os_name", "Android");
            event.addProperty("platform", "Android");
            event.addProperty("os_version", Build.VERSION.RELEASE);
            event.addProperty("device_model", TBDeviceInfoUtil.getDeviceName());
            event.addProperty("app_version", "");
            event.addProperty("device_manufacturer", Build.MANUFACTURER);
            event.addProperty("device_brand", Build.MANUFACTURER);
            event.addProperty("carrier", "");
            event.addProperty("language", Locale.getDefault().getDisplayLanguage(Locale.US));
            event.addProperty("ip", TBDeviceInfoUtil.getLocalIpAddress());
            event.addProperty("adid", "");
            if (eventProperties.isImplicitEvent()) {
                event.addProperty("session_id", "");
            }
            event.addProperty("sdk+(TaboolaPlus)version", "1.3.5");
            event.addProperty("sdk(TaboolaApi)version", "2.3.7");
            event.addProperty("simCountry", "");
            if (eventProperties.getResponseItemCount() != -1) {
                event.addProperty("responseItemCount", (Number)eventProperties.getResponseItemCount());
            }
            if (!TextUtils.isEmpty((CharSequence)eventProperties.getUiMode())) {
                event.addProperty("itemTitle", eventProperties.getUiMode());
            } else if (eventProperties.getPlacement() != null && !eventProperties.getPlacement().getItems().isEmpty()) {
                event.addProperty("itemTitle", (String)((TBRecommendationItem)eventProperties.getPlacement().getItems().get(0)).getExtraDataMap().get("name"));
            }
            if (!TextUtils.isEmpty((CharSequence)eventProperties.getUrl())) {
                event.addProperty("image_url", eventProperties.getUrl());
            }
            if (!TextUtils.isEmpty((CharSequence)eventProperties.getError())) {
                event.addProperty("error_details", eventProperties.getError());
            }
            if (!TextUtils.isEmpty((CharSequence)eventProperties.getRecommendationItemId())) {
                event.addProperty("recommendationItemId", eventProperties.getRecommendationItemId());
            }
            if (!TextUtils.isEmpty((CharSequence)eventProperties.getErrorMessage())) {
                event.addProperty("errorMessage", eventProperties.getErrorMessage());
            }
            if (eventProperties.isBlocked() != null) {
                event.addProperty("isBlocked", eventProperties.isBlocked());
            }
            if (eventProperties.isDeviceLocked() != null) {
                event.addProperty("isDeviceLocked", eventProperties.isDeviceLocked());
            }
            if (eventProperties.isTrendingItem() != null) {
                event.addProperty("isTrendingItem", eventProperties.isTrendingItem());
            }
            if (eventProperties.isclickIgnored()) {
                event.addProperty("clickIgnored", Boolean.valueOf(true));
            }
            BridgeInternal.getNetworkManager().getKustoHandler().sendEvent(SDK_PLUS_TAG, String.valueOf(event), null);
            Log.v((String)TAG, (String)("sent event to kusto " + eventProperties.getEventName()));
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("sendEventToKusto fail [" + e.getMessage() + "]"), (Throwable)e);
        }
    }

    @WorkerThread
    private void sendEventToKusto(@NonNull Context appContext, @NonNull EventProperties eventProperties) {
        this.sendEventToKusto(appContext, eventProperties, null);
    }

    @WorkerThread
    private void sendEventToKusto(@NonNull Context appContext, @NonNull EventProperties eventProperties, @Nullable HttpManager.NetworkResponse networkResponse) {
        try {
            long lastEventTime = this.sharedLocalStorage.getLastEventTime();
            if ((System.currentTimeMillis() - lastEventTime > 300000L || lastEventTime == -1L) && eventProperties.isImplicitEvent()) {
                this.sharedLocalStorage.setLastEventTime(System.currentTimeMillis());
            }
            this.sendCrashEventsToKustoIfNeed();
            JsonObject event = this.getJsonObjectForKusto(appContext, eventProperties, this.sharedLocalStorage);
            this.mNetworkManager.getKustoHandler().sendEvent(SDK_PLUS_TAG, String.valueOf(event), networkResponse);
            Log.v((String)TAG, (String)("sent event to kusto " + eventProperties.getEventName()));
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("sendEventToKusto fail [" + e.getMessage() + "]"), (Throwable)e);
        }
    }

    private JsonObject getJsonObjectForKusto(@NonNull Context appContext, @NonNull EventProperties eventProperties, SharedLocalStorage sharedLocalStorage) {
        String publisher;
        JsonObject event = new JsonObject();
        event.addProperty("device_id", BridgeInternal.getAdvertisingIdInfo().getAdvertisingId());
        event.addProperty("event_type", eventProperties.getEventName());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);
        event.addProperty("time", sdf.format(new Date(System.currentTimeMillis())));
        event.addProperty("os_name", "Android");
        event.addProperty("platform", "Android");
        event.addProperty("os_version", Build.VERSION.RELEASE);
        event.addProperty("device_model", TBDeviceInfoUtil.getDeviceName());
        event.addProperty("app_version", TBDeviceInfoUtil.getAppVersion(appContext));
        event.addProperty("appId", appContext.getPackageName());
        event.addProperty("device_manufacturer", Build.MANUFACTURER);
        event.addProperty("device_brand", Build.MANUFACTURER);
        event.addProperty("carrier", TBDeviceInfoUtil.getCarrier(appContext));
        event.addProperty("language", Locale.getDefault().getDisplayLanguage(Locale.US));
        event.addProperty("ip", TBDeviceInfoUtil.getLocalIpAddress());
        event.addProperty("adid", BridgeInternal.getAdvertisingIdInfo().getAdvertisingId());
        TBDeviceInfoUtil.setLocationData(appContext, event);
        if (eventProperties.isImplicitEvent()) {
            event.addProperty("session_id", (Number)sharedLocalStorage.getLastEventTime());
        }
        event.addProperty("sdk+(TaboolaPlus)version", "1.3.5");
        event.addProperty("sdk(TaboolaApi)version", "2.3.7");
        event.addProperty("simCountry", TBDeviceInfoUtil.getSimCountry(sharedLocalStorage, appContext));
        if (eventProperties.getResponseItemCount() != -1) {
            event.addProperty("responseItemCount", (Number)eventProperties.getResponseItemCount());
        }
        if (!TextUtils.isEmpty((CharSequence)eventProperties.getUiMode())) {
            event.addProperty("itemTitle", eventProperties.getUiMode());
        } else if (eventProperties.getPlacement() != null && !eventProperties.getPlacement().getItems().isEmpty()) {
            event.addProperty("itemTitle", (String)((TBRecommendationItem)eventProperties.getPlacement().getItems().get(0)).getExtraDataMap().get("name"));
        }
        if (!TextUtils.isEmpty((CharSequence)eventProperties.getUrl())) {
            event.addProperty("image_url", eventProperties.getUrl());
        }
        if (!TextUtils.isEmpty((CharSequence)eventProperties.getError())) {
            event.addProperty("error_details", eventProperties.getError());
        }
        if (eventProperties.isBlocked() != null) {
            event.addProperty("isBlocked", eventProperties.isBlocked());
        }
        if (eventProperties.isDeviceLocked() != null) {
            event.addProperty("isDeviceLocked", eventProperties.isDeviceLocked());
        }
        if (eventProperties.isTrendingItem() != null) {
            event.addProperty("isTrendingItem", eventProperties.isTrendingItem());
        }
        if (!TextUtils.isEmpty((CharSequence)eventProperties.getNotificationType())) {
            event.addProperty("notificationType", eventProperties.getNotificationType());
        }
        if (!TextUtils.isEmpty((CharSequence)eventProperties.getExceptionMessage())) {
            event.addProperty("exceptionMessage", eventProperties.getExceptionMessage());
        }
        if (eventProperties.getExceptionCount() != -1) {
            event.addProperty("exceptionCount", (Number)eventProperties.getExceptionCount());
        }
        if (eventProperties.getExceptionCountPeriodMs() != -1L) {
            event.addProperty("exceptionCountPeriodMs", (Number)eventProperties.getExceptionCountPeriodMs());
        }
        if (!TextUtils.isEmpty((CharSequence)eventProperties.getExceptionStackTrace())) {
            event.addProperty("exceptionStackTrace", eventProperties.getExceptionStackTrace());
        }
        if (!TextUtils.isEmpty((CharSequence)eventProperties.getRandomCounter())) {
            event.addProperty("randomCounter", eventProperties.getRandomCounter());
        }
        if (!TextUtils.isEmpty((CharSequence)eventProperties.getMessageTitle())) {
            event.addProperty("messageTitle", eventProperties.getMessageTitle());
        }
        if (!TextUtils.isEmpty((CharSequence)eventProperties.getMessageId())) {
            event.addProperty("messageId", eventProperties.getMessageId());
        }
        if (!TextUtils.isEmpty((CharSequence)eventProperties.getPushType())) {
            event.addProperty("pushType", eventProperties.getPushType());
        }
        if (!TextUtils.isEmpty((CharSequence)(publisher = sharedLocalStorage.getPublisher()))) {
            event.addProperty("publisher", publisher);
        }
        String configVariant = sharedLocalStorage.getConfigVariant();
        event.addProperty("configVariant", configVariant);
        if (eventProperties.isclickIgnored()) {
            event.addProperty("clickIgnored", Boolean.valueOf(true));
        }
        if (!TextUtils.isEmpty((CharSequence)eventProperties.getCollapsedNotificationLayout())) {
            event.addProperty(COLLAPSED_NOTIFICATION_LAYOUT_PROPERTY_KEY, eventProperties.getCollapsedNotificationLayout());
        }
        if (!TextUtils.isEmpty((CharSequence)eventProperties.getExpandedNotificationLayout())) {
            event.addProperty(EXPANDED_NOTIFICATION_LAYOUT_PROPERTY_KEY, eventProperties.getExpandedNotificationLayout());
        }
        if (!TextUtils.isEmpty((CharSequence)eventProperties.getNewNotificationEngagementGroupName())) {
            event.addProperty("newNotificationEngagementGroupName", eventProperties.getNewNotificationEngagementGroupName());
        }
        if (!TextUtils.isEmpty((CharSequence)eventProperties.getPreviousNotificationEngagementGroupName())) {
            event.addProperty("previousNotificationEngagementGroupName", eventProperties.getPreviousNotificationEngagementGroupName());
        }
        if (!TextUtils.isEmpty((CharSequence)eventProperties.getErrorMessage())) {
            event.addProperty("errorMessage", eventProperties.getErrorMessage());
        }
        if (!TextUtils.isEmpty((CharSequence)eventProperties.getRecommendationItemId())) {
            event.addProperty("recommendationItemId", eventProperties.getRecommendationItemId());
        }
        return event;
    }

    @UiThread
    private void sendEventToTrc(@NonNull EventProperties eventProperties) {
        if (TaboolaApi.getInstance().isInitialized()) {
            TBPlacement placement = eventProperties.getPlacement();
            if (placement != null && placement.getItems() != null && !placement.getItems().isEmpty()) {
                TBRecommendationItem item = (TBRecommendationItem)placement.getItems().get(0);
                Map<String, String> map = this.getEventMap(this.appContext, eventProperties);
                item.reportEvent(eventProperties.getEventName(), map, "youmaylike");
            }
        } else {
            String info = "TBNotificationAnalyticsManager: sendEventToTrc(): " + eventProperties.getEventName();
            this.sendTaboolaApiNotInitializedEvent(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void sendCrashEventsToKustoIfNeed() {
        HashSet<String> crashEventsThatNeedSendToKusto;
        Iterator iterator = kustoCrashesDataLock;
        synchronized (iterator) {
            crashEventsThatNeedSendToKusto = new HashSet<String>(this.sharedLocalStorage.getCrashEventsThatNeedSendToKusto());
            this.sharedLocalStorage.clearCrashEventsThatNeedSendToKusto();
        }
        if (!crashEventsThatNeedSendToKusto.isEmpty()) {
            for (String event : crashEventsThatNeedSendToKusto) {
                String crashEventFormatted = String.valueOf(new JsonParser().parse(event).getAsJsonObject());
                this.mNetworkManager.getKustoHandler().sendEvent(SDK_PLUS_TAG, crashEventFormatted, new HttpManager.NetworkResponse(){

                    public void onResponse(HttpResponse response) {
                        Logger.d((String)"SdkPlusExceptionHandler", (String)("sendCrashEventsToKustoIfNeed Exception reported, response: " + response));
                    }

                    public void onError(HttpError httpError) {
                        Logger.e((String)"SdkPlusExceptionHandler", (String)("sendCrashEventsToKustoIfNeed Exception not reported, error: " + httpError));
                    }
                });
                Log.v((String)TAG, (String)("sent event to kusto " + event));
            }
        }
    }

    private Map<String, String> getEventMap(@NonNull Context appContext, @NonNull EventProperties eventProperties) {
        String publisher;
        long lastEventTime = this.sharedLocalStorage.getLastEventTime();
        if ((System.currentTimeMillis() - lastEventTime > 300000L || lastEventTime == -1L) && eventProperties.isImplicitEvent()) {
            this.sharedLocalStorage.setLastEventTime(System.currentTimeMillis());
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("device_id", BridgeInternal.getAdvertisingIdInfo().getAdvertisingId());
        map.put("event_type", eventProperties.getEventName());
        map.put("time", new Timestamp(System.currentTimeMillis()).toString());
        map.put("os_name", "Android");
        map.put("platform", "Android");
        map.put("os_version", Build.VERSION.RELEASE);
        map.put("device_model", TBDeviceInfoUtil.getDeviceName());
        map.put("app_version", TBDeviceInfoUtil.getAppVersion(appContext));
        map.put("appId", appContext.getPackageName());
        map.put("device_manufacturer", Build.MANUFACTURER);
        map.put("device_brand", Build.MANUFACTURER);
        map.put("carrier", TBDeviceInfoUtil.getCarrier(appContext));
        map.put("language", Locale.getDefault().getDisplayLanguage(Locale.US));
        map.put("ip", TBDeviceInfoUtil.getLocalIpAddress());
        map.put("adid", BridgeInternal.getAdvertisingIdInfo().getAdvertisingId());
        TBDeviceInfoUtil.setLocationData(appContext, map);
        if (eventProperties.isImplicitEvent()) {
            map.put("session_id", String.valueOf(this.sharedLocalStorage.getLastEventTime()));
        }
        map.put("sdk+(TaboolaPlus)version", "1.3.5");
        map.put("sdk(TaboolaApi)version", "2.3.7");
        map.put("simCountry", TBDeviceInfoUtil.getSimCountry(this.sharedLocalStorage, appContext));
        if (eventProperties.getResponseItemCount() != -1) {
            map.put("responseItemCount", String.valueOf(eventProperties.getResponseItemCount()));
        }
        if (eventProperties.getUiMode() != null && !eventProperties.getUiMode().isEmpty()) {
            map.put("itemTitle", eventProperties.getUiMode());
        } else if (eventProperties.getPlacement() != null && !eventProperties.getPlacement().getItems().isEmpty()) {
            map.put("itemTitle", (String)((TBRecommendationItem)eventProperties.getPlacement().getItems().get(0)).getExtraDataMap().get("name"));
        }
        if (eventProperties.getUrl() != null && !eventProperties.getUrl().isEmpty()) {
            map.put("image_url", eventProperties.getUrl());
        }
        if (eventProperties.getError() != null) {
            map.put("error_details", eventProperties.getError());
        }
        if (eventProperties.isBlocked() != null) {
            map.put("isBlocked", String.valueOf(eventProperties.isBlocked()));
        }
        if (eventProperties.isTrendingItem() != null) {
            map.put("isTrendingItem", String.valueOf(eventProperties.isTrendingItem()));
        }
        if (eventProperties.isDeviceLocked() != null) {
            map.put("isDeviceLocked", String.valueOf(eventProperties.isDeviceLocked()));
        }
        if (eventProperties.getExceptionMessage() != null) {
            map.put("exceptionMessage", eventProperties.getExceptionMessage());
        }
        if (eventProperties.getExceptionCount() != -1) {
            map.put("exceptionCount", String.valueOf(eventProperties.getExceptionCount()));
        }
        if (eventProperties.getExceptionCountPeriodMs() != -1L) {
            map.put("exceptionCountPeriodMs", String.valueOf(eventProperties.getExceptionCountPeriodMs()));
        }
        if (eventProperties.getExceptionStackTrace() != null) {
            map.put("exceptionStackTrace", eventProperties.getExceptionStackTrace());
        }
        if (eventProperties.getRandomCounter() != null) {
            map.put("randomCounter", eventProperties.getRandomCounter());
        }
        if (eventProperties.getPushType() != null) {
            map.put("pushType", eventProperties.getPushType());
        }
        if ((publisher = this.sharedLocalStorage.getPublisher()) != null && !publisher.isEmpty()) {
            map.put("publisher", publisher);
        }
        String configVariant = this.sharedLocalStorage.getConfigVariant();
        map.put("configVariant", configVariant);
        if (eventProperties.isclickIgnored()) {
            map.put("clickIgnored", String.valueOf(true));
        }
        return map;
    }

    private JSONObject getEventProperties(@NonNull Context appContext, @Nullable TBPlacement placement, int responseItemCount, @Nullable String error, @Nullable String url, boolean isClickIngnored, String collapsedNotificationLayout, String expandedNotificationLayout, Boolean isBlocked, Boolean isDeviceLocked, Boolean isTrendingItem, String uiMode, String exceptionMessage, int exceptionCount, long exceptionCountPeriodMs, String exceptionStackTrace, String newNotificationEngagementGroupName, String previousNotificationEngagementGroupName, String recommendationItemId, String errorMessage, String randomCounter, String messageTitle, String messageId, String pushType, String notificationType) {
        JSONObject eventProperties = new JSONObject();
        try {
            String publisher;
            eventProperties.put("sdk+(TaboolaPlus)version", (Object)"1.3.5");
            eventProperties.put("sdk(TaboolaApi)version", (Object)"2.3.7");
            eventProperties.put("simCountry", (Object)TBDeviceInfoUtil.getSimCountry(this.sharedLocalStorage, appContext));
            if (responseItemCount != -1) {
                eventProperties.put("responseItemCount", responseItemCount);
            }
            if (!TextUtils.isEmpty((CharSequence)uiMode)) {
                eventProperties.put("placement", (Object)uiMode);
            } else if (placement != null && !placement.getItems().isEmpty()) {
                eventProperties.put("placement", ((TBRecommendationItem)placement.getItems().get(0)).getExtraDataMap().get("name"));
            }
            if (!TextUtils.isEmpty((CharSequence)url)) {
                eventProperties.put("image_url", (Object)url);
            }
            if (!TextUtils.isEmpty((CharSequence)newNotificationEngagementGroupName)) {
                eventProperties.put("newNotificationEngagementGroupName", (Object)newNotificationEngagementGroupName);
            }
            if (!TextUtils.isEmpty((CharSequence)previousNotificationEngagementGroupName)) {
                eventProperties.put("previousNotificationEngagementGroupName", (Object)previousNotificationEngagementGroupName);
            }
            if (!TextUtils.isEmpty((CharSequence)error)) {
                eventProperties.put("error_details", (Object)error);
            }
            if (!TextUtils.isEmpty((CharSequence)recommendationItemId)) {
                eventProperties.put("invalidRecommendationItemId", (Object)recommendationItemId);
            }
            if (!TextUtils.isEmpty((CharSequence)errorMessage)) {
                eventProperties.put("errorMessage", (Object)errorMessage);
            }
            if (isBlocked != null) {
                eventProperties.put("isBlocked", (Object)isBlocked);
            }
            if (isDeviceLocked != null) {
                eventProperties.put("isDeviceLocked", (Object)isDeviceLocked);
            }
            if (isTrendingItem != null) {
                eventProperties.put("isTrendingItem", (Object)isTrendingItem);
            }
            if (isClickIngnored) {
                eventProperties.put("clickIgnored", true);
            }
            if (!TextUtils.isEmpty((CharSequence)collapsedNotificationLayout)) {
                eventProperties.put(COLLAPSED_NOTIFICATION_LAYOUT_PROPERTY_KEY, (Object)collapsedNotificationLayout);
            }
            if (!TextUtils.isEmpty((CharSequence)expandedNotificationLayout)) {
                eventProperties.put(EXPANDED_NOTIFICATION_LAYOUT_PROPERTY_KEY, (Object)expandedNotificationLayout);
            }
            if (!TextUtils.isEmpty((CharSequence)exceptionMessage)) {
                eventProperties.put("exceptionMessage", (Object)exceptionMessage);
            }
            if (exceptionCount != -1) {
                eventProperties.put("exceptionCount", exceptionCount);
            }
            if (exceptionCountPeriodMs != -1L) {
                eventProperties.put("exceptionCountPeriodMs", exceptionCountPeriodMs);
            }
            if (!TextUtils.isEmpty((CharSequence)exceptionStackTrace)) {
                eventProperties.put("exceptionStackTrace", (Object)exceptionStackTrace);
            }
            if (!TextUtils.isEmpty((CharSequence)randomCounter)) {
                eventProperties.put("randomCounter", (Object)randomCounter);
            }
            if (!TextUtils.isEmpty((CharSequence)messageTitle)) {
                eventProperties.put("messageTitle", (Object)messageTitle);
            }
            if (!TextUtils.isEmpty((CharSequence)messageId)) {
                eventProperties.put("messageId", (Object)messageId);
            }
            if (!TextUtils.isEmpty((CharSequence)pushType)) {
                eventProperties.put("pushType", (Object)pushType);
            }
            if (!TextUtils.isEmpty((CharSequence)notificationType)) {
                eventProperties.put("notificationType", (Object)notificationType);
            }
            if (!TextUtils.isEmpty((CharSequence)(publisher = this.sharedLocalStorage.getPublisher()))) {
                eventProperties.put("publisher", (Object)publisher);
            }
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("getEventProperties: parsing issue [" + e.getMessage() + "]"), (Throwable)e);
        }
        return eventProperties;
    }

    private JSONObject getUserProperties(@NonNull Context appContext) {
        JSONObject userProperties = new JSONObject();
        try {
            userProperties.put("appId", (Object)appContext.getPackageName());
            userProperties.put("appVersion", (Object)TBDeviceInfoUtil.getAppVersion(appContext));
            userProperties.put("sdk+(TaboolaPlus)version", (Object)"1.3.5");
            userProperties.put("sdk(TaboolaApi)version", (Object)"2.3.7");
            userProperties.put("simCountry", (Object)TBDeviceInfoUtil.getSimCountry(this.sharedLocalStorage, appContext));
            String publisher = this.sharedLocalStorage.getPublisher();
            if (publisher != null && !publisher.isEmpty()) {
                userProperties.put("publisher", (Object)publisher);
            }
            String abTestVariant = this.sharedLocalStorage.getConfigVariant();
            userProperties.put("configVariant", (Object)abTestVariant);
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("getUserProperties: parsing issue [" + e.getMessage() + "]"), (Throwable)e);
        }
        return userProperties;
    }

    private void broadcastEvent(EventProperties eventProperties) {
        try {
            Intent intent = new Intent();
            intent.setAction(TB_ANALYTICS_ACTION_NAME);
            intent.setPackage(this.appContext.getPackageName());
            intent.putExtra(TB_ANALYTICS_KEY_EVENT_NAME, eventProperties.getEventName());
            JSONObject eventsProperties = this.getEventProperties(this.appContext, eventProperties.getPlacement(), eventProperties.getResponseItemCount(), eventProperties.getError(), eventProperties.getUrl(), eventProperties.isclickIgnored(), eventProperties.getCollapsedNotificationLayout(), eventProperties.getExpandedNotificationLayout(), eventProperties.isBlocked(), eventProperties.isDeviceLocked(), eventProperties.isTrendingItem(), eventProperties.getUiMode(), eventProperties.getExceptionMessage(), eventProperties.getExceptionCount(), eventProperties.getExceptionCountPeriodMs(), eventProperties.getExceptionStackTrace(), eventProperties.getNewNotificationEngagementGroupName(), eventProperties.getPreviousNotificationEngagementGroupName(), eventProperties.getRecommendationItemId(), eventProperties.getErrorMessage(), eventProperties.getRandomCounter(), eventProperties.getMessageTitle(), eventProperties.getMessageId(), eventProperties.getPushType(), eventProperties.getNotificationType());
            intent.putExtra(TB_ANALYTICS_KEY_EVENT_PROPERTIES, eventsProperties.toString());
            if (eventProperties.getResponseItemCount() != -1) {
                intent.putExtra(TB_ANALYTICS_KEY_RESPONSE_ITEM_COUNT, eventProperties.getResponseItemCount());
            }
            JSONObject userProperties = this.getUserProperties(this.appContext);
            intent.putExtra(TB_ANALYTICS_KEY_USER_PROPERTIES, userProperties.toString());
            this.appContext.sendBroadcast(intent);
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("broadcastEvent fail [" + e.getMessage() + "]"), (Throwable)e);
        }
    }

    public void sendTaboolaApiNotInitializedEvent(@Nullable String info) {
        Log.e((String)TAG, (String)("TaboolaApiNotInitializedEvent: " + info));
        final EventProperties eventProperties = new EventProperties.Builder(TABOOLA_API_NOT_INITIALIZED_EVENT, true).setError(info).build();
        this.networkExecutor.execute(new Runnable(){

            @Override
            public void run() {
                SharedAnalyticsManager.this.sendEventToKusto(SharedAnalyticsManager.this.appContext, eventProperties);
            }
        });
    }

    public static void sendTaboolaApiNotInitializedEventWithoutContext(@Nullable String info) {
        Log.e((String)TAG, (String)("TaboolaApiNotInitializedEvent: " + info));
        final EventProperties eventProperties = new EventProperties.Builder(TABOOLA_API_NOT_INITIALIZED_EVENT, true).setError(info).build();
        new Thread(new Runnable(){

            @Override
            public void run() {
                SharedAnalyticsManager.sendEventToKusto(eventProperties);
            }
        }).start();
    }

    public void sendCheckNotificationDisabledStatusEvent(boolean isBlocked) {
        long lastCheckNotificationDisabledStatusEventTime = this.sharedLocalStorage.getLastCheckNotificationDisabledStatusEventTime();
        if (System.currentTimeMillis() - lastCheckNotificationDisabledStatusEventTime > 86400000L && isBlocked) {
            EventProperties eventProperties = new EventProperties.Builder(CHECK_NOTIFICATION_DISABLED_STATUS_EVENT_V3, false).setIsBlocked(true).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).build();
            this.sendEvent(eventProperties);
            this.sharedLocalStorage.setLastCheckNotificationDisabledStatusEventTime(System.currentTimeMillis());
        }
    }

    public void sendNotificationEnabledBySystemEvent() {
        EventProperties eventProperties = new EventProperties.Builder(NOTIFICATION_ENABLED_BY_SYSTEM_EVENT, false).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).build();
        this.sendEvent(eventProperties);
    }

    public void sendNotificationDisabledBySystemEvent() {
        EventProperties eventProperties = new EventProperties.Builder(NOTIFICATION_DISABLED_BY_SYSTEM_EVENT, false).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).build();
        this.sendEvent(eventProperties);
    }

    public void sendNotificationConfigRefreshedEvent() {
        String previousConfig = this.sharedLocalStorage.getPreviousConfig();
        String currentConfig = this.sharedLocalStorage.getCurrentConfig();
        if (previousConfig == null || currentConfig == null || !currentConfig.equals(previousConfig)) {
            EventProperties eventProperties = new EventProperties.Builder(NOTIFICATION_CONFIG_REFRESHED_EVENT, false).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).build();
            this.sendEvent(eventProperties);
        }
    }
}

