/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.plus.content.ContentConfig;
import com.taboola.android.plus.notification.GetMultipleCategoriesInteractor;
import com.taboola.android.plus.notification.NotificationItem;
import com.taboola.android.plus.notification.ReadMoreNotificationItem;
import com.taboola.android.plus.notification.TBContent;
import com.taboola.android.plus.notification.TBNotificationAnalyticsManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NotificationRemoteRepository {
    private static final String TAG = NotificationRemoteRepository.class.getSimpleName();
    static final String READ_MORE_PLACEMENT_KEY = "read_more";
    private Context applicationContext;

    public NotificationRemoteRepository(@NonNull Context applicationContext) {
        this.applicationContext = applicationContext;
    }

    void getNotificationContent(ContentConfig contentConfig, String contentPlacementName, List<String> contentCategories, int numberOfContentItems, @Nullable String readMorePlacementName, int imageWidth, int imageHeight, TBNotificationAnalyticsManager analyticsManager, final OnNotificationContentFetchedCallback callback) {
        ArrayList<String> categorizedPlacementNames = new ArrayList<String>();
        for (String categoryName : contentCategories) {
            String categorizedPlacementName = contentConfig.getCategorizedPlacementName(contentPlacementName, categoryName);
            if (categorizedPlacementName.isEmpty()) continue;
            categorizedPlacementNames.add(categorizedPlacementName);
        }
        if (categorizedPlacementNames.isEmpty()) {
            callback.onNotificationContentFailed(new Throwable("No categories selected"));
            Log.w((String)TAG, (String)"getNewContent: no valid categories were selected");
            return;
        }
        new GetMultipleCategoriesInteractor(this.applicationContext).execute(categorizedPlacementNames, numberOfContentItems, readMorePlacementName, imageHeight, imageWidth, analyticsManager, new GetMultipleCategoriesInteractor.GetNewNotificationContentCallback(){

            @Override
            public void onContentFetched(Map<String, List<TBPlacement>> contentFromRemote) {
                NotificationRemoteRepository.this.onContentFetched(contentFromRemote, callback);
            }

            @Override
            public void onContentFailed(Throwable throwable) {
                callback.onNotificationContentFailed(throwable);
            }
        });
    }

    private void onContentFetched(@NonNull Map<String, List<TBPlacement>> content, OnNotificationContentFetchedCallback callback) {
        ReadMoreNotificationItem readMoreNotificationItem = null;
        List<TBPlacement> readMorePlacementContainer = content.get(READ_MORE_PLACEMENT_KEY);
        if (readMorePlacementContainer != null) {
            TBPlacement readMorePlacement;
            content.remove(READ_MORE_PLACEMENT_KEY);
            List<TBPlacement> contentPlacements = content.entrySet().iterator().next().getValue();
            if (readMorePlacementContainer.size() > 0 && contentPlacements.size() > 0 && (readMorePlacement = readMorePlacementContainer.get(0)) != null) {
                TBPlacement tBPlacement = contentPlacements.get(contentPlacements.size() - 1);
                contentPlacements.remove(tBPlacement);
                readMoreNotificationItem = new ReadMoreNotificationItem(tBPlacement, readMorePlacement);
            }
        }
        ArrayList allPlacements = new ArrayList();
        for (Map.Entry<String, List<TBPlacement>> entry : content.entrySet()) {
            allPlacements.addAll(entry.getValue());
        }
        ArrayList<NotificationItem> notificationItems = new ArrayList<NotificationItem>();
        for (TBPlacement item : allPlacements) {
            notificationItems.add(new NotificationItem(item));
        }
        TBContent tBContent = new TBContent(notificationItems, readMoreNotificationItem);
        callback.onNotificationContentFetched(tBContent);
    }

    public static interface OnNotificationContentFetchedCallback {
        public void onNotificationContentFetched(@NonNull TBContent var1);

        public void onNotificationContentFailed(Throwable var1);
    }
}

