/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.homeScreenNews;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.util.Log;
import com.taboola.android.plus.ConfigManager;
import com.taboola.android.plus.SdkPlusConfig;
import com.taboola.android.plus.content.LanguagesConfig;
import com.taboola.android.plus.homeScreenNews.HomeScreenConfig;
import com.taboola.android.plus.homeScreenNews.HomeScreenLocalStorage;
import com.taboola.android.plus.homeScreenNews.HsnRefreshJob;
import com.taboola.android.plus.homeScreenNews.TBHomeScreenNewsManager;
import com.taboola.android.plus.shared.ConditionCheckUtil;
import com.taboola.android.plus.shared.SharedLocalStorage;

@RequiresApi(api=21)
public class HsnRetryReceiver
extends BroadcastReceiver {
    private static final String TAG = HsnRetryReceiver.class.getSimpleName();
    static final String INTENT_KEY_REQUEST_CODE = "intent_key_request_code";
    static final int REQUEST_CODE_RESCHEDULE = 1000;

    public void onReceive(final Context context, Intent intent) {
        if (Build.VERSION.SDK_INT < 21) {
            Log.e((String)TAG, (String)"onReceive: Android version is less than LOLLIPOP. RetryReceiver Shouldn't have been launched.");
            return;
        }
        Log.d((String)TAG, (String)"onReceive() called ");
        int reqCode = intent.getIntExtra(INTENT_KEY_REQUEST_CODE, -1);
        if (reqCode != 1000) {
            throw new IllegalStateException("Illegal request code");
        }
        if (!ConditionCheckUtil.isNetworkAvailable(context)) {
            Log.i((String)TAG, (String)"onReceive:  network is unavailable");
        } else {
            SharedLocalStorage sharedLocalStorage = new SharedLocalStorage(context);
            ConfigManager.getCurrentConfigs(sharedLocalStorage, context.getApplicationContext(), sharedLocalStorage.getPublisher(), sharedLocalStorage.getConfigId(), new ConfigManager.OnGetAllConfigsCallback(){

                @Override
                public void onConfigsFetched(SdkPlusConfig config, LanguagesConfig languagesConfig) {
                    Log.d((String)TAG, (String)("onConfigsFetched() called with: config = [" + config + "], languagesConfig = [" + languagesConfig + "]"));
                    HsnRetryReceiver.this.onConfigFetched(context.getApplicationContext(), config.getHomeScreenConfig());
                }

                @Override
                public void onConfigsFailed(Throwable throwable) {
                    Log.e((String)TAG, (String)"onConfigsFailed: ", (Throwable)throwable);
                }
            });
        }
    }

    private void onConfigFetched(Context appContext, HomeScreenConfig homeScreenConfig) {
        HomeScreenLocalStorage homeScreenLocalStorage = new HomeScreenLocalStorage(appContext);
        if (ConditionCheckUtil.didMinTriggerIntervalPass(homeScreenLocalStorage.getLastRunningHomeScreenTime(), homeScreenConfig.getHomeScreenTriggerIntervalMs(), System.currentTimeMillis())) {
            if (!ConditionCheckUtil.isTriggerPerDayMaxCountReached(homeScreenConfig.getMaxTriggerCountPerDay(), homeScreenLocalStorage.getCountOfRunningHomeScreenToday())) {
                boolean wasShownSuccessfully = TBHomeScreenNewsManager.triggerHsnIfNeeded(appContext, homeScreenConfig);
                if (wasShownSuccessfully) {
                    HsnRefreshJob.reschedulePeriodicInvitation(appContext, homeScreenConfig.getHomeScreenRefreshIntervalMs());
                }
            } else {
                Log.i((String)TAG, (String)"onConfigsFetched: Daily limit is reached, not showing feed invitation");
            }
        } else {
            Log.i((String)TAG, (String)"onConfigsFetched: Min trigger interval isn't reached, not showing feed invitation");
        }
    }
}

