/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.homeScreenNews;

import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.Log;
import com.taboola.android.plus.ConfigManager;
import com.taboola.android.plus.SdkPlusConfig;
import com.taboola.android.plus.content.LanguagesConfig;
import com.taboola.android.plus.homeScreenNews.HomeScreenConfig;
import com.taboola.android.plus.homeScreenNews.HomeScreenLocalRepository;
import com.taboola.android.plus.homeScreenNews.HomeScreenLocalStorage;
import com.taboola.android.plus.homeScreenNews.TBHomeScreenNewsManager;
import com.taboola.android.plus.shared.ConditionCheckUtil;
import com.taboola.android.plus.shared.SharedLocalStorage;

@RequiresApi(api=21)
public class HsnRefreshJob
extends JobService {
    private static final String TAG = HsnRefreshJob.class.getSimpleName();
    private static final int JOB_ID = 64879728;
    private static final long REFRESH_JOB_MINIMUM_INTERVAL_MS = 900001L;

    static void schedulePeriodicInvitation(@NonNull Context context, long refreshIntervalMs) {
        Log.d((String)TAG, (String)"schedulePeriodicInvitation() called");
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        ComponentName componentName = new ComponentName(context, HsnRefreshJob.class);
        HomeScreenLocalRepository.setLastUsedInvitationIntervalMs(context, refreshIntervalMs);
        long actualRefreshInterval = Math.max(900001L, refreshIntervalMs);
        JobInfo.Builder builder = new JobInfo.Builder(64879728, componentName);
        builder.setPeriodic(actualRefreshInterval);
        builder.setPersisted(true);
        jobScheduler.schedule(builder.build());
    }

    static void reschedulePeriodicInvitation(Context context, long refreshIntervalMs) {
        HsnRefreshJob.cancelPeriodicInvitation(context);
        HsnRefreshJob.schedulePeriodicInvitation(context, refreshIntervalMs);
    }

    static void cancelPeriodicInvitation(Context context) {
        Log.d((String)TAG, (String)"cancelPeriodicInvitation() called");
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        if (jobScheduler != null) {
            jobScheduler.cancel(64879728);
        }
    }

    public boolean onStartJob(final JobParameters params) {
        Log.d((String)TAG, (String)"onStartJob() called");
        if (!ConditionCheckUtil.isNetworkAvailable(this.getApplicationContext())) {
            Log.i((String)TAG, (String)"onStartJob: network is unavailable");
            return false;
        }
        SharedLocalStorage sharedLocalStorage = new SharedLocalStorage(this.getApplicationContext());
        ConfigManager.getCurrentConfigs(sharedLocalStorage, this.getApplicationContext(), sharedLocalStorage.getPublisher(), sharedLocalStorage.getConfigId(), new ConfigManager.OnGetAllConfigsCallback(){

            @Override
            public void onConfigsFetched(SdkPlusConfig config, LanguagesConfig languagesConfig) {
                HsnRefreshJob.this.onConfigFetched(config.getHomeScreenConfig());
                HsnRefreshJob.this.jobFinished(params, false);
            }

            @Override
            public void onConfigsFailed(Throwable throwable) {
                Log.w((String)TAG, (String)"onConfigsFailed: ", (Throwable)throwable);
                HsnRefreshJob.this.jobFinished(params, false);
            }
        });
        return true;
    }

    private void onConfigFetched(HomeScreenConfig homeScreenConfig) {
        HomeScreenLocalStorage homeScreenLocalStorage = new HomeScreenLocalStorage(this.getApplicationContext());
        if (TBHomeScreenNewsManager.didRefreshIntervalPass(this.getApplicationContext(), homeScreenConfig.getHomeScreenRefreshIntervalMs())) {
            if (ConditionCheckUtil.didMinTriggerIntervalPass(homeScreenLocalStorage.getLastRunningHomeScreenTime(), homeScreenConfig.getHomeScreenTriggerIntervalMs(), System.currentTimeMillis())) {
                if (!ConditionCheckUtil.isTriggerPerDayMaxCountReached(homeScreenConfig.getMaxTriggerCountPerDay(), homeScreenLocalStorage.getCountOfRunningHomeScreenToday())) {
                    TBHomeScreenNewsManager.triggerHsnIfNeeded(this.getApplicationContext(), homeScreenConfig);
                } else {
                    Log.i((String)TAG, (String)"onStartJob: Daily limit is reached, not showing feed invitation");
                }
            } else {
                Log.i((String)TAG, (String)"onStartJob:  Min trigger interval didn't pass, not showing feed invitation");
            }
        } else {
            Log.v((String)TAG, (String)"onStartJob: refresh interval didn't pass");
        }
    }

    public boolean onStopJob(JobParameters params) {
        return false;
    }

    static boolean isJobRunning(@NonNull Context context) {
        JobScheduler scheduler = (JobScheduler)context.getSystemService("jobscheduler");
        if (scheduler != null) {
            for (JobInfo jobInfo : scheduler.getAllPendingJobs()) {
                if (jobInfo.getId() != 64879728) continue;
                return true;
            }
        }
        return false;
    }
}

