/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.RequiresApi;
import com.taboola.android.plus.notification.TBNotificationRefreshJob;
import com.taboola.android.plus.notification.TBNotificationStateReceiver;
import java.util.List;

class NotificationBackgroundManager {
    private final Context context;
    private final PendingIntent contentSwitchPendingIntent;

    NotificationBackgroundManager(Context context) {
        this.context = context.getApplicationContext();
        this.contentSwitchPendingIntent = this.getPendingIntentForAutoSwitch(context);
    }

    @RequiresApi(api=21)
    void schedulePeriodicRefresh(List<String> categories, int refreshIntervalMs) {
        if (categories != null && !categories.isEmpty()) {
            TBNotificationRefreshJob.schedulePeriodicRefresh(this.context, categories, refreshIntervalMs);
        }
    }

    @RequiresApi(api=21)
    private void cancelPeriodicRefresh() {
        TBNotificationRefreshJob.cancelPeriodicRefresh(this.context);
    }

    @RequiresApi(api=21)
    boolean isPeriodicRefreshRunning() {
        return TBNotificationRefreshJob.isTaskRunning(this.context);
    }

    void scheduleContentSwitchTimer(int switchContentIntervalMs) {
        AlarmManager alarmManager = (AlarmManager)this.context.getSystemService("alarm");
        alarmManager.set(1, System.currentTimeMillis() + (long)switchContentIntervalMs, this.contentSwitchPendingIntent);
    }

    void cancelContentSwitchTimer() {
        AlarmManager alarmManager = (AlarmManager)this.context.getSystemService("alarm");
        alarmManager.cancel(this.contentSwitchPendingIntent);
    }

    @RequiresApi(api=21)
    void stopAllBackgroundTasks() {
        this.cancelPeriodicRefresh();
        this.cancelContentSwitchTimer();
    }

    private PendingIntent getPendingIntentForAutoSwitch(Context context) {
        Intent intent = new Intent(context, TBNotificationStateReceiver.class);
        Bundle extras = new Bundle();
        extras.putInt("intent_key_request_code", 3500);
        intent.putExtras(extras);
        return PendingIntent.getBroadcast((Context)context, (int)3500, (Intent)intent, (int)0x8000000);
    }
}

