/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.shared.network.handlers;

import android.support.annotation.Keep;
import android.util.Log;
import com.taboola.lightnetwork.dynamic_url.DynamicRequest;
import com.taboola.lightnetwork.dynamic_url.NetworkExecutable;
import com.taboola.lightnetwork.dynamic_url.annotations.Body;
import com.taboola.lightnetwork.dynamic_url.annotations.POST;
import com.taboola.lightnetwork.protocols.http.HttpError;
import com.taboola.lightnetwork.protocols.http.HttpManager;
import org.json.JSONObject;

@Keep
public class KibanaHandler {
    private static final String TAG = "KibanaHandler";
    private static final String KIBANA_BASE_URL = "https://vidanalytics.taboola.com/putes";
    private static final String KIBANA_INDEX_SUFFIX_GUEH = "/sdk_gueh_exception";
    private static final String KIBANA_INDEX_SUFFIX_EVENT = "/mobile";
    private HttpManager mHttpManager;
    private KibanaApiService mKibanaApiService;

    public void setHttpManager(HttpManager httpManager) {
        this.mHttpManager = httpManager;
        this.mKibanaApiService = (KibanaApiService)new NetworkExecutable(httpManager, KIBANA_BASE_URL).create(KibanaApiService.class);
    }

    public void sendEvent(JSONObject eventJsonBody, HttpManager.NetworkResponse networkResponse) {
        block2: {
            try {
                DynamicRequest request = this.mKibanaApiService.sendEvent(eventJsonBody);
                request.execute(networkResponse);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("sendEvent: error " + e.getLocalizedMessage()), (Throwable)e);
                if (networkResponse == null) break block2;
                networkResponse.onError(new HttpError(e.getLocalizedMessage()));
            }
        }
    }

    public void sendGUEHExceptionToKibana(JSONObject exceptionReportJsonObject, HttpManager.NetworkResponse networkResponse) {
        block2: {
            try {
                DynamicRequest request = this.mKibanaApiService.sendGUEHExceptionToKibana(exceptionReportJsonObject);
                request.execute(networkResponse);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("sendEvent: error " + e.getLocalizedMessage()), (Throwable)e);
                if (networkResponse == null) break block2;
                networkResponse.onError(new HttpError(e.getLocalizedMessage()));
            }
        }
    }

    static interface KibanaApiService {
        @POST(value="/sdk_gueh_exception")
        public DynamicRequest sendGUEHExceptionToKibana(@Body JSONObject var1);

        @POST(value="/mobile")
        public DynamicRequest sendEvent(@Body JSONObject var1);
    }
}

