/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification.killSwitch;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.v4.util.Pair;
import android.text.TextUtils;
import com.taboola.android.global_components.gueh.TaboolaExceptionHandler;
import com.taboola.android.plus.notification.TBNotificationAnalyticsManager;
import com.taboola.android.plus.notification.killSwitch.FrequentCrashBlockConfig;
import com.taboola.android.plus.notification.killSwitch.KillSwitchStorage;
import com.taboola.android.plus.notification.killSwitch.KillSwitchUtil;
import com.taboola.android.utils.Logger;
import java.util.ArrayList;
import java.util.Arrays;

public class SdkPlusExceptionHandler
extends TaboolaExceptionHandler {
    public static final String TAG = "SdkPlusExceptionHandler";
    private static final String TABOOLA_SDK_PLUS_PKG = "com.taboola.android.plus";
    private static final String LAST_CRASH_MSG = "SdkPlusExceptionHandler.last_crash_detected_msg";
    private static final String LAST_CRASH_TRACE = "SdkPlusExceptionHandler.last_crash_detected_trace";
    private final Context applicationContext;
    private final FrequentCrashBlockConfig frequentCrashBlockConfig;
    private SharedPreferences mSharedPreferences;

    public SdkPlusExceptionHandler(@NonNull Context applicationContext, @NonNull FrequentCrashBlockConfig frequentCrashBlockConfig) {
        this.applicationContext = applicationContext;
        this.frequentCrashBlockConfig = frequentCrashBlockConfig;
        this.mSharedPreferences = SdkPlusExceptionHandler.getPreferences(applicationContext);
    }

    public boolean isHandling(Throwable throwable) {
        Throwable tmpThrowable = throwable;
        ArrayList<StackTraceElement> allElements = new ArrayList<StackTraceElement>(Arrays.asList(tmpThrowable.getStackTrace()));
        while (tmpThrowable.getCause() != null) {
            allElements.addAll(Arrays.asList(tmpThrowable.getCause().getStackTrace()));
            tmpThrowable = tmpThrowable.getCause();
        }
        return KillSwitchUtil.isNotificationException(throwable) || this.searchElementsForPackageName(allElements);
    }

    private boolean searchElementsForPackageName(ArrayList<StackTraceElement> elements) {
        for (StackTraceElement ste : elements) {
            if (!ste.getClassName().contains(TABOOLA_SDK_PLUS_PKG)) continue;
            return true;
        }
        return false;
    }

    public void handle(Throwable throwable) {
        String exceptionMessage = throwable.getLocalizedMessage();
        Logger.e((String)TAG, (String)("Exception message: " + exceptionMessage));
        this.sentToAnalyticsManager(throwable);
    }

    private void sentToAnalyticsManager(Throwable throwable) {
        KillSwitchStorage killSwitchStorage = new KillSwitchStorage(this.applicationContext);
        long currentTimestamp = System.currentTimeMillis();
        killSwitchStorage.addExceptionOccurred(currentTimestamp);
        int currentExceptionCountForPeriod = killSwitchStorage.getCurrentExceptionCountForPeriod(this.frequentCrashBlockConfig.getExceptionCountPeriodMs());
        Logger.e((String)TAG, (String)("handleException: currentExceptionCountForPeriod: " + currentExceptionCountForPeriod));
        long exceptionCountThreshold = this.frequentCrashBlockConfig.getExceptionCountThreshold();
        Logger.e((String)TAG, (String)("handleException: exceptionCountThreshold: " + exceptionCountThreshold));
        TBNotificationAnalyticsManager analyticsManager = new TBNotificationAnalyticsManager(this.applicationContext);
        if ((long)currentExceptionCountForPeriod > exceptionCountThreshold) {
            Logger.e((String)TAG, (String)("handleException: more than max allowed " + exceptionCountThreshold + " exceptions were thrown, blocking notifications"));
            killSwitchStorage.setLastNotificationBlockTriggeredTimestamp(currentTimestamp);
            analyticsManager.sendNotificationBlockedByFrequentCrashes(currentExceptionCountForPeriod);
        }
        String exceptionMessage = throwable.getMessage();
        String exceptionStackTrace = Arrays.toString(throwable.getStackTrace());
        analyticsManager.sendUncaughtExceptionEvent(exceptionMessage, exceptionStackTrace, currentExceptionCountForPeriod, this.frequentCrashBlockConfig.getExceptionCountPeriodMs(), this.shouldSendCrashReportToKibana(exceptionMessage, exceptionStackTrace));
    }

    private boolean shouldSendCrashReportToKibana(String newExceptionMessage, String newStackTrace) {
        boolean thisCrashWasReported;
        Pair<String, String> pair = this.getLastCrashDetected();
        String oldExceptionMessage = (String)pair.first;
        String oldStackTrace = (String)pair.second;
        boolean bl = thisCrashWasReported = TextUtils.equals((CharSequence)oldExceptionMessage, (CharSequence)newExceptionMessage) && TextUtils.equals((CharSequence)oldStackTrace, (CharSequence)newStackTrace);
        if (!thisCrashWasReported) {
            this.setLastCrashDetected(newExceptionMessage, newStackTrace);
        }
        return !thisCrashWasReported;
    }

    void setLastCrashDetected(String exceptionMessage, String exceptionStackTrace) {
        this.mSharedPreferences.edit().putString(LAST_CRASH_MSG, exceptionMessage).apply();
        this.mSharedPreferences.edit().putString(LAST_CRASH_TRACE, exceptionStackTrace).apply();
    }

    Pair<String, String> getLastCrashDetected() {
        String exceptionMessage = this.mSharedPreferences.getString(LAST_CRASH_MSG, "");
        String exceptionStackTrace = this.mSharedPreferences.getString(LAST_CRASH_TRACE, "");
        return new Pair((Object)exceptionMessage, (Object)exceptionStackTrace);
    }

    private static SharedPreferences getPreferences(@NonNull Context context) {
        return context.getApplicationContext().getSharedPreferences(TAG, 0);
    }
}

