/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification;

import android.app.KeyguardManager;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.hardware.display.DisplayManager;
import android.location.Address;
import android.location.Geocoder;
import android.location.Location;
import android.location.LocationManager;
import android.os.Build;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.text.format.Formatter;
import android.util.Log;
import android.view.Display;
import com.google.gson.JsonObject;
import com.taboola.android.plus.notification.NotificationConfig;
import com.taboola.android.plus.shared.SharedLocalStorage;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.SdkDetailsHelper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class TBDeviceInfoUtil {
    private static final String TAG = TBDeviceInfoUtil.class.getSimpleName();

    public static String getDeviceName() {
        String manufacturer = Build.MANUFACTURER;
        String model = Build.MODEL;
        if (model.toLowerCase().startsWith(manufacturer.toLowerCase())) {
            return TBDeviceInfoUtil.capitalize(model);
        }
        return TBDeviceInfoUtil.capitalize(manufacturer) + " " + model;
    }

    @Keep
    public static void testNuke() {
        throw new NullPointerException("TestNullPointerException");
    }

    public static String getAppVersion(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static String getCarrier(Context context) {
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        if (manager != null) {
            return manager.getNetworkOperatorName();
        }
        return "";
    }

    @NonNull
    public static String getSimCountry(Context appContext) {
        TelephonyManager tm;
        String isoCode = SdkDetailsHelper.getSimCountryIso((Context)appContext);
        SharedLocalStorage sharedLocalStorage = new SharedLocalStorage(appContext);
        if ((isoCode == null || "undefined".equalsIgnoreCase(isoCode)) && (tm = (TelephonyManager)appContext.getSystemService("phone")) != null) {
            String simCountryIso = tm.getSimCountryIso();
            if (TextUtils.isEmpty((CharSequence)simCountryIso)) {
                isoCode = "undefined";
                Log.w((String)TAG, (String)"getSimCountry: can't get country info");
            } else {
                isoCode = simCountryIso.toLowerCase();
            }
        }
        if (isoCode == null || "undefined".equalsIgnoreCase(isoCode)) {
            isoCode = sharedLocalStorage.getSimCountry() != null && !sharedLocalStorage.getSimCountry().isEmpty() ? sharedLocalStorage.getSimCountry() : "undefined";
        } else {
            sharedLocalStorage.setSimCountry(isoCode);
        }
        return isoCode;
    }

    public static String getLocalIpAddress() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    return Formatter.formatIpAddress((int)inetAddress.hashCode());
                }
            }
        }
        catch (SocketException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static void setLocationData(Context context, JSONObject event) {
        LocationManager locationManager = (LocationManager)context.getSystemService("location");
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 || ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            Log.v((String)TAG, (String)"setLocationData: no location permission granted");
            return;
        }
        try {
            if (locationManager != null) {
                Location location = locationManager.getLastKnownLocation("gps");
                if (location == null) {
                    Log.d((String)TAG, (String)"setLocationData: location is null (Probably GPS_PROVIDER is disabled)");
                    return;
                }
                double longitude = location.getLongitude();
                double latitude = location.getLatitude();
                event.put("location_lat", (double)((float)latitude));
                event.put("location_lng", (double)((float)longitude));
                Geocoder geocoder = new Geocoder(context, Locale.US);
                List addresses = null;
                try {
                    addresses = geocoder.getFromLocation(latitude, longitude, 1);
                    Address address = (Address)addresses.get(0);
                    event.put("country", (Object)address.getCountryName());
                    event.put("region", (Object)address.getAdminArea());
                    event.put("carrier", (Object)address.getLocality());
                }
                catch (IOException e) {
                    Log.w((String)TAG, (String)"setLocationData: failed to get user readable location ", (Throwable)e);
                    e.printStackTrace();
                }
            } else {
                Log.d((String)TAG, (String)"setLocationData: LocationManager is null ");
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"setLocationData: ", (Throwable)e);
            e.printStackTrace();
        }
    }

    public static void setLocationData(Context context, JsonObject event) {
        LocationManager locationManager = (LocationManager)context.getSystemService("location");
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 || ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            Log.v((String)TAG, (String)"setLocationData: no location permission granted");
            return;
        }
        if (locationManager != null) {
            Location location = locationManager.getLastKnownLocation("gps");
            if (location == null) {
                Log.d((String)TAG, (String)"setLocationData: location is null (Probably GPS_PROVIDER is disabled)");
                return;
            }
            double longitude = location.getLongitude();
            double latitude = location.getLatitude();
            event.addProperty("location_lat", (Number)Float.valueOf((float)latitude));
            event.addProperty("location_lng", (Number)Float.valueOf((float)longitude));
            Geocoder geocoder = new Geocoder(context, Locale.US);
            List addresses = null;
            try {
                addresses = geocoder.getFromLocation(latitude, longitude, 1);
                Address address = (Address)addresses.get(0);
                event.addProperty("country", address.getCountryName());
                event.addProperty("region", address.getAdminArea());
                event.addProperty("carrier", address.getLocality());
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)"setLocationData: failed to get user readable location ", (Throwable)e);
                e.printStackTrace();
            }
        } else {
            Log.d((String)TAG, (String)"setLocationData: LocationManager is null ");
        }
    }

    public static void setLocationData(Context context, Map<String, String> map) {
        LocationManager locationManager = (LocationManager)context.getSystemService("location");
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 || ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            Log.v((String)TAG, (String)"setLocationData: no location permission granted");
            return;
        }
        if (locationManager != null) {
            Location location = locationManager.getLastKnownLocation("gps");
            if (location == null) {
                Log.d((String)TAG, (String)"setLocationData: location is null (Probably GPS_PROVIDER is disabled)");
                return;
            }
            double longitude = location.getLongitude();
            double latitude = location.getLatitude();
            map.put("location_lat", String.valueOf(latitude));
            map.put("location_lng", String.valueOf(longitude));
            Geocoder geocoder = new Geocoder(context, Locale.US);
            List addresses = null;
            try {
                addresses = geocoder.getFromLocation(latitude, longitude, 1);
                Address address = (Address)addresses.get(0);
                map.put("country", address.getCountryName());
                map.put("region", address.getAdminArea());
                map.put("carrier", address.getLocality());
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)"setLocationData: failed to get user readable location ", (Throwable)e);
                e.printStackTrace();
            }
        } else {
            Log.d((String)TAG, (String)"setLocationData: LocationManager is null ");
        }
    }

    private static String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        char first = s.charAt(0);
        if (Character.isUpperCase(first)) {
            return s;
        }
        return Character.toUpperCase(first) + s.substring(1);
    }

    public static boolean isDeviceLocked(Context context) {
        boolean isLocked = false;
        KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
        boolean inKeyguardRestrictedInputMode = false;
        if (keyguardManager != null) {
            inKeyguardRestrictedInputMode = keyguardManager.inKeyguardRestrictedInputMode();
        }
        if (inKeyguardRestrictedInputMode) {
            isLocked = true;
        } else {
            DisplayManager displayManager = (DisplayManager)context.getSystemService("display");
            if (displayManager != null) {
                for (Display display : displayManager.getDisplays()) {
                    isLocked = display.getState() != 2;
                }
            }
        }
        return isLocked;
    }

    public static boolean isDeviceSupported(NotificationConfig notificationConfig) {
        String deviceModel = TBDeviceInfoUtil.getDeviceName();
        List<String> notSupportedDevices = notificationConfig.getKillSwitchConfig().getBlockedDevices();
        return !notSupportedDevices.contains(deviceModel);
    }
}

