/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.content;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContentConfig
implements Parcelable {
    private static final String TAG = ContentConfig.class.getSimpleName();
    public static final String CONTENT_CONFIG = "contentConfig";
    private static final String CACHE_EXPIRATION_TIME_MS = "cacheExpirationTimeMs";
    private static final String TABOOLA_API_CONFIG = "taboolaApiConfig";
    private static final String KUSTO_FREQUENCY = "kibanaReportFrequency";
    private static final String PLACEMENTS_MAPPINGS = "placementsMappings";
    private static final String PLACEMENT_NAME = "placementName";
    private static final String CATEGORY_TO_PLACEMENT = "categoryToPlacement";
    @SerializedName(value="kibanaReportFrequency")
    private float kustoReportFrequency = 1.0f;
    @SerializedName(value="cacheExpirationTimeMs")
    private long cacheExpirationTimeMs;
    @SerializedName(value="taboolaApiConfig")
    private TaboolaApiConfig taboolaApiConfig;
    @SerializedName(value="placementsMappings")
    @NonNull
    private List<PlacementsMapping> placementsMappings = new ArrayList<PlacementsMapping>();
    public static final Parcelable.Creator<ContentConfig> CREATOR = new Parcelable.Creator<ContentConfig>(){

        public ContentConfig createFromParcel(Parcel source) {
            return new ContentConfig(source);
        }

        public ContentConfig[] newArray(int size) {
            return new ContentConfig[size];
        }
    };

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(this.kustoReportFrequency);
        dest.writeLong(this.cacheExpirationTimeMs);
        dest.writeParcelable((Parcelable)this.taboolaApiConfig, flags);
        dest.writeTypedList(this.placementsMappings);
    }

    public ContentConfig() {
    }

    protected ContentConfig(Parcel in) {
        this.kustoReportFrequency = in.readFloat();
        this.cacheExpirationTimeMs = in.readLong();
        this.taboolaApiConfig = (TaboolaApiConfig)in.readParcelable(TaboolaApiConfig.class.getClassLoader());
        ArrayList placementsMappingsFromCreator = in.createTypedArrayList(PlacementsMapping.CREATOR);
        this.placementsMappings = placementsMappingsFromCreator != null ? placementsMappingsFromCreator : new ArrayList();
    }

    public TaboolaApiConfig getTaboolaApiConfig() {
        return this.taboolaApiConfig;
    }

    public float getKustoReportFrequency() {
        return this.kustoReportFrequency;
    }

    @Nullable
    public PlacementsMapping getPlacementMappings(String placement) {
        for (PlacementsMapping mapping : this.placementsMappings) {
            if (!mapping.getPlacementName().equalsIgnoreCase(placement)) continue;
            return mapping;
        }
        return null;
    }

    @NonNull
    public String getCategorizedPlacementName(String placement, String category) {
        PlacementsMapping placementMappings = this.getPlacementMappings(placement);
        if (placementMappings != null) {
            String placementName = placementMappings.getCategoryToPlacement().get(category);
            if (placementName != null) {
                return placementName;
            }
            Log.e((String)TAG, (String)("getCategorizedPlacementName: haven't found categorized placement name for " + category));
            return "";
        }
        Log.e((String)TAG, (String)("getCategorizedPlacementName: haven't found categories mappings for " + placement));
        return "";
    }

    public static class PlacementsMapping
    implements Parcelable {
        @SerializedName(value="placementName")
        private String placementName;
        @SerializedName(value="categoryToPlacement")
        private Map<String, String> categoryToPlacement = new HashMap<String, String>();
        public static final Parcelable.Creator<PlacementsMapping> CREATOR = new Parcelable.Creator<PlacementsMapping>(){

            public PlacementsMapping createFromParcel(Parcel source) {
                return new PlacementsMapping(source);
            }

            public PlacementsMapping[] newArray(int size) {
                return new PlacementsMapping[size];
            }
        };

        public PlacementsMapping() {
        }

        protected PlacementsMapping(Parcel in) {
            this.placementName = in.readString();
            in.readMap(this.categoryToPlacement, String.class.getClassLoader());
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.placementName);
            dest.writeMap(this.categoryToPlacement);
        }

        public String getPlacementName() {
            return this.placementName;
        }

        public Map<String, String> getCategoryToPlacement() {
            return this.categoryToPlacement;
        }

        public int describeContents() {
            return 0;
        }
    }

    public static class TaboolaApiConfig
    implements Parcelable {
        private static final String API_KEY = "apiKey";
        private static final String TABOOLA_API_EXTRA_PROPERTIES = "taboolaApiExtraProperties";
        @SerializedName(value="apiKey")
        private String apiKey;
        @SerializedName(value="taboolaApiExtraProperties")
        private HashMap<String, String> taboolaApiExtraProperties = new HashMap();
        public static final Parcelable.Creator<TaboolaApiConfig> CREATOR = new Parcelable.Creator<TaboolaApiConfig>(){

            public TaboolaApiConfig createFromParcel(Parcel source) {
                return new TaboolaApiConfig(source);
            }

            public TaboolaApiConfig[] newArray(int size) {
                return new TaboolaApiConfig[size];
            }
        };

        public String getApiKey() {
            return this.apiKey;
        }

        public HashMap<String, String> getTaboolaApiExtraProperties() {
            return this.taboolaApiExtraProperties;
        }

        public TaboolaApiConfig() {
        }

        protected TaboolaApiConfig(Parcel in) {
            this.apiKey = in.readString();
            in.readMap(this.taboolaApiExtraProperties, String.class.getClassLoader());
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.apiKey);
            dest.writeMap(this.taboolaApiExtraProperties);
        }

        public int describeContents() {
            return 0;
        }
    }
}

