/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.shared;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class TBNotificationExecutors {
    private final Executor mainThreadExecutor;
    private final Executor diskIOExecutor;

    public TBNotificationExecutors() {
        this(new MainThreadExecutor(), Executors.newSingleThreadExecutor());
    }

    private TBNotificationExecutors(Executor mainThreadExecutor, Executor diskIOExecutor) {
        this.mainThreadExecutor = mainThreadExecutor;
        this.diskIOExecutor = diskIOExecutor;
    }

    public Executor getMainThreadExecutor() {
        return this.mainThreadExecutor;
    }

    public Executor getDiskIOExecutor() {
        return this.diskIOExecutor;
    }

    public static class MainThreadExecutor
    implements Executor {
        private final Handler mainThreadHandler = new Handler(Looper.getMainLooper());

        @Override
        public void execute(@NonNull Runnable command) {
            this.mainThreadHandler.post(command);
        }
    }
}

