/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.content;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContentConfig {
    private static final String TAG = ContentConfig.class.getSimpleName();
    public static final String CONTENT_CONFIG = "contentConfig";
    private static final String CACHE_EXPIRATION_TIME_MS = "cacheExpirationTimeMs";
    private static final String TABOOLA_API_CONFIG = "taboolaApiConfig";
    private static final String AMPLITUDE_FREQUENCY = "amplitudeReportFrequency";
    private static final String KUSTO_FREQUENCY = "kibanaReportFrequency";
    private static final String PLACEMENTS_MAPPINGS = "placementsMappings";
    private static final String PLACEMENT_NAME = "placementName";
    private static final String CATEGORY_TO_PLACEMENT = "categoryToPlacement";
    @SerializedName(value="kibanaReportFrequency")
    private float kustoReportFrequency = 1.0f;
    @SerializedName(value="amplitudeReportFrequency")
    private float amplitudeReportFrequency = 1.0f;
    @SerializedName(value="cacheExpirationTimeMs")
    private long cacheExpirationTimeMs;
    @SerializedName(value="taboolaApiConfig")
    private TaboolaApiConfig taboolaApiConfig;
    @SerializedName(value="placementsMappings")
    @NonNull
    private List<PlacementsMapping> placementsMappings = new ArrayList<PlacementsMapping>();

    public TaboolaApiConfig getTaboolaApiConfig() {
        return this.taboolaApiConfig;
    }

    public float getKustoReportFrequency() {
        return this.kustoReportFrequency;
    }

    public float getAmplitudeReportFrequency() {
        return this.amplitudeReportFrequency;
    }

    @Nullable
    public PlacementsMapping getPlacementMappings(String placement) {
        for (PlacementsMapping mapping : this.placementsMappings) {
            if (!mapping.getPlacementName().equalsIgnoreCase(placement)) continue;
            return mapping;
        }
        return null;
    }

    @NonNull
    public String getCategorizedPlacementName(String placement, String category) {
        PlacementsMapping placementMappings = this.getPlacementMappings(placement);
        if (placementMappings != null) {
            String placementName = placementMappings.getCategoryToPlacement().get(category);
            if (placementName != null) {
                return placementName;
            }
            Log.e((String)TAG, (String)("getCategorizedPlacementName: haven't found categorized placement name for " + category));
            return "";
        }
        Log.e((String)TAG, (String)("getCategorizedPlacementName: haven't found categories mappings for " + placement));
        return "";
    }

    public static class PlacementsMapping {
        @SerializedName(value="placementName")
        private String placementName;
        @SerializedName(value="categoryToPlacement")
        private Map<String, String> categoryToPlacement;

        public String getPlacementName() {
            return this.placementName;
        }

        public Map<String, String> getCategoryToPlacement() {
            return this.categoryToPlacement;
        }
    }

    public static class TaboolaApiConfig {
        private static final String API_KEY = "apiKey";
        private static final String TABOOLA_API_EXTRA_PROPERTIES = "taboolaApiExtraProperties";
        @SerializedName(value="apiKey")
        private String apiKey;
        @SerializedName(value="taboolaApiExtraProperties")
        private HashMap<String, String> taboolaApiExtraProperties;

        public String getApiKey() {
            return this.apiKey;
        }

        public HashMap<String, String> getTaboolaApiExtraProperties() {
            return this.taboolaApiExtraProperties;
        }
    }
}

