/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification;

import android.app.Activity;
import android.app.KeyguardManager;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.Log;
import com.taboola.android.plus.R;
import com.taboola.android.plus.notification.TBDeviceInfoUtil;
import com.taboola.android.plus.shared.UrlOpenUtil;

public class TaboolaUnlockActivity
extends Activity {
    private static final String TAG = TaboolaUnlockActivity.class.getSimpleName();
    private int timeElapsedMs = 0;
    private static final int unlockCheckDelayMs = 200;
    private static final int unlockCheckTimeoutMs = 10000;

    public static void launch(Context context, Intent notificationIntent) {
        Intent intent = new Intent(context, TaboolaUnlockActivity.class);
        intent.setFlags(0x10000000);
        intent.putExtra("ClickIntent", (Parcelable)notificationIntent);
        context.startActivity(intent);
    }

    public static void attributionLaunch(Context context) {
        Intent intent = new Intent(context, TaboolaUnlockActivity.class);
        intent.setFlags(0x10000000);
        intent.putExtra("action.attribution.screen.unlock", "action.attribution.screen.unlock");
        context.startActivity(intent);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.layout_progress_activity);
        Log.d((String)TAG, (String)"onCreate: called");
    }

    public void onAttachedToWindow() {
        Log.d((String)TAG, (String)"onAttachedToWindow: called");
        super.onAttachedToWindow();
        this.timeElapsedMs = 0;
        if (Build.VERSION.SDK_INT >= 26) {
            this.dismissKeyGuard();
        } else {
            Log.d((String)TAG, (String)"try to add FLAG_DISMISS_KEYGUARD");
            this.getWindow().addFlags(0x400000);
        }
        final Handler handler = new Handler();
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (TBDeviceInfoUtil.isDeviceLocked(TaboolaUnlockActivity.this.getApplicationContext())) {
                    if (TaboolaUnlockActivity.this.timeElapsedMs >= 10000) {
                        Log.d((String)TAG, (String)": timeout");
                        TaboolaUnlockActivity.this.collapseStatusBar(TaboolaUnlockActivity.this.getApplicationContext());
                        TaboolaUnlockActivity.this.finish();
                    } else {
                        handler.postDelayed((Runnable)this, 200L);
                        TaboolaUnlockActivity.this.timeElapsedMs = TaboolaUnlockActivity.this.timeElapsedMs + 200;
                    }
                } else if (TaboolaUnlockActivity.this.getIntent().hasExtra("ClickIntent")) {
                    TaboolaUnlockActivity.this.startActivity((Intent)TaboolaUnlockActivity.this.getIntent().getParcelableExtra("ClickIntent"));
                } else if (TaboolaUnlockActivity.this.getIntent().hasExtra("action.attribution.screen.unlock")) {
                    UrlOpenUtil.handleAttributionClick(TaboolaUnlockActivity.this.getApplicationContext());
                }
                TaboolaUnlockActivity.this.collapseStatusBar(TaboolaUnlockActivity.this.getApplicationContext());
                TaboolaUnlockActivity.this.finish();
            }
        });
    }

    private void collapseStatusBar(Context applicationContext) {
        Log.d((String)TAG, (String)"collapseStatusBar: ");
        applicationContext.sendBroadcast(new Intent("android.intent.action.CLOSE_SYSTEM_DIALOGS"));
    }

    @RequiresApi(api=26)
    private void dismissKeyGuard() {
        Log.d((String)TAG, (String)"dismissKeyGuard for Version_code_O: called");
        KeyguardManager keyguardManager = (KeyguardManager)this.getSystemService("keyguard");
        keyguardManager.requestDismissKeyguard((Activity)this, new KeyguardManager.KeyguardDismissCallback(){

            public void onDismissError() {
                super.onDismissError();
                Log.w((String)TAG, (String)"onDismissError: keyguard dismiss error");
            }

            public void onDismissSucceeded() {
                super.onDismissSucceeded();
                Log.i((String)TAG, (String)"onDismissSucceeded: keyguard dismiss succeeded");
            }

            public void onDismissCancelled() {
                super.onDismissCancelled();
                Log.i((String)TAG, (String)"onDismissCancelled: keyguard dismiss cancelled");
            }
        });
    }
}

