/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification;

import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.annotation.UiThread;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBRecommendationItem;
import com.taboola.android.api.TaboolaApi;
import com.taboola.android.plus.BridgeInternal;
import com.taboola.android.plus.ConfigManager;
import com.taboola.android.plus.SdkPlusConfig;
import com.taboola.android.plus.TaboolaPlus;
import com.taboola.android.plus.content.LanguagesConfig;
import com.taboola.android.plus.notification.TBDeviceInfoUtil;
import com.taboola.android.plus.notification.TBNotificationAnalyticsManager;
import com.taboola.android.plus.notification.TBNotificationLocalStore;
import com.taboola.android.plus.notification.TBNotificationManager;
import com.taboola.android.plus.notification.TaboolaUnlockActivity;
import com.taboola.android.plus.shared.ConditionCheckUtil;
import com.taboola.android.plus.shared.UrlOpenUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@RequiresApi(api=21)
public class TBNotificationStateReceiver
extends BroadcastReceiver {
    private static final String TAG = TBNotificationStateReceiver.class.getSimpleName();
    public static final String NOTIFICATION_TYPE = "notification_type";
    public static final String CLICK_INTENT = "ClickIntent";
    public static final String ACTION_ATTRIBUTION_SCREEN_UNLOCK = "action.attribution.screen.unlock";
    private static final int NOTIFICATION_ITEM_INDEX = 0;
    private static final long NOTIFICATION_CLICK_DELAY = 3000L;
    private static final long NEXT_CLICK_DELAY = 500L;
    private static final long PREVIOUS_CLICK_DELAY = 500L;
    private static long lastNotificationClickTime = 0L;
    private static long lastNextClickTime = 0L;
    private static long lastPreviousClickTime = 0L;
    private TBNotificationManager notificationManager;
    private TBNotificationAnalyticsManager analyticsManager;
    private TBNotificationLocalStore localStorage;

    public void onReceive(final Context context, final Intent intent) {
        if (intent != null && intent.getExtras() != null) {
            if (Build.VERSION.SDK_INT < 21) {
                Log.e((String)TAG, (String)"onReceive : Android version is less than LOLLIPOP. No events were supposed to be sent.");
                return;
            }
            if (this.notificationManager == null) {
                BridgeInternal.restore(new TaboolaPlus.TaboolaPlusRetrievedCallback(){

                    @Override
                    public void onTaboolaPlusRetrieved(TaboolaPlus taboolaPlus) {
                        TBNotificationStateReceiver.this.notificationManager = taboolaPlus.getNotificationManager();
                        TBNotificationStateReceiver.this.localStorage = TBNotificationStateReceiver.this.notificationManager.getLocalStore();
                        TBNotificationStateReceiver.this.analyticsManager = TBNotificationStateReceiver.this.notificationManager.getAnalyticsManager();
                        if (TaboolaApi.getInstance().isInitialized()) {
                            TBNotificationStateReceiver.this.handleRequest(context, intent);
                        } else {
                            String info = "TBNotificationStateReceiver: onReceive(): onTaboolaPlusRetrieved()";
                            TBNotificationStateReceiver.this.analyticsManager.sendTaboolaApiNotInitializedEvent(info);
                            final HashMap<String, String> extraProperties = TBNotificationStateReceiver.this.localStorage.getTaboolaPlusExtraProperties();
                            ConfigManager.getCurrentConfigs(context, TBNotificationStateReceiver.this.localStorage.getPublisher(), TBNotificationStateReceiver.this.localStorage.getConfigId(), new ConfigManager.OnGetAllConfigsCallback(){

                                @Override
                                public void onConfigsFetched(SdkPlusConfig config, LanguagesConfig languagesConfig) {
                                    BridgeInternal.initTaboolaApi(context, config.getContentConfig(), languagesConfig, extraProperties);
                                    TBNotificationStateReceiver.this.handleRequest(context, intent);
                                }

                                @Override
                                public void onConfigsFailed(Throwable throwable) {
                                    Log.e((String)TAG, (String)"onReceive: failed to handle request : onConfigsFailed: fail to get configs");
                                }
                            });
                        }
                    }
                }, new TaboolaPlus.TaboolaPlusRetrieveFailedCallback(){

                    @Override
                    public void onTaboolaPlusRetrieveFailed(Throwable throwable) {
                        Log.e((String)TAG, (String)("onReceive: failed to handle request : Taboola Plus restore failed : " + throwable.getMessage()));
                    }
                });
            } else {
                this.handleRequest(context, intent);
            }
        }
    }

    private void handleRequest(Context context, Intent intent) {
        int reqCode = intent.getIntExtra("intent_key_request_code", -1);
        switch (reqCode) {
            case 2100: 
            case 2200: {
                this.handleEngagedNotificationAction();
                Log.v((String)TAG, (String)"onReceive: prev");
                if (System.currentTimeMillis() < lastPreviousClickTime + 500L) break;
                ArrayList placements = intent.getParcelableArrayListExtra("com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_PLACEMENT_LIST");
                TBNotificationStateReceiver.reportVisibility(context, this.notificationManager, placements);
                boolean isTrendingItem = intent.getBooleanExtra("com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_IS_TRENDING", false);
                String collapsedNotificationLayout = intent.getStringExtra("com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_COLLAPSED_NOTIFICATION_LAYOUT ");
                String expandedNotificationLayout = intent.getStringExtra("com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_EXPANDED_NOTIFICATION_LAYOUT ");
                this.analyticsManager.sendPrevItemEvent(placements, collapsedNotificationLayout, expandedNotificationLayout, isTrendingItem);
                this.localStorage.setDidClickArrow(true);
                this.notificationManager.renderPrevPage(true);
                lastPreviousClickTime = System.currentTimeMillis();
                break;
            }
            case 3100: 
            case 3200: {
                this.handleEngagedNotificationAction();
                Log.v((String)TAG, (String)"onReceive: next");
                if (System.currentTimeMillis() < lastNextClickTime + 500L) break;
                ArrayList placements = intent.getParcelableArrayListExtra("com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_PLACEMENT_LIST");
                TBNotificationStateReceiver.reportVisibility(context, this.notificationManager, placements);
                boolean isTrendingItem = intent.getBooleanExtra("com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_IS_TRENDING", false);
                String collapsedNotificationLayout = intent.getStringExtra("com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_COLLAPSED_NOTIFICATION_LAYOUT ");
                String expandedNotificationLayout = intent.getStringExtra("com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_EXPANDED_NOTIFICATION_LAYOUT ");
                this.analyticsManager.sendNextItemEvent(placements, collapsedNotificationLayout, expandedNotificationLayout, isTrendingItem);
                this.localStorage.setDidClickArrow(true);
                this.notificationManager.renderNextPage(true);
                lastNextClickTime = System.currentTimeMillis();
                break;
            }
            case 3500: {
                Log.v((String)TAG, (String)"onReceive: auto_switch");
                if (System.currentTimeMillis() < lastNextClickTime + 500L) break;
                this.notificationManager.renderNextPage(false);
                this.analyticsManager.sendAutoNextEvent();
                lastNextClickTime = System.currentTimeMillis();
                break;
            }
            case 3600: {
                Log.w((String)TAG, (String)"onReceive: ImageLoadFailed: removing current item");
                String imageUri = intent.getStringExtra("com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_IMAGE_URI");
                boolean isReadMore = intent.getBooleanExtra("com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_IS_READ_MORE", false);
                this.analyticsManager.sendFailedToLoadImage(imageUri);
                if (TextUtils.isEmpty((CharSequence)imageUri) || imageUri.equals("null") || isReadMore) break;
                this.notificationManager.removePlacement(imageUri);
                break;
            }
            case 4000: {
                this.handleUnengagedNotificationAction();
                Log.v((String)TAG, (String)"onReceive: notification dismissed");
                ArrayList placements = intent.getParcelableArrayListExtra("com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_PLACEMENT_LIST");
                TBNotificationStateReceiver.reportVisibility(context, this.notificationManager, placements);
                boolean isTrendingItem = intent.getBooleanExtra("com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_IS_TRENDING", false);
                String randomThumbnailNumber = intent.getStringExtra("com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_RANDOM_THUMBNAIL_NUMBER");
                String collapsedNotificationLayout = intent.getStringExtra("com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_COLLAPSED_NOTIFICATION_LAYOUT ");
                String expandedNotificationLayout = intent.getStringExtra("com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_EXPANDED_NOTIFICATION_LAYOUT ");
                this.notificationManager.onDismissed(placements, collapsedNotificationLayout, expandedNotificationLayout, isTrendingItem, randomThumbnailNumber);
                break;
            }
            case 5000: {
                this.handleEngagedNotificationAction();
                this.handleItemClick(context, intent, false);
                break;
            }
            case 5100: 
            case 5101: 
            case 5102: 
            case 5200: 
            case 5201: 
            case 5202: 
            case 5203: 
            case 5204: 
            case 5205: {
                this.handleEngagedNotificationAction();
                this.handleItemClick(context, intent, true);
                break;
            }
            case 6100: 
            case 6200: {
                if (!ConditionCheckUtil.isNetworkAvailable(context)) {
                    Toast.makeText((Context)context, (CharSequence)this.notificationManager.getLocalizationStrings().getNoNetworkConnection(), (int)1).show();
                    return;
                }
                this.handleEngagedNotificationAction();
                Log.v((String)TAG, (String)"onReceive: attribution click");
                if (System.currentTimeMillis() < lastNotificationClickTime + 3000L) break;
                ArrayList placements = intent.getParcelableArrayListExtra("com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_PLACEMENT_LIST");
                TBNotificationStateReceiver.reportVisibility(context, this.notificationManager, placements);
                this.collapseStatusBar(context);
                if (TBDeviceInfoUtil.isDeviceLocked(context) && TBDeviceInfoUtil.isCustomScreenUnlockAvailable(context)) {
                    Log.d((String)TAG, (String)"handleRequest: attribution click");
                    TaboolaUnlockActivity.attributionLaunch(context);
                    break;
                }
                UrlOpenUtil.handleAttributionClick(context);
                break;
            }
            default: {
                Log.e((String)TAG, (String)("onReceive: Illegal request code: " + reqCode));
            }
        }
    }

    private void handleEngagedNotificationAction() {
        int countOfEngagedNotifications = this.localStorage.getCountOfEngagedNotifications();
        this.localStorage.setCountOfEngagedNotifications(++countOfEngagedNotifications);
        this.localStorage.setCountOfDismissedNotifications(0);
    }

    private void handleUnengagedNotificationAction() {
        int countOfDismissedNotifications = this.localStorage.getCountOfDismissedNotifications();
        this.localStorage.setCountOfDismissedNotifications(++countOfDismissedNotifications);
        this.localStorage.setCountOfEngagedNotifications(0);
    }

    private void handleItemClick(Context context, Intent intent, boolean shouldUnlockManually) {
        Log.v((String)TAG, (String)"onReceive: item clicked");
        if (System.currentTimeMillis() < lastNotificationClickTime + 3000L) {
            return;
        }
        if (!ConditionCheckUtil.isNetworkAvailable(context)) {
            Toast.makeText((Context)context, (CharSequence)this.notificationManager.getLocalizationStrings().getNoNetworkConnection(), (int)1).show();
            return;
        }
        this.collapseStatusBar(context);
        ArrayList placements = intent.getParcelableArrayListExtra("com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_PLACEMENT_LIST");
        TBNotificationStateReceiver.reportVisibility(context, this.notificationManager, placements);
        Intent clickIntent = new Intent("com.taboola.android.plus.notification.NOTIFICATION_CLICK_EVENT");
        clickIntent.setFlags(0x34000000);
        TBPlacement placement = (TBPlacement)intent.getParcelableExtra("com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_PLACEMENT");
        clickIntent.putExtra("com.taboola.android.plus.notification.NOTIFICATION_CLICK_EVENT_PLACEMENT", (Parcelable)placement);
        clickIntent.putExtra("com.taboola.android.plus.notification.NOTIFICATION_CLICK_EVENT_ITEM_INDEX", 0);
        clickIntent.putExtra(NOTIFICATION_TYPE, "trending");
        clickIntent.setPackage(context.getPackageName());
        String clickUrl = (String)((TBRecommendationItem)placement.getItems().get(0)).getExtraDataMap().get("url");
        String nonClickableUrlMarker = this.localStorage.getNonClickableUrlMarker();
        boolean isTrendingItem = intent.getBooleanExtra("com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_IS_TRENDING", false);
        String randomCounter = intent.getStringExtra("com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_RANDOM_THUMBNAIL_NUMBER");
        try {
            if (shouldUnlockManually && TBDeviceInfoUtil.isDeviceLocked(context)) {
                TaboolaUnlockActivity.launch(context, clickIntent);
            } else {
                context.startActivity(clickIntent);
            }
        }
        catch (ActivityNotFoundException e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
        boolean isClickIgnored = clickUrl.contains(nonClickableUrlMarker) && !nonClickableUrlMarker.isEmpty();
        String collapsedNotificationLayout = intent.getStringExtra("com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_COLLAPSED_NOTIFICATION_LAYOUT ");
        String expandedNotificationLayout = intent.getStringExtra("com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_EXPANDED_NOTIFICATION_LAYOUT ");
        this.analyticsManager.sendTapNotificationEvent(placement, isClickIgnored, collapsedNotificationLayout, expandedNotificationLayout, isTrendingItem, randomCounter);
        if (randomCounter == null) {
            this.notificationManager.removePlacement(placement);
        } else {
            this.notificationManager.dismissNotification();
        }
        lastNotificationClickTime = System.currentTimeMillis();
    }

    private void collapseStatusBar(Context applicationContext) {
        Log.d((String)TAG, (String)"collapseStatusBar: ");
        applicationContext.sendBroadcast(new Intent("android.intent.action.CLOSE_SYSTEM_DIALOGS"));
    }

    @UiThread
    static void reportVisibility(final @NonNull Context appContext, @NonNull TBNotificationManager notificationManager, final @NonNull List<TBPlacement> placementsToReportVisibility) {
        if (TaboolaApi.getInstance().isInitialized()) {
            for (TBPlacement tbPlacement : placementsToReportVisibility) {
                TBRecommendationItem tbRecommendationItem = (TBRecommendationItem)tbPlacement.getItems().get(0);
                tbRecommendationItem.notifyAvailable();
                tbRecommendationItem.notifyVisible();
            }
        } else {
            String info = "TBNotificationStateReceiver: reportVisibility()";
            notificationManager.getAnalyticsManager().sendTaboolaApiNotInitializedEvent(info);
            TBNotificationLocalStore localStorage = notificationManager.getLocalStore();
            final HashMap<String, String> extraProperties = localStorage.getTaboolaPlusExtraProperties();
            ConfigManager.getCurrentConfigs(appContext, localStorage.getPublisher(), localStorage.getConfigId(), new ConfigManager.OnGetAllConfigsCallback(){

                @Override
                public void onConfigsFetched(SdkPlusConfig config, LanguagesConfig languagesConfig) {
                    BridgeInternal.initTaboolaApi(appContext, config.getContentConfig(), languagesConfig, extraProperties);
                    for (TBPlacement tbPlacement : placementsToReportVisibility) {
                        TBRecommendationItem tbRecommendationItem = (TBRecommendationItem)tbPlacement.getItems().get(0);
                        tbRecommendationItem.notifyAvailable();
                        tbRecommendationItem.notifyVisible();
                    }
                }

                @Override
                public void onConfigsFailed(Throwable throwable) {
                    Log.e((String)TAG, (String)"onReceive: failed to handle request : onConfigsFailed: fail to get configs");
                }
            });
        }
    }
}

