/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TypeAdapterTBPlacement;
import com.taboola.android.plus.SdkPlusConfig;
import com.taboola.android.plus.notification.NotificationContentState;
import com.taboola.android.plus.notification.TBContent;
import com.taboola.android.plus.shared.AbstractLocalStorage;
import com.taboola.android.plus.shared.LocalizationStrings;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TBNotificationLocalStore
extends AbstractLocalStorage {
    private static final String SHARED_PREFS_FILE_NAME = "tb_notification_manager";
    private static final String SHARED_PREFS_KEY_TB_CONTENT = "tb_notification_content";
    private static final String SHARED_PREFS_KEY_NOTIFICATION_CONTENT_STATE = "notification_content_state";
    private static final String SHARED_PREFS_KEY_TB_NOTIFICATION_ENABLED = "tb_notification_enabled";
    private static final String SHARED_PREFS_KEY_TB_NOTIFICATION_CATEGORIES = "tb_notification_categories";
    private static final String SHARED_PREFS_KEY_TB_REFRESHED_TIMESTAMP = "tb_notification_refreshed_timestamp";
    private static final String SHARED_PREFS_KEY_TB_ICON_ID = "tb_notification_icon_id";
    private static final String SHARED_PREFS_KEY_APPLICATION_NAME = "tb_notification_application_name";
    private static final String SHARED_PREFS_KEY_ONLY_WIFI_MODE = "tb_only_wifi_mode";
    private static final String SHARED_PREFS_KEY_PUBLISHER = "tb_publisher";
    private static final String SHARED_PREFS_KEY_CONFIG_ID = "tb_config_id";
    private static final String SHARED_PREFS_KEY_CONFIG_VARIANT = "tb_config_variant";
    private static final String SHARED_PREFS_KEY_TABOOLA_PLUS_EXTRA_PROPERTIES = "taboola_plus_extra_properties";
    private static final String SHARED_PREFS_KEY_NON_CLICKABLE_URL_MARKER = "tb_non_clickable_url_marker";
    private static final String SHARED_PREFS_KEY_LAST_EVENT_TIME = "tb_last_event_time";
    private static final String SHARED_PREFS_KEY_DID_CLICK_ARROW = "did_click_arrow";
    private static final String SHARED_PREFS_KEY_NOTIFICATION_EXPANDED = "notification_expanded";
    private static final String SHARED_PREFS_KEY_IS_NOTIFICATION_BLOCK_BY_SYSTEM = "is_notification_block_by_system";
    private static final String SHARED_PREFS_KEY_PREVIOUS_STATE = "previous_state";
    private static final String SHARED_PREFS_KEY_PREVIOUS_CONFIG = "tb_previous_config";
    private static final String SHARED_PREFS_KEY_CURRENT_CONFIG = "tb_current_config";
    private static final String SHARED_PREFS_KEY_UI_MODE = "ui_mode";
    private static final String SHARED_PREFS_KEY_SIM_COUNTRY = "sim_country";
    private static final String SHARED_PREFS_KEY_NOTIFICATION_BLOCKED_BY_CONFIG_EVENT = "notification_blocked_by_config_event";
    private static final String SHARED_PREFS_KEY_LAST_CONTENT_REFRESH_EVENT_TIME = "last_content_refresh_event_time";
    private static final String SHARED_PREFS_KEY_LAST_AUTO_NEXT_ITEM_EVENT_TIME = "last_auto_next_item_event_time";
    private static final String SHARED_PREFS_KEY_LAST_RENDER_EVENT_TIME = "last_render_event_time";
    private static final String SHARED_PREFS_KEY_LAST_FAILED_TO_RENDER_EVENT_TIME = "last_failed_to_render_event_time";
    private static final String SHARED_PREFS_KEY_LAST_CHECK_NOTIFICATION_DISABLED_STATUS_EVENT_TIME = "last_check_notification_disabled_status_event_time";
    private static final String LAST_DISMISS_EVENT_TIMESTAMP = "lastDismissEventTimestamp";
    private static final String CRASHES_EVENTS_NEED_TO_SEND_TO_KUSTO = "crahses_events_need_to_send_to_kusto";
    private static final String CRASHES_EVENTS_NEED_TO_SEND_TO_AMPLITUDE = "crahses_events_need_to_send_to_amplitude";
    private static final String SHARED_PREFS_KEY_IS_AMPLITUDE_ENABLED = "is_amplitude_analytics_enabled";
    private static final String SHARED_PREFS_KEY_IS_KUSTO_ENABLED = "is_kibana_analytics_enabled";
    private static final String LAST_RUNNING_NOTIFICATION_TIME = "last_running_notification_time";
    private static final String COUNT_OF_RENDERED_NOTIFICATIONS_TODAY = "max_notification_trigger_count_per_day";
    private static final String DISMISSED_NOTIFICATIONS_COUNT = "dismissed_notifications_count";
    private static final String ENGAGED_NOTIFICATIONS_COUNT = "engaged_notifications_count";
    private static final String CURRENT_ENGAGED_GROUP_NAME = "current_engaged_group_type";
    private static final String NORMAL_ENGAGED_GROUP = "Normal";
    private static final String SHOULD_SEND_EVENT_USER_ASSIGNED_TO_NOTIFICATION_ENGAGEMENT_GROUP = "should_send_event_user_assigned_to_notification_engagement_group";
    public static final int SHARED_PREFS_KEY_ENABLED_STATE = 1;
    public static final int SHARED_PREFS_KEY_DISABLED_STATE = 0;
    private TBContent cachedContent;
    private NotificationContentState notificationContentState;
    Gson gsonWithAdapter = new GsonBuilder().registerTypeAdapter(LocalizationStrings.class, (Object)new LocalizationStrings.LocalizationStringsJsonAdapter()).create();

    public TBNotificationLocalStore(Context context) {
        super(context, SHARED_PREFS_FILE_NAME);
    }

    boolean isNotificationEnabled() {
        return this.getBoolean(SHARED_PREFS_KEY_TB_NOTIFICATION_ENABLED);
    }

    public void setEnabled(boolean isEnabled) {
        this.putBoolean(SHARED_PREFS_KEY_TB_NOTIFICATION_ENABLED, isEnabled);
    }

    public void setNotificationCategories(@NonNull List<String> notificationCategories) {
        HashSet<String> categoriesSet = new HashSet<String>(notificationCategories);
        this.sharedPreferences.edit().putStringSet(SHARED_PREFS_KEY_TB_NOTIFICATION_CATEGORIES, categoriesSet).apply();
    }

    @NonNull
    public List<String> getNotificationCategories() {
        Set categoriesSet = this.sharedPreferences.getStringSet(SHARED_PREFS_KEY_TB_NOTIFICATION_CATEGORIES, new HashSet());
        return new ArrayList<String>(categoriesSet);
    }

    long getLastEventTime() {
        return this.getLong(SHARED_PREFS_KEY_LAST_EVENT_TIME);
    }

    void setLastEventTime(long lastEventTime) {
        this.putLong(SHARED_PREFS_KEY_LAST_EVENT_TIME, lastEventTime);
    }

    long getLastAutoNextItemEventTime() {
        return this.getLong(SHARED_PREFS_KEY_LAST_AUTO_NEXT_ITEM_EVENT_TIME);
    }

    void setLastAutoNextItemEventTime(long lastTime) {
        this.putLong(SHARED_PREFS_KEY_LAST_AUTO_NEXT_ITEM_EVENT_TIME, lastTime);
    }

    long getLastShownNotificationTimestamp() {
        return this.sharedPreferences.getLong(LAST_RUNNING_NOTIFICATION_TIME, 0L);
    }

    void setLastShownNotificationTime(long time) {
        this.sharedPreferences.edit().putLong(LAST_RUNNING_NOTIFICATION_TIME, time).apply();
    }

    int getCountOfRenderedNotificationsToday() {
        return this.sharedPreferences.getInt(COUNT_OF_RENDERED_NOTIFICATIONS_TODAY, 0);
    }

    void setCountOfRenderedNotificationsToday(int counter) {
        this.sharedPreferences.edit().putInt(COUNT_OF_RENDERED_NOTIFICATIONS_TODAY, counter).apply();
    }

    void setLastContentRefreshEventTime(long lastContentRefreshEventTime) {
        this.putLong(SHARED_PREFS_KEY_LAST_CONTENT_REFRESH_EVENT_TIME, lastContentRefreshEventTime);
    }

    long getLastContentRefreshEventTime() {
        return this.getLong(SHARED_PREFS_KEY_LAST_CONTENT_REFRESH_EVENT_TIME);
    }

    void setLastRenderEventTimestamp(long lastRenderEventTimestamp) {
        this.putLong(SHARED_PREFS_KEY_LAST_RENDER_EVENT_TIME, lastRenderEventTimestamp);
    }

    long getLastRenderEventTimestamp() {
        return this.getLong(SHARED_PREFS_KEY_LAST_RENDER_EVENT_TIME);
    }

    void setLastDismissEventTimestamp(long lastDismissEventTimestamp) {
        this.putLong(LAST_DISMISS_EVENT_TIMESTAMP, lastDismissEventTimestamp);
    }

    long getLastDismissEventTimestamp() {
        return this.getLong(LAST_DISMISS_EVENT_TIMESTAMP);
    }

    void setLastFailedToRenderEventTime(long lastFailedToRenderEventTime) {
        this.putLong(SHARED_PREFS_KEY_LAST_FAILED_TO_RENDER_EVENT_TIME, lastFailedToRenderEventTime);
    }

    long getLastFailedToRenderEventTime() {
        return this.getLong(SHARED_PREFS_KEY_LAST_FAILED_TO_RENDER_EVENT_TIME);
    }

    void setLastCheckNotificationDisabledStatusEventTime(long lastCheckNotificationDisabledStatusEventTime) {
        this.putLong(SHARED_PREFS_KEY_LAST_CHECK_NOTIFICATION_DISABLED_STATUS_EVENT_TIME, lastCheckNotificationDisabledStatusEventTime);
    }

    long getLastCheckNotificationDisabledStatusEventTime() {
        return this.getLong(SHARED_PREFS_KEY_LAST_CHECK_NOTIFICATION_DISABLED_STATUS_EVENT_TIME);
    }

    long getRefreshedTimestamp() {
        return this.getLong(SHARED_PREFS_KEY_TB_REFRESHED_TIMESTAMP);
    }

    void setRefreshedTimestamp(long refreshedTimestamp) {
        this.putLong(SHARED_PREFS_KEY_TB_REFRESHED_TIMESTAMP, refreshedTimestamp);
    }

    public void setAmplitudeAnalyticsEnabled(boolean enabled) {
        this.putBoolean(SHARED_PREFS_KEY_IS_AMPLITUDE_ENABLED, enabled);
    }

    public boolean isAmplitudeEnabled() {
        return this.getBoolean(SHARED_PREFS_KEY_IS_AMPLITUDE_ENABLED);
    }

    public void setKustoAnalyticsEnabled(boolean enabled) {
        this.putBoolean(SHARED_PREFS_KEY_IS_KUSTO_ENABLED, enabled);
    }

    public boolean isKustoEnabled() {
        return this.getBoolean(SHARED_PREFS_KEY_IS_KUSTO_ENABLED);
    }

    public void setPublisher(String publisher) {
        this.putString(SHARED_PREFS_KEY_PUBLISHER, publisher);
    }

    @Nullable
    public String getPublisher() {
        return this.getString(SHARED_PREFS_KEY_PUBLISHER);
    }

    public void setConfigId(String configId) {
        this.putString(SHARED_PREFS_KEY_CONFIG_ID, configId);
    }

    @Nullable
    public String getConfigId() {
        return this.getString(SHARED_PREFS_KEY_CONFIG_ID);
    }

    public void setConfigVariant(String configVariant) {
        this.putString(SHARED_PREFS_KEY_CONFIG_VARIANT, configVariant);
    }

    @NonNull
    public String getConfigVariant() {
        String configVariant = this.getString(SHARED_PREFS_KEY_CONFIG_VARIANT);
        return configVariant == null ? "" : configVariant;
    }

    public void setTaboolaPlusExtraProperties(@Nullable Map<String, String> extraProperties) {
        this.putString(SHARED_PREFS_KEY_TABOOLA_PLUS_EXTRA_PROPERTIES, gson.toJson(extraProperties));
    }

    @Nullable
    public HashMap<String, String> getTaboolaPlusExtraProperties() {
        String currentPropertiesStr = this.getString(SHARED_PREFS_KEY_TABOOLA_PLUS_EXTRA_PROPERTIES);
        if (currentPropertiesStr != null) {
            Type type = new TypeToken<HashMap<String, String>>(){}.getType();
            return (HashMap)gson.fromJson(currentPropertiesStr, type);
        }
        return null;
    }

    public void setNonClickableUrlMarker(String nonClickableUrlMarker) {
        this.putString(SHARED_PREFS_KEY_NON_CLICKABLE_URL_MARKER, nonClickableUrlMarker);
    }

    @NonNull
    public String getNonClickableUrlMarker() {
        String marker = this.getString(SHARED_PREFS_KEY_NON_CLICKABLE_URL_MARKER);
        return marker == null ? "" : marker;
    }

    public void setNotificationIcon(int notificationIcon) {
        this.putInt(SHARED_PREFS_KEY_TB_ICON_ID, notificationIcon);
    }

    public void setWifiOnlyModeRuntimeFlag(boolean isOnlyWifi) {
        this.putBoolean(SHARED_PREFS_KEY_ONLY_WIFI_MODE, isOnlyWifi);
    }

    boolean isWifiOnlyModeRuntimeFlag() {
        return this.getBoolean(SHARED_PREFS_KEY_ONLY_WIFI_MODE);
    }

    public void setIsNotificationBlockBySystem(boolean isNotificationBlockBySystem) {
        this.putBoolean(SHARED_PREFS_KEY_IS_NOTIFICATION_BLOCK_BY_SYSTEM, isNotificationBlockBySystem);
    }

    public boolean isNotificationBlockBySystem() {
        return this.getBoolean(SHARED_PREFS_KEY_IS_NOTIFICATION_BLOCK_BY_SYSTEM);
    }

    public int getNotificationIcon() {
        return this.getInt(SHARED_PREFS_KEY_TB_ICON_ID);
    }

    @Nullable
    public String getApplicationName() {
        return this.getString(SHARED_PREFS_KEY_APPLICATION_NAME);
    }

    public void setApplicationName(String applicationName) {
        this.putString(SHARED_PREFS_KEY_APPLICATION_NAME, applicationName);
    }

    boolean getDidClickArrow() {
        return this.getBoolean(SHARED_PREFS_KEY_DID_CLICK_ARROW);
    }

    void setDidClickArrow(boolean didClickArrow) {
        this.putBoolean(SHARED_PREFS_KEY_DID_CLICK_ARROW, didClickArrow);
    }

    void setNotificationExpanded(boolean isNotificationExpanded) {
        this.putBoolean(SHARED_PREFS_KEY_NOTIFICATION_EXPANDED, isNotificationExpanded);
    }

    boolean wasNotificationExpanded() {
        return this.getBoolean(SHARED_PREFS_KEY_NOTIFICATION_EXPANDED);
    }

    void setPreviousState(int previousState) {
        this.putInt(SHARED_PREFS_KEY_PREVIOUS_STATE, previousState);
    }

    int getPreviousState() {
        return this.getInt(SHARED_PREFS_KEY_PREVIOUS_STATE);
    }

    public void setPreviousConfig(String previousConfig) {
        this.putString(SHARED_PREFS_KEY_PREVIOUS_CONFIG, previousConfig);
    }

    @Nullable
    public String getPreviousConfig() {
        return this.getString(SHARED_PREFS_KEY_PREVIOUS_CONFIG);
    }

    @Nullable
    public SdkPlusConfig getPreviousConfigObj() {
        String configJson = this.getString(SHARED_PREFS_KEY_PREVIOUS_CONFIG);
        if (configJson == null || configJson.isEmpty()) {
            return null;
        }
        return (SdkPlusConfig)this.gsonWithAdapter.fromJson(configJson, SdkPlusConfig.class);
    }

    public void setCurrentConfig(SdkPlusConfig currentConfig) {
        this.putString(SHARED_PREFS_KEY_CURRENT_CONFIG, this.gsonWithAdapter.toJson((Object)currentConfig));
    }

    @Nullable
    public String getCurrentConfig() {
        return this.getString(SHARED_PREFS_KEY_CURRENT_CONFIG);
    }

    @Nullable
    public SdkPlusConfig getCurrentConfigObj() {
        String configJson = this.getString(SHARED_PREFS_KEY_CURRENT_CONFIG);
        if (configJson == null || configJson.isEmpty()) {
            return null;
        }
        return (SdkPlusConfig)this.gsonWithAdapter.fromJson(configJson, SdkPlusConfig.class);
    }

    void setUiMode(String UiMode) {
        this.putString(SHARED_PREFS_KEY_UI_MODE, UiMode);
    }

    String getUiMode() {
        return this.getString(SHARED_PREFS_KEY_UI_MODE);
    }

    void setSimCountry(@NonNull String simCountry) {
        this.putString(SHARED_PREFS_KEY_SIM_COUNTRY, simCountry);
    }

    String getSimCountry() {
        return this.getString(SHARED_PREFS_KEY_SIM_COUNTRY);
    }

    void setSendNotificationBlockedByConfigEvent() {
        this.putBoolean(SHARED_PREFS_KEY_NOTIFICATION_BLOCKED_BY_CONFIG_EVENT, true);
    }

    boolean isNotificationBlockedByConfigEventAlreadySend() {
        return this.getBoolean(SHARED_PREFS_KEY_NOTIFICATION_BLOCKED_BY_CONFIG_EVENT);
    }

    void setContent(TBContent content) {
        this.cachedContent = content;
        String contentJson = gson.toJson((Object)content);
        this.putString(SHARED_PREFS_KEY_TB_CONTENT, contentJson);
    }

    @Nullable
    TBContent getContent() {
        if (this.cachedContent != null) {
            return this.cachedContent;
        }
        String currentContentStr = this.getString(SHARED_PREFS_KEY_TB_CONTENT);
        if (currentContentStr != null) {
            Gson gsonWithAdapter = new GsonBuilder().registerTypeAdapter(TBPlacement.class, (Object)new TypeAdapterTBPlacement()).create();
            this.cachedContent = (TBContent)gsonWithAdapter.fromJson(currentContentStr, TBContent.class);
            return this.cachedContent;
        }
        return null;
    }

    @Nullable
    NotificationContentState getNotificationContentState() {
        if (this.notificationContentState != null) {
            return this.notificationContentState;
        }
        String contentStateJson = this.getString(SHARED_PREFS_KEY_NOTIFICATION_CONTENT_STATE);
        if (contentStateJson != null) {
            this.notificationContentState = (NotificationContentState)gson.fromJson(contentStateJson, NotificationContentState.class);
            return this.notificationContentState;
        }
        return null;
    }

    void setNotificationContentState(NotificationContentState notificationContentState) {
        this.notificationContentState = notificationContentState;
        String contentStateJson = gson.toJson((Object)notificationContentState);
        this.putString(SHARED_PREFS_KEY_NOTIFICATION_CONTENT_STATE, contentStateJson);
    }

    void addCrashEventThatNeedSendToKusto(String event) {
        HashSet<String> kustoCrashEventsThatNeedToSend = new HashSet<String>(this.sharedPreferences.getStringSet(CRASHES_EVENTS_NEED_TO_SEND_TO_KUSTO, new HashSet()));
        kustoCrashEventsThatNeedToSend.add(event);
        this.sharedPreferences.edit().putStringSet(CRASHES_EVENTS_NEED_TO_SEND_TO_KUSTO, kustoCrashEventsThatNeedToSend).apply();
    }

    Set<String> getCrashEventsThatNeedSendToKusto() {
        return this.sharedPreferences.getStringSet(CRASHES_EVENTS_NEED_TO_SEND_TO_KUSTO, new HashSet());
    }

    void clearCrashEventsThatNeedSendToKusto() {
        this.sharedPreferences.edit().putStringSet(CRASHES_EVENTS_NEED_TO_SEND_TO_KUSTO, new HashSet()).apply();
    }

    void addCrashEventThatNeedSendToAmlitude(String event) {
        HashSet<String> amplitudeCrashEventsThatNeedToSend = new HashSet<String>(this.sharedPreferences.getStringSet(CRASHES_EVENTS_NEED_TO_SEND_TO_AMPLITUDE, new HashSet()));
        amplitudeCrashEventsThatNeedToSend.add(event);
        this.sharedPreferences.edit().putStringSet(CRASHES_EVENTS_NEED_TO_SEND_TO_AMPLITUDE, amplitudeCrashEventsThatNeedToSend).apply();
    }

    Set<String> getCrashEventsThatNeedSendToAmplitude() {
        return this.sharedPreferences.getStringSet(CRASHES_EVENTS_NEED_TO_SEND_TO_AMPLITUDE, new HashSet());
    }

    void clearCrashEventsThatNeedSendToAmplitude() {
        this.sharedPreferences.edit().putStringSet(CRASHES_EVENTS_NEED_TO_SEND_TO_AMPLITUDE, new HashSet()).apply();
    }

    void setCountOfDismissedNotifications(int countOfDismissedNotifications) {
        this.sharedPreferences.edit().putInt(DISMISSED_NOTIFICATIONS_COUNT, countOfDismissedNotifications).apply();
    }

    int getCountOfDismissedNotifications() {
        return this.sharedPreferences.getInt(DISMISSED_NOTIFICATIONS_COUNT, 0);
    }

    void setCountOfEngagedNotifications(int countOfEngagedNotifications) {
        this.sharedPreferences.edit().putInt(ENGAGED_NOTIFICATIONS_COUNT, countOfEngagedNotifications).apply();
    }

    int getCountOfEngagedNotifications() {
        return this.sharedPreferences.getInt(ENGAGED_NOTIFICATIONS_COUNT, 0);
    }

    void setCurrentEngagedGroupName(String groupName) {
        this.sharedPreferences.edit().putString(CURRENT_ENGAGED_GROUP_NAME, groupName).apply();
    }

    String getCurrentEngagedGroupName() {
        return this.sharedPreferences.getString(CURRENT_ENGAGED_GROUP_NAME, NORMAL_ENGAGED_GROUP);
    }

    void setShouldSendUserAssignedToNotificationEngagmentGroupEvent(boolean shouldSendEvent) {
        this.sharedPreferences.edit().putBoolean(SHOULD_SEND_EVENT_USER_ASSIGNED_TO_NOTIFICATION_ENGAGEMENT_GROUP, shouldSendEvent).apply();
    }

    boolean shouldSendUserAssignedToNotificationEngagmentGroupEvent() {
        return this.sharedPreferences.getBoolean(SHOULD_SEND_EVENT_USER_ASSIGNED_TO_NOTIFICATION_ENGAGEMENT_GROUP, true);
    }
}

