/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBRecommendationItem;
import com.taboola.android.api.TaboolaApi;
import com.taboola.android.plus.BridgeInternal;
import com.taboola.android.plus.notification.EventProperties;
import com.taboola.android.plus.notification.TBDeviceInfoUtil;
import com.taboola.android.plus.notification.TBNotificationExecutors;
import com.taboola.android.plus.notification.TBNotificationLocalStore;
import com.taboola.android.plus.shared.network.SdkPlusNetworkManager;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.network.KibanaUtils;
import com.taboola.lightnetwork.protocols.http.HttpError;
import com.taboola.lightnetwork.protocols.http.HttpManager;
import com.taboola.lightnetwork.protocols.http.HttpResponse;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public class TBNotificationAnalyticsManager {
    public static final String TB_ANALYTICS_ACTION_NAME = "tb.analytics.action.name";
    public static final String TB_ANALYTICS_KEY_EVENT_NAME = "key_event_name";
    public static final String TB_ANALYTICS_KEY_EVENT_PROPERTIES = "key_event_properties";
    public static final String TB_ANALYTICS_KEY_USER_PROPERTIES = "key_user_properties";
    public static final String TB_ANALYTICS_KEY_RESPONSE_ITEM_COUNT = "response_item_count";
    private static final String ENABLED_EVENT = "EnabledEvent";
    private static final String DISABLED_EVENT = "DisabledEvent";
    private static final String HOME_SCREEN_DISPLAYED_EVENT = "HSNDisplayed";
    private static final String HOME_SCREEN_TRIGGERED_EVENT = "HSNTriggered";
    private static final String TABOOLA_API_NOT_INITIALIZED_EVENT = "TBApiNotInit";
    private static final String CONTENT_REFRESH_SUCCESSFUL_EVENT = "ContentRefreshScss";
    private static final String CONTENT_REFRESH_FAILED_EVENT = "ContentRefreshFail";
    private static final String RENDER_EVENT_V2 = "RenderEvent_v2";
    private static final String PUSH_NOTIFICATION_RENDER_EVENT = "PushNotifRender";
    private static final String FAILED_TO_RENDER_EVENT_V2 = "RenderFailed";
    private static final String PUSH_NOTIFICATION_FAILED_TO_RENDER_EVENT = "PushNotifRenderFail";
    private static final String FAILED_TO_LOAD_IMAGE_EVENT = "ImageLoadFail";
    private static final String NEXT_ITEM_EVENT = "NextItemEvent";
    private static final String AUTO_NEXT_ITEM_EVENT_V2 = "AutoNextItem";
    private static final String PREV_ITEM_EVENT = "PrevItemEvent";
    private static final String TAP_NOTIFICATION_EVENT = "TapNotif";
    private static final String TAP_PUSH_NOTIFICATION_EVENT = "TapPushNotif";
    private static final String DISMISSED_EVENT = "DismissedEvent";
    private static final String PUSH_NOTIFICATION_DISMISSED_EVENT = "PushNotifDismiss";
    private static final String NOTIFICATION_DISABLED_BY_SYSTEM_EVENT = "NotifDsbldBySys";
    private static final String NOTIFICATION_ENABLED_BY_SYSTEM_EVENT = "NotifEnbldBySys";
    private static final String UNCAUGHT_EXCEPTION_EVENT = "UncaughtException";
    private static final String NOTIFICATION_BLOCKED_BY_FREQUENT_CRASHES_EVENT = "FrqntCrshBlkdNotif";
    private static final String NOTIFICATION_BLOCKED_BY_CONFIG_EVENT = "CfgBllkdNotif";
    private static final String NOTIFICATION_CONFIG_REFRESHED_EVENT = "NotifCfgRefresh";
    private static final String CHECK_NOTIFICATION_DISABLED_STATUS_EVENT_V3 = "ChkNotifDsbldStatus";
    private static final String USER_NOTIFICATION_ENGAGEMENT_GROUP_PROMOTED = "UserNotifEgmtPromot";
    private static final String USER_NOTIFICATION_ENGAGEMENT_GROUP_DEMOTED = "UserNotifEgmtDemot";
    private static final String USER_ASSIGNED_TO_NOTIFICATION_ENGAGEMENT_GROUP = "usrNotifEgmtGrpSet";
    private static final String INVALID_ITEM_IN_SERVER_RESPONSE = "InvalidItemSvrRes";
    private static final String INVALID_PUSH_NOTIFICATION_ITEM = "InvalidItemSvrRes";
    private static final String COLLAPSED_NOTIFICATION_LAYOUT_PROPERTY_KEY = "collapsedNotificationLayout";
    private static final String EXPANDED_NOTIFICATION_LAYOUT_PROPERTY_KEY = "expandedNotificationLayout";
    private static final String TAG = TBNotificationAnalyticsManager.class.getSimpleName();
    private static final String AMPLITUDE_KEY = "72ff40ebea47f5170845b285b42e0292";
    private static final int KIBANA_REPORT_TIMEOUT = 5;
    private static final String SDK_PLUS_TAG = "SDKPlus";
    private static final Object kustoCrashesDataLock = new Object();
    private static final Object amplitudeCrashesDataLock = new Object();
    private Handler mReportingHandler;
    @NonNull
    private Context appContext;
    @NonNull
    private final TBNotificationLocalStore localStore;
    private final Executor networkExecutor;
    private final Executor mainThreadExecutor;
    private SdkPlusNetworkManager mNetworkManager;

    public TBNotificationAnalyticsManager(@NonNull Context appContext) {
        this(appContext, new TBNotificationLocalStore(appContext));
    }

    public TBNotificationAnalyticsManager(@NonNull Context appContext, @NonNull TBNotificationLocalStore localStore) {
        this.appContext = appContext;
        this.localStore = localStore;
        this.networkExecutor = Executors.newCachedThreadPool();
        Looper looper = this.createReportLooper();
        this.mReportingHandler = new Handler(looper);
        this.mNetworkManager = BridgeInternal.getNetworkManager();
        this.mainThreadExecutor = new TBNotificationExecutors.MainThreadExecutor();
    }

    private Looper createReportLooper() {
        HandlerThread handlerThread = new HandlerThread("SDKPlusExceptionHandler");
        handlerThread.start();
        return handlerThread.getLooper();
    }

    public static void sendTaboolaApiNotInitializedEventWithoutContext(@Nullable String info) {
        Log.e((String)TAG, (String)("TaboolaApiNotInitializedEvent: " + info));
        final EventProperties eventProperties = new EventProperties.Builder(TABOOLA_API_NOT_INITIALIZED_EVENT, true).setError(info).build();
        new Thread(new Runnable(){

            @Override
            public void run() {
                TBNotificationAnalyticsManager.sendEventToKusto(eventProperties);
            }
        }).start();
    }

    public void sendInvalidItemInServerResponseEvent(String errorMessage, String errorDetails, String recommendationItemId) {
        EventProperties eventProperties = new EventProperties.Builder("InvalidItemSvrRes", false).setErrorMessage(errorMessage).setError(errorDetails).setRecommendationItemId(recommendationItemId).build();
        this.sendEvent(eventProperties);
    }

    public void sendInvalidPushItemEvent(String errorMessage, String errorDetails, String messageId) {
        EventProperties eventProperties = new EventProperties.Builder("InvalidItemSvrRes", false).setErrorMessage(errorMessage).setError(errorDetails).setMessageId(messageId).build();
        this.sendEvent(eventProperties);
    }

    void sendEnabledEvent() {
        if (this.localStore.getPreviousState() == 0 || this.localStore.getPreviousState() == -1) {
            EventProperties eventProperties = new EventProperties.Builder(ENABLED_EVENT, true).build();
            this.sendEvent(eventProperties);
            this.localStore.setPreviousState(1);
        }
    }

    void sendDisabledEvent() {
        if (this.localStore.getPreviousState() == 1 || this.localStore.getPreviousState() == -1) {
            EventProperties eventProperties = new EventProperties.Builder(DISABLED_EVENT, true).build();
            this.sendEvent(eventProperties);
            this.localStore.setPreviousState(0);
        }
    }

    public void sendHomeScreenDisplayedEvent() {
        EventProperties eventProperties = new EventProperties.Builder(HOME_SCREEN_DISPLAYED_EVENT, false).build();
        this.sendEvent(eventProperties);
    }

    public void sendHomeScreenTriggeredEvent() {
        EventProperties eventProperties = new EventProperties.Builder(HOME_SCREEN_TRIGGERED_EVENT, false).build();
        this.sendEvent(eventProperties);
    }

    @WorkerThread
    private static void sendEventToKusto(@NonNull EventProperties eventProperties) {
        try {
            JsonObject event = new JsonObject();
            event.addProperty("device_id", "");
            event.addProperty("event_type", eventProperties.getEventName());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);
            event.addProperty("time", sdf.format(new Date(System.currentTimeMillis())));
            event.addProperty("os_name", "Android");
            event.addProperty("platform", "Android");
            event.addProperty("os_version", Build.VERSION.RELEASE);
            event.addProperty("device_model", TBDeviceInfoUtil.getDeviceName());
            event.addProperty("app_version", "");
            event.addProperty("device_manufacturer", Build.MANUFACTURER);
            event.addProperty("device_brand", Build.MANUFACTURER);
            event.addProperty("carrier", "");
            event.addProperty("language", Locale.getDefault().getDisplayLanguage(Locale.US));
            event.addProperty("ip", TBDeviceInfoUtil.getLocalIpAddress());
            event.addProperty("adid", "");
            if (eventProperties.isImplicitEvent()) {
                event.addProperty("session_id", "");
            }
            event.addProperty("sdk+(TaboolaPlus)version", "1.2.2");
            event.addProperty("sdk(TaboolaApi)version", "2.3.5");
            event.addProperty("simCountry", "");
            if (eventProperties.getResponseItemCount() != -1) {
                event.addProperty("responseItemCount", (Number)eventProperties.getResponseItemCount());
            }
            if (eventProperties.getUiMode() != null && !eventProperties.getUiMode().isEmpty()) {
                event.addProperty("itemTitle", eventProperties.getUiMode());
            } else if (eventProperties.getPlacement() != null && !eventProperties.getPlacement().getItems().isEmpty()) {
                event.addProperty("itemTitle", (String)((TBRecommendationItem)eventProperties.getPlacement().getItems().get(0)).getExtraDataMap().get("name"));
            }
            if (eventProperties.getUrl() != null && !eventProperties.getUrl().isEmpty()) {
                event.addProperty("image_url", eventProperties.getUrl());
            }
            if (eventProperties.getError() != null) {
                event.addProperty("error_details", eventProperties.getError());
            }
            if (!TextUtils.isEmpty((CharSequence)eventProperties.getRecommendationItemId())) {
                event.addProperty("recommendationItemId", eventProperties.getRecommendationItemId());
            }
            if (!TextUtils.isEmpty((CharSequence)eventProperties.getErrorMessage())) {
                event.addProperty("errorMessage", eventProperties.getErrorMessage());
            }
            if (eventProperties.isBlocked() != null) {
                event.addProperty("isBlocked", eventProperties.isBlocked());
            }
            if (eventProperties.isDeviceLocked() != null) {
                event.addProperty("isDeviceLocked", eventProperties.isDeviceLocked());
            }
            if (eventProperties.isTrendingItem() != null) {
                event.addProperty("isTrendingItem", eventProperties.isTrendingItem());
            }
            if (eventProperties.isclickIgnored()) {
                event.addProperty("clickIgnored", Boolean.valueOf(true));
            }
            BridgeInternal.getNetworkManager().getKustoHandler().sendEvent(SDK_PLUS_TAG, String.valueOf(event), null);
            Log.v((String)TAG, (String)("sent event to kusto " + eventProperties.getEventName()));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("sendEvent " + e.getMessage()), (Throwable)e);
        }
    }

    public void sendContentRefreshSuccessfulEvent(int responseItemCount) {
        EventProperties eventProperties = new EventProperties.Builder(CONTENT_REFRESH_SUCCESSFUL_EVENT, false).setResponseItemCount(responseItemCount).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).build();
        this.sendEvent(eventProperties);
        this.localStore.setLastContentRefreshEventTime(System.currentTimeMillis());
    }

    void sendContentRefreshFailedEvent() {
        EventProperties eventProperties = new EventProperties.Builder(CONTENT_REFRESH_FAILED_EVENT, false).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).build();
        this.sendEvent(eventProperties);
        this.localStore.setLastContentRefreshEventTime(System.currentTimeMillis());
    }

    void sendRenderEvent(List<TBPlacement> placements, boolean isTrendingItem) {
        long lastRenderEventTime;
        long lastContentRefreshTime = this.localStore.getLastContentRefreshEventTime();
        if (lastContentRefreshTime > (lastRenderEventTime = this.localStore.getLastRenderEventTimestamp())) {
            EventProperties eventProperties;
            if (placements != null && placements.size() > 1) {
                eventProperties = new EventProperties.Builder(RENDER_EVENT_V2, false).setUiMode(this.localStore.getUiMode()).setPlacement(placements.get(0)).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).setIsTrendingItem(isTrendingItem).build();
            } else {
                TBPlacement placement = null;
                if (placements != null && !placements.isEmpty()) {
                    placement = placements.get(0);
                }
                eventProperties = new EventProperties.Builder(RENDER_EVENT_V2, false).setPlacement(placement).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).setIsTrendingItem(isTrendingItem).build();
            }
            this.sendEvent(eventProperties);
            this.localStore.setLastRenderEventTimestamp(System.currentTimeMillis());
        }
    }

    void sendFailedToRenderEvent(String reason) {
        long lastContentRefreshTime = this.localStore.getLastContentRefreshEventTime();
        long lastFailedToRenderEventTime = this.localStore.getLastFailedToRenderEventTime();
        if (lastFailedToRenderEventTime < lastContentRefreshTime) {
            EventProperties eventProperties = new EventProperties.Builder(FAILED_TO_RENDER_EVENT_V2, false).setError(reason).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).build();
            this.sendEvent(eventProperties);
            this.localStore.setLastFailedToRenderEventTime(System.currentTimeMillis());
        }
    }

    void sendUserAssignedToNotificationEngagementGroupEvent(@NonNull String currentEngagementGroupName) {
        EventProperties eventProperties = new EventProperties.Builder(USER_ASSIGNED_TO_NOTIFICATION_ENGAGEMENT_GROUP, false).setNewNotificationEngagementGroupName(currentEngagementGroupName).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).build();
        this.sendEvent(eventProperties);
    }

    void sendUserNotificationEngagementGroupPromotedEvent(@NonNull String previousNotificationEngagementGroupName, @NonNull String newNotificationEngagementGroupName) {
        EventProperties eventProperties = new EventProperties.Builder(USER_NOTIFICATION_ENGAGEMENT_GROUP_PROMOTED, false).setPreviousNotificationEngagementGroupName(previousNotificationEngagementGroupName).setNewNotificationEngagementGroupName(newNotificationEngagementGroupName).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).build();
        this.sendEvent(eventProperties);
    }

    void sendUserNotificationEngagementGroupDemotedEvent(@NonNull String previousGroupName, @NonNull String newGroupName) {
        EventProperties eventProperties = new EventProperties.Builder(USER_NOTIFICATION_ENGAGEMENT_GROUP_DEMOTED, false).setPreviousNotificationEngagementGroupName(previousGroupName).setNewNotificationEngagementGroupName(newGroupName).build();
        this.sendEvent(eventProperties);
    }

    void sendFailedToLoadImage(String url) {
        EventProperties eventProperties = new EventProperties.Builder(FAILED_TO_LOAD_IMAGE_EVENT, false).setUrl(url).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).build();
        this.sendEvent(eventProperties);
    }

    void sendNextItemEvent(List<TBPlacement> placements, String collapsedNotificationLayout, String expandedNotificationLayout, boolean isTrendingItem) {
        EventProperties eventProperties;
        if (placements != null && placements.size() > 1) {
            eventProperties = new EventProperties.Builder(NEXT_ITEM_EVENT, true).setUiMode(this.localStore.getUiMode()).setCollapsedNotificationLayout(collapsedNotificationLayout).setExpandedNotificationLayout(expandedNotificationLayout).setPlacement(placements.get(0)).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).setIsTrendingItem(isTrendingItem).build();
        } else {
            TBPlacement placement = null;
            if (placements != null && !placements.isEmpty()) {
                placement = placements.get(0);
            }
            eventProperties = new EventProperties.Builder(NEXT_ITEM_EVENT, true).setCollapsedNotificationLayout(collapsedNotificationLayout).setExpandedNotificationLayout(expandedNotificationLayout).setPlacement(placement).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).setIsTrendingItem(isTrendingItem).build();
        }
        this.sendEvent(eventProperties);
    }

    void sendAutoNextEvent() {
        long lastContentRefreshEventTime = this.localStore.getLastContentRefreshEventTime();
        long lastAutoNextItemEventTime = this.localStore.getLastAutoNextItemEventTime();
        if (lastAutoNextItemEventTime < lastContentRefreshEventTime) {
            EventProperties eventProperties = new EventProperties.Builder(AUTO_NEXT_ITEM_EVENT_V2, false).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).build();
            this.sendEvent(eventProperties);
            this.localStore.setLastAutoNextItemEventTime(System.currentTimeMillis());
        }
    }

    void sendPrevItemEvent(List<TBPlacement> placements, String collapsedNotificationLayout, String expandedNotificationLayout, boolean isTrendingItem) {
        EventProperties eventProperties;
        if (placements != null && placements.size() > 1) {
            eventProperties = new EventProperties.Builder(PREV_ITEM_EVENT, true).setUiMode(this.localStore.getUiMode()).setCollapsedNotificationLayout(collapsedNotificationLayout).setExpandedNotificationLayout(expandedNotificationLayout).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).setPlacement(placements.get(0)).setIsTrendingItem(isTrendingItem).build();
        } else {
            TBPlacement placement = null;
            if (placements != null && !placements.isEmpty()) {
                placement = placements.get(0);
            }
            eventProperties = new EventProperties.Builder(PREV_ITEM_EVENT, true).setCollapsedNotificationLayout(collapsedNotificationLayout).setExpandedNotificationLayout(expandedNotificationLayout).setPlacement(placement).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).setIsTrendingItem(isTrendingItem).build();
        }
        this.sendEvent(eventProperties);
    }

    void sendTapNotificationEvent(@NonNull TBPlacement placement, boolean isClickIgnored, String collapsedNotificationLayout, String expandedNotificationLayout, boolean isTrendingItem, String randomCounter) {
        EventProperties eventProperties = new EventProperties.Builder(TAP_NOTIFICATION_EVENT, true).setCollapsedNotificationLayout(collapsedNotificationLayout).setExpandedNotificationLayout(expandedNotificationLayout).setPlacement(placement).setIsClickIgnored(isClickIgnored).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).setIsTrendingItem(isTrendingItem).setRandomCounter(randomCounter).build();
        this.sendEvent(eventProperties);
    }

    void sendDismissedEvent(List<TBPlacement> placements, String collapsedNotificationLayout, String expandedNotificationLayout, boolean shouldThrottleDismissEvent, boolean isTrendingItem, String randomCounter) {
        boolean shouldSendDismissEvent = true;
        if (shouldThrottleDismissEvent) {
            shouldSendDismissEvent = this.localStore.getLastRenderEventTimestamp() > this.localStore.getLastDismissEventTimestamp();
        }
        Log.d((String)TAG, (String)("sendDismissedEvent: should send dismiss event " + shouldSendDismissEvent));
        if (shouldSendDismissEvent) {
            EventProperties eventProperties;
            if (placements != null && placements.size() > 1) {
                eventProperties = new EventProperties.Builder(DISMISSED_EVENT, true).setUiMode(this.localStore.getUiMode()).setCollapsedNotificationLayout(collapsedNotificationLayout).setExpandedNotificationLayout(expandedNotificationLayout).setPlacement(placements.get(0)).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).setIsTrendingItem(isTrendingItem).setRandomCounter(randomCounter).build();
            } else {
                TBPlacement placement = null;
                if (placements != null && !placements.isEmpty()) {
                    placement = placements.get(0);
                }
                eventProperties = new EventProperties.Builder(DISMISSED_EVENT, true).setCollapsedNotificationLayout(collapsedNotificationLayout).setExpandedNotificationLayout(expandedNotificationLayout).setPlacement(placement).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).setIsTrendingItem(isTrendingItem).setRandomCounter(randomCounter).build();
            }
            this.sendEvent(eventProperties);
            this.localStore.setLastDismissEventTimestamp(System.currentTimeMillis());
        }
    }

    public void sendNotificationDisabledBySystemEvent() {
        EventProperties eventProperties = new EventProperties.Builder(NOTIFICATION_DISABLED_BY_SYSTEM_EVENT, false).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).build();
        this.sendEvent(eventProperties);
    }

    public void sendNotificationEnabledBySystemEvent() {
        EventProperties eventProperties = new EventProperties.Builder(NOTIFICATION_ENABLED_BY_SYSTEM_EVENT, false).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).build();
        this.sendEvent(eventProperties);
    }

    public void sendUncaughtExceptionEvent(String exceptionMessage, String exceptionStackTrace, int exceptionCount, long exceptionCountPeriodMs, boolean isNewException) {
        EventProperties eventProperties = new EventProperties.Builder(UNCAUGHT_EXCEPTION_EVENT, false).setExceptionMessage(exceptionMessage).setExceptionCount(exceptionCount).setExceptionCountPeriodMs(exceptionCountPeriodMs).setExceptionStackTrace(exceptionStackTrace).build();
        this.sendEvent(eventProperties);
        if (isNewException) {
            this.sendGUEHExceptionToKibana(this.appContext, eventProperties);
        }
    }

    void sendNotificationBlockedByConfig() {
        if (!this.localStore.isNotificationBlockedByConfigEventAlreadySend()) {
            EventProperties eventProperties = new EventProperties.Builder(NOTIFICATION_BLOCKED_BY_CONFIG_EVENT, false).build();
            this.sendEvent(eventProperties);
            this.localStore.setSendNotificationBlockedByConfigEvent();
        }
    }

    public void sendNotificationConfigRefreshedEvent() {
        String previousConfig = this.localStore.getPreviousConfig();
        String currentConfig = this.localStore.getCurrentConfig();
        if (previousConfig == null || currentConfig == null || !currentConfig.equals(previousConfig)) {
            EventProperties eventProperties = new EventProperties.Builder(NOTIFICATION_CONFIG_REFRESHED_EVENT, false).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).build();
            this.sendEvent(eventProperties);
        }
    }

    public void sendCheckNotificationDisabledStatusEvent(boolean isBlocked) {
        long lastCheckNotificationDisabledStatusEventTime = this.localStore.getLastCheckNotificationDisabledStatusEventTime();
        if (System.currentTimeMillis() - lastCheckNotificationDisabledStatusEventTime > 86400000L && isBlocked) {
            EventProperties eventProperties = new EventProperties.Builder(CHECK_NOTIFICATION_DISABLED_STATUS_EVENT_V3, false).setIsBlocked(true).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).build();
            this.sendEvent(eventProperties);
            this.localStore.setLastCheckNotificationDisabledStatusEventTime(System.currentTimeMillis());
        }
    }

    public void sendTaboolaApiNotInitializedEvent(@Nullable String info) {
        Log.e((String)TAG, (String)("TaboolaApiNotInitializedEvent: " + info));
        final EventProperties eventProperties = new EventProperties.Builder(TABOOLA_API_NOT_INITIALIZED_EVENT, true).setError(info).build();
        this.networkExecutor.execute(new Runnable(){

            @Override
            public void run() {
                TBNotificationAnalyticsManager.this.sendEventToKusto(TBNotificationAnalyticsManager.this.appContext, eventProperties);
            }
        });
    }

    private void sendEvent(final @NonNull EventProperties eventProperties) {
        final boolean isAmplitudeEnabled = this.localStore.isAmplitudeEnabled();
        final boolean isKustoEnabled = this.localStore.isKustoEnabled();
        if (isAmplitudeEnabled || isKustoEnabled) {
            this.networkExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    if (isAmplitudeEnabled) {
                        TBNotificationAnalyticsManager.this.sendEventToAmplitude(TBNotificationAnalyticsManager.this.appContext, eventProperties);
                    }
                    if (isKustoEnabled) {
                        TBNotificationAnalyticsManager.this.sendEventToKusto(TBNotificationAnalyticsManager.this.appContext, eventProperties);
                    }
                }
            });
        }
        this.mainThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                TBNotificationAnalyticsManager.this.sendEventToTrc(eventProperties);
            }
        });
        this.sendBroadcast(eventProperties);
    }

    public void sendNotificationBlockedByFrequentCrashes(int exceptionCount) {
        EventProperties eventProperties = new EventProperties.Builder(NOTIFICATION_BLOCKED_BY_FREQUENT_CRASHES_EVENT, false).setExceptionCount(exceptionCount).build();
        this.sendEvent(eventProperties);
    }

    @WorkerThread
    private void sendEventToAmplitude(@NonNull Context appContext, @NonNull EventProperties eventProperties) {
        try {
            TBNotificationLocalStore localStore = new TBNotificationLocalStore(appContext);
            long lastEventTime = localStore.getLastEventTime();
            if ((System.currentTimeMillis() - lastEventTime > 300000L || lastEventTime == -1L) && eventProperties.isImplicitEvent()) {
                localStore.setLastEventTime(System.currentTimeMillis());
            }
            JSONObject event = new JSONObject();
            event.put("app_version", (Object)TBDeviceInfoUtil.getAppVersion(appContext));
            event.put("device_id", (Object)BridgeInternal.getAdvertisingIdInfo().getAdvertisingId());
            event.put("event_type", (Object)eventProperties.getEventName());
            event.put("time", System.currentTimeMillis());
            event.put("os_name", (Object)"Android");
            event.put("platform", (Object)"Android");
            event.put("os_version", (Object)Build.VERSION.RELEASE);
            event.put("device_model", (Object)TBDeviceInfoUtil.getDeviceName());
            event.put("device_manufacturer", (Object)Build.MANUFACTURER);
            event.put("device_brand", (Object)Build.MANUFACTURER);
            event.put("carrier", (Object)TBDeviceInfoUtil.getCarrier(appContext));
            event.put("language", (Object)Locale.getDefault().getDisplayLanguage(Locale.US));
            event.put("ip", (Object)TBDeviceInfoUtil.getLocalIpAddress());
            event.put("adid", (Object)BridgeInternal.getAdvertisingIdInfo().getAdvertisingId());
            JSONObject userProperties = this.getUserProperties(appContext, eventProperties.getPlacement(), eventProperties.getError());
            event.put("user_properties", (Object)userProperties);
            TBDeviceInfoUtil.setLocationData(appContext, event);
            if (eventProperties.isImplicitEvent()) {
                event.put("session_id", localStore.getLastEventTime());
            }
            JSONObject eventPropertiesJson = this.getEventProperties(appContext, eventProperties.getPlacement(), eventProperties.getResponseItemCount(), eventProperties.getError(), eventProperties.getUrl(), eventProperties.isclickIgnored(), eventProperties.getCollapsedNotificationLayout(), eventProperties.getExpandedNotificationLayout(), eventProperties.isBlocked(), eventProperties.isDeviceLocked(), eventProperties.isTrendingItem(), eventProperties.getUiMode(), eventProperties.getExceptionMessage(), eventProperties.getExceptionCount(), eventProperties.getExceptionCountPeriodMs(), eventProperties.getExceptionStackTrace(), eventProperties.getNewNotificationEngagementGroupName(), eventProperties.getPreviousNotificationEngagementGroupName(), eventProperties.getRecommendationItemId(), eventProperties.getErrorMessage(), eventProperties.getRandomCounter(), eventProperties.getMessageTitle(), eventProperties.getMessageId());
            event.put("event_properties", (Object)eventPropertiesJson);
            if (eventProperties.getEventName().equals(UNCAUGHT_EXCEPTION_EVENT) || eventProperties.getEventName().equals(NOTIFICATION_BLOCKED_BY_FREQUENT_CRASHES_EVENT)) {
                localStore.addCrashEventThatNeedSendToAmlitude(String.valueOf(event));
            } else {
                this.sendCrashEventsToAmplitudeIfNeed();
                this.mNetworkManager.getAmplitudeHandler().sendEvent(AMPLITUDE_KEY, String.valueOf(event), null);
                Log.v((String)TAG, (String)("sent event to amplitude " + eventProperties.getEventName()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)("sendEventToAmplitude " + e.getMessage()));
        }
    }

    private void sendGUEHExceptionToKibana(Context appContext, EventProperties eventProperties) {
        try {
            Logger.e((String)"SdkPlusExceptionHandler", (String)("Sending exception to Kibana. Message: " + eventProperties.getExceptionMessage()));
            JsonObject jsonReportBody = this.getJsonObjectForKusto(appContext, eventProperties, this.localStore);
            jsonReportBody.remove("time");
            String timeStamp = KibanaUtils.getISO8601currentTime();
            jsonReportBody.addProperty("timestamp", timeStamp);
            final JSONObject exceptionReportJsonObject = new JSONObject(jsonReportBody.toString());
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            final HttpManager.NetworkResponse networkResponse = new HttpManager.NetworkResponse(){

                public void onResponse(HttpResponse response) {
                    Logger.d((String)"SdkPlusExceptionHandler", (String)("sendGUEHExceptionToKibana Exception reported, response: " + response));
                    countDownLatch.countDown();
                }

                public void onError(HttpError error) {
                    Logger.e((String)"SdkPlusExceptionHandler", (String)("sendGUEHExceptionToKibana Exception not reported, error: " + error));
                    countDownLatch.countDown();
                }
            };
            this.mReportingHandler.post(new Runnable(){

                @Override
                public void run() {
                    TBNotificationAnalyticsManager.this.mNetworkManager.getKibanaHandler().sendGUEHExceptionToKibana(exceptionReportJsonObject, networkResponse);
                }
            });
            try {
                countDownLatch.await(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Logger.e((String)TAG, (String)"Kibana report thread interrupted while waiting for report.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.e((String)TAG, (String)("sendGUEHExceptionToKibana " + e.getMessage()));
        }
    }

    @WorkerThread
    private void sendEventToKusto(@NonNull Context appContext, @NonNull EventProperties eventProperties) {
        try {
            TBNotificationLocalStore localStore = new TBNotificationLocalStore(appContext);
            long lastEventTime = localStore.getLastEventTime();
            if ((System.currentTimeMillis() - lastEventTime > 300000L || lastEventTime == -1L) && eventProperties.isImplicitEvent()) {
                localStore.setLastEventTime(System.currentTimeMillis());
            }
            JsonObject event = this.getJsonObjectForKusto(appContext, eventProperties, localStore);
            if (eventProperties.getEventName().equals(UNCAUGHT_EXCEPTION_EVENT) || eventProperties.getEventName().equals(NOTIFICATION_BLOCKED_BY_FREQUENT_CRASHES_EVENT)) {
                localStore.addCrashEventThatNeedSendToKusto(String.valueOf(event));
            } else {
                this.sendCrashEventsToKustoIfNeed();
                this.mNetworkManager.getKustoHandler().sendEvent(SDK_PLUS_TAG, String.valueOf(event), null);
                Log.v((String)TAG, (String)("sent event to kusto " + eventProperties.getEventName()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)("sendEventToKusto " + e.getMessage()));
        }
    }

    private JsonObject getJsonObjectForKusto(@NonNull Context appContext, @NonNull EventProperties eventProperties, TBNotificationLocalStore localStore) {
        String publisher;
        JsonObject event = new JsonObject();
        event.addProperty("device_id", BridgeInternal.getAdvertisingIdInfo().getAdvertisingId());
        event.addProperty("event_type", eventProperties.getEventName());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);
        event.addProperty("time", sdf.format(new Date(System.currentTimeMillis())));
        event.addProperty("os_name", "Android");
        event.addProperty("platform", "Android");
        event.addProperty("os_version", Build.VERSION.RELEASE);
        event.addProperty("device_model", TBDeviceInfoUtil.getDeviceName());
        event.addProperty("app_version", TBDeviceInfoUtil.getAppVersion(appContext));
        event.addProperty("appId", appContext.getPackageName());
        event.addProperty("device_manufacturer", Build.MANUFACTURER);
        event.addProperty("device_brand", Build.MANUFACTURER);
        event.addProperty("carrier", TBDeviceInfoUtil.getCarrier(appContext));
        event.addProperty("language", Locale.getDefault().getDisplayLanguage(Locale.US));
        event.addProperty("ip", TBDeviceInfoUtil.getLocalIpAddress());
        event.addProperty("adid", BridgeInternal.getAdvertisingIdInfo().getAdvertisingId());
        TBDeviceInfoUtil.setLocationData(appContext, event);
        if (eventProperties.isImplicitEvent()) {
            event.addProperty("session_id", (Number)localStore.getLastEventTime());
        }
        event.addProperty("sdk+(TaboolaPlus)version", "1.2.2");
        event.addProperty("sdk(TaboolaApi)version", "2.3.5");
        event.addProperty("simCountry", TBDeviceInfoUtil.getSimCountry(appContext));
        if (eventProperties.getResponseItemCount() != -1) {
            event.addProperty("responseItemCount", (Number)eventProperties.getResponseItemCount());
        }
        if (eventProperties.getUiMode() != null && !eventProperties.getUiMode().isEmpty()) {
            event.addProperty("itemTitle", eventProperties.getUiMode());
        } else if (eventProperties.getPlacement() != null && !eventProperties.getPlacement().getItems().isEmpty()) {
            event.addProperty("itemTitle", (String)((TBRecommendationItem)eventProperties.getPlacement().getItems().get(0)).getExtraDataMap().get("name"));
        }
        if (eventProperties.getUrl() != null && !eventProperties.getUrl().isEmpty()) {
            event.addProperty("image_url", eventProperties.getUrl());
        }
        if (eventProperties.getError() != null) {
            event.addProperty("error_details", eventProperties.getError());
        }
        if (eventProperties.isBlocked() != null) {
            event.addProperty("isBlocked", eventProperties.isBlocked());
        }
        if (eventProperties.isDeviceLocked() != null) {
            event.addProperty("isDeviceLocked", eventProperties.isDeviceLocked());
        }
        if (eventProperties.isTrendingItem() != null) {
            event.addProperty("isTrendingItem", eventProperties.isTrendingItem());
        }
        if (eventProperties.getExceptionMessage() != null) {
            event.addProperty("exceptionMessage", eventProperties.getExceptionMessage());
        }
        if (eventProperties.getExceptionCount() != -1) {
            event.addProperty("exceptionCount", (Number)eventProperties.getExceptionCount());
        }
        if (eventProperties.getExceptionCountPeriodMs() != -1L) {
            event.addProperty("exceptionCountPeriodMs", (Number)eventProperties.getExceptionCountPeriodMs());
        }
        if (eventProperties.getExceptionStackTrace() != null) {
            event.addProperty("exceptionStackTrace", eventProperties.getExceptionStackTrace());
        }
        if (eventProperties.getRandomCounter() != null) {
            event.addProperty("randomCounter", eventProperties.getRandomCounter());
        }
        if ((publisher = localStore.getPublisher()) != null && !publisher.isEmpty()) {
            event.addProperty("publisher", publisher);
        }
        String configVariant = localStore.getConfigVariant();
        event.addProperty("configVariant", configVariant);
        if (eventProperties.isclickIgnored()) {
            event.addProperty("clickIgnored", Boolean.valueOf(true));
        }
        if (eventProperties.getCollapsedNotificationLayout() != null) {
            event.addProperty(COLLAPSED_NOTIFICATION_LAYOUT_PROPERTY_KEY, eventProperties.getCollapsedNotificationLayout());
        }
        if (eventProperties.getExpandedNotificationLayout() != null) {
            event.addProperty(EXPANDED_NOTIFICATION_LAYOUT_PROPERTY_KEY, eventProperties.getExpandedNotificationLayout());
        }
        if (!TextUtils.isEmpty((CharSequence)eventProperties.getNewNotificationEngagementGroupName())) {
            event.addProperty("newNotificationEngagementGroupName", eventProperties.getNewNotificationEngagementGroupName());
        }
        if (!TextUtils.isEmpty((CharSequence)eventProperties.getPreviousNotificationEngagementGroupName())) {
            event.addProperty("previousNotificationEngagementGroupName", eventProperties.getPreviousNotificationEngagementGroupName());
        }
        if (!TextUtils.isEmpty((CharSequence)eventProperties.getErrorMessage())) {
            event.addProperty("errorMessage", eventProperties.getErrorMessage());
        }
        if (!TextUtils.isEmpty((CharSequence)eventProperties.getRecommendationItemId())) {
            event.addProperty("recommendationItemId", eventProperties.getRecommendationItemId());
        }
        return event;
    }

    @UiThread
    private void sendEventToTrc(@NonNull EventProperties eventProperties) {
        if (TaboolaApi.getInstance().isInitialized()) {
            TBPlacement placement = eventProperties.getPlacement();
            if (placement != null && placement.getItems() != null && !placement.getItems().isEmpty()) {
                TBRecommendationItem item = (TBRecommendationItem)placement.getItems().get(0);
                Map<String, String> map = this.getEventMap(this.appContext, eventProperties);
                item.reportEvent(eventProperties.getEventName(), map, "youmaylike");
            }
        } else {
            String info = "TBNotificationAnalyticsManager: sendEventToTrc(): " + eventProperties.getEventName();
            this.sendTaboolaApiNotInitializedEvent(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void sendCrashEventsToKustoIfNeed() {
        HashSet<String> crashEventsThatNeedSendToKusto;
        Iterator iterator = kustoCrashesDataLock;
        synchronized (iterator) {
            crashEventsThatNeedSendToKusto = new HashSet<String>(this.localStore.getCrashEventsThatNeedSendToKusto());
            this.localStore.clearCrashEventsThatNeedSendToKusto();
        }
        if (!crashEventsThatNeedSendToKusto.isEmpty()) {
            for (String event : crashEventsThatNeedSendToKusto) {
                String crashEventFormatted = String.valueOf(new JsonParser().parse(event).getAsJsonObject());
                this.mNetworkManager.getKustoHandler().sendEvent(SDK_PLUS_TAG, crashEventFormatted, new HttpManager.NetworkResponse(){

                    public void onResponse(HttpResponse response) {
                        Logger.d((String)"SdkPlusExceptionHandler", (String)("sendCrashEventsToKustoIfNeed Exception reported, response: " + response));
                    }

                    public void onError(HttpError httpError) {
                        Logger.e((String)"SdkPlusExceptionHandler", (String)("sendCrashEventsToKustoIfNeed Exception not reported, error: " + httpError));
                    }
                });
                Log.v((String)TAG, (String)("sent event to kusto " + event));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void sendCrashEventsToAmplitudeIfNeed() {
        HashSet<String> crashEventsThatNeedSendToAmplitude;
        Iterator iterator = amplitudeCrashesDataLock;
        synchronized (iterator) {
            crashEventsThatNeedSendToAmplitude = new HashSet<String>(this.localStore.getCrashEventsThatNeedSendToAmplitude());
            this.localStore.clearCrashEventsThatNeedSendToAmplitude();
        }
        if (!crashEventsThatNeedSendToAmplitude.isEmpty()) {
            for (String event : crashEventsThatNeedSendToAmplitude) {
                this.mNetworkManager.getAmplitudeHandler().sendEvent(AMPLITUDE_KEY, String.valueOf(event), new HttpManager.NetworkResponse(){

                    public void onResponse(HttpResponse response) {
                        Logger.d((String)"SdkPlusExceptionHandler", (String)("sendCrashEventsToAmplitudeIfNeed Exception reported, response: " + response));
                    }

                    public void onError(HttpError error) {
                        Logger.e((String)"SdkPlusExceptionHandler", (String)("sendCrashEventsToAmplitudeIfNeed Exception not reported, error: " + error));
                    }
                });
                Log.v((String)TAG, (String)("sent event to amplitude " + event));
            }
        }
    }

    private Map<String, String> getEventMap(@NonNull Context appContext, @NonNull EventProperties eventProperties) {
        String publisher;
        TBNotificationLocalStore localStore = new TBNotificationLocalStore(appContext);
        long lastEventTime = localStore.getLastEventTime();
        if ((System.currentTimeMillis() - lastEventTime > 300000L || lastEventTime == -1L) && eventProperties.isImplicitEvent()) {
            localStore.setLastEventTime(System.currentTimeMillis());
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("device_id", BridgeInternal.getAdvertisingIdInfo().getAdvertisingId());
        map.put("event_type", eventProperties.getEventName());
        map.put("time", new Timestamp(System.currentTimeMillis()).toString());
        map.put("os_name", "Android");
        map.put("platform", "Android");
        map.put("os_version", Build.VERSION.RELEASE);
        map.put("device_model", TBDeviceInfoUtil.getDeviceName());
        map.put("app_version", TBDeviceInfoUtil.getAppVersion(appContext));
        map.put("appId", appContext.getPackageName());
        map.put("device_manufacturer", Build.MANUFACTURER);
        map.put("device_brand", Build.MANUFACTURER);
        map.put("carrier", TBDeviceInfoUtil.getCarrier(appContext));
        map.put("language", Locale.getDefault().getDisplayLanguage(Locale.US));
        map.put("ip", TBDeviceInfoUtil.getLocalIpAddress());
        map.put("adid", BridgeInternal.getAdvertisingIdInfo().getAdvertisingId());
        TBDeviceInfoUtil.setLocationData(appContext, map);
        if (eventProperties.isImplicitEvent()) {
            map.put("session_id", String.valueOf(localStore.getLastEventTime()));
        }
        map.put("sdk+(TaboolaPlus)version", "1.2.2");
        map.put("sdk(TaboolaApi)version", "2.3.5");
        map.put("simCountry", TBDeviceInfoUtil.getSimCountry(appContext));
        if (eventProperties.getResponseItemCount() != -1) {
            map.put("responseItemCount", String.valueOf(eventProperties.getResponseItemCount()));
        }
        if (eventProperties.getUiMode() != null && !eventProperties.getUiMode().isEmpty()) {
            map.put("itemTitle", eventProperties.getUiMode());
        } else if (eventProperties.getPlacement() != null && !eventProperties.getPlacement().getItems().isEmpty()) {
            map.put("itemTitle", (String)((TBRecommendationItem)eventProperties.getPlacement().getItems().get(0)).getExtraDataMap().get("name"));
        }
        if (eventProperties.getUrl() != null && !eventProperties.getUrl().isEmpty()) {
            map.put("image_url", eventProperties.getUrl());
        }
        if (eventProperties.getError() != null) {
            map.put("error_details", eventProperties.getError());
        }
        if (eventProperties.isBlocked() != null) {
            map.put("isBlocked", String.valueOf(eventProperties.isBlocked()));
        }
        if (eventProperties.isTrendingItem() != null) {
            map.put("isTrendingItem", String.valueOf(eventProperties.isTrendingItem()));
        }
        if (eventProperties.isDeviceLocked() != null) {
            map.put("isDeviceLocked", String.valueOf(eventProperties.isDeviceLocked()));
        }
        if (eventProperties.getExceptionMessage() != null) {
            map.put("exceptionMessage", eventProperties.getExceptionMessage());
        }
        if (eventProperties.getExceptionCount() != -1) {
            map.put("exceptionCount", String.valueOf(eventProperties.getExceptionCount()));
        }
        if (eventProperties.getExceptionCountPeriodMs() != -1L) {
            map.put("exceptionCountPeriodMs", String.valueOf(eventProperties.getExceptionCountPeriodMs()));
        }
        if (eventProperties.getExceptionStackTrace() != null) {
            map.put("exceptionStackTrace", eventProperties.getExceptionStackTrace());
        }
        if (eventProperties.getRandomCounter() != null) {
            map.put("randomCounter", eventProperties.getRandomCounter());
        }
        if ((publisher = localStore.getPublisher()) != null && !publisher.isEmpty()) {
            map.put("publisher", publisher);
        }
        String configVariant = localStore.getConfigVariant();
        map.put("configVariant", configVariant);
        if (eventProperties.isclickIgnored()) {
            map.put("clickIgnored", String.valueOf(true));
        }
        return map;
    }

    private JSONObject getEventProperties(@NonNull Context appContext, @Nullable TBPlacement placement, int responseItemCount, @Nullable String error, @Nullable String url, boolean isClickIngnored, String collapsedNotificationLayout, String expandedNotificationLayout, Boolean isBlocked, Boolean isDeviceLocked, Boolean isTrendingItem, String uiMode, String exceptionMessage, int exceptionCount, long exceptionCountPeriodMs, String exceptionStackTrace, String newNotificationEngagementGroupName, String previousNotificationEngagementGroupName, String recommendationItemId, String errorMessage, String randomCounter, String messageTitle, String messageId) {
        TBNotificationLocalStore localStore = new TBNotificationLocalStore(appContext);
        JSONObject eventProperties = new JSONObject();
        try {
            String publisher;
            eventProperties.put("sdk+(TaboolaPlus)version", (Object)"1.2.2");
            eventProperties.put("sdk(TaboolaApi)version", (Object)"2.3.5");
            eventProperties.put("simCountry", (Object)TBDeviceInfoUtil.getSimCountry(appContext));
            if (responseItemCount != -1) {
                eventProperties.put("responseItemCount", responseItemCount);
            }
            if (uiMode != null && !uiMode.isEmpty()) {
                eventProperties.put("placement", (Object)uiMode);
            } else if (placement != null && !placement.getItems().isEmpty()) {
                eventProperties.put("placement", ((TBRecommendationItem)placement.getItems().get(0)).getExtraDataMap().get("name"));
            }
            if (url != null && !url.isEmpty()) {
                eventProperties.put("image_url", (Object)url);
            }
            if (!TextUtils.isEmpty((CharSequence)newNotificationEngagementGroupName)) {
                eventProperties.put("newNotificationEngagementGroupName", (Object)newNotificationEngagementGroupName);
            }
            if (!TextUtils.isEmpty((CharSequence)previousNotificationEngagementGroupName)) {
                eventProperties.put("previousNotificationEngagementGroupName", (Object)previousNotificationEngagementGroupName);
            }
            if (error != null) {
                eventProperties.put("error_details", (Object)error);
            }
            if (!TextUtils.isEmpty((CharSequence)recommendationItemId)) {
                eventProperties.put("invalidRecommendationItemId", (Object)recommendationItemId);
            }
            if (!TextUtils.isEmpty((CharSequence)errorMessage)) {
                eventProperties.put("errorMessage", (Object)errorMessage);
            }
            if (isBlocked != null) {
                eventProperties.put("isBlocked", (Object)isBlocked);
            }
            if (isDeviceLocked != null) {
                eventProperties.put("isDeviceLocked", (Object)isDeviceLocked);
            }
            if (isTrendingItem != null) {
                eventProperties.put("isTrendingItem", (Object)isTrendingItem);
            }
            if (isClickIngnored) {
                eventProperties.put("clickIgnored", true);
            }
            if (collapsedNotificationLayout != null) {
                eventProperties.put(COLLAPSED_NOTIFICATION_LAYOUT_PROPERTY_KEY, (Object)collapsedNotificationLayout);
            }
            if (expandedNotificationLayout != null) {
                eventProperties.put(EXPANDED_NOTIFICATION_LAYOUT_PROPERTY_KEY, (Object)expandedNotificationLayout);
            }
            if (exceptionMessage != null) {
                eventProperties.put("exceptionMessage", (Object)exceptionMessage);
            }
            if (exceptionCount != -1) {
                eventProperties.put("exceptionCount", exceptionCount);
            }
            if (exceptionCountPeriodMs != -1L) {
                eventProperties.put("exceptionCountPeriodMs", exceptionCountPeriodMs);
            }
            if (exceptionStackTrace != null) {
                eventProperties.put("exceptionStackTrace", (Object)exceptionStackTrace);
            }
            if (randomCounter != null) {
                eventProperties.put("randomCounter", (Object)randomCounter);
            }
            if (messageTitle != null) {
                eventProperties.put("messageTitle", (Object)messageTitle);
            }
            if (messageId != null) {
                eventProperties.put("messageId", (Object)messageId);
            }
            if ((publisher = localStore.getPublisher()) != null && !publisher.isEmpty()) {
                eventProperties.put("publisher", (Object)publisher);
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("getEventProperties: parsing issue" + e.toString()));
            e.printStackTrace();
        }
        return eventProperties;
    }

    private JSONObject getUserProperties(@NonNull Context appContext, @Nullable TBPlacement placement, @Nullable String error) {
        TBNotificationLocalStore localStore = new TBNotificationLocalStore(appContext);
        JSONObject userProperties = new JSONObject();
        try {
            userProperties.put("appId", (Object)appContext.getPackageName());
            userProperties.put("appVersion", (Object)TBDeviceInfoUtil.getAppVersion(appContext));
            userProperties.put("sdk+(TaboolaPlus)version", (Object)"1.2.2");
            userProperties.put("sdk(TaboolaApi)version", (Object)"2.3.5");
            userProperties.put("simCountry", (Object)TBDeviceInfoUtil.getSimCountry(appContext));
            String publisher = localStore.getPublisher();
            if (publisher != null && !publisher.isEmpty()) {
                userProperties.put("publisher", (Object)publisher);
            }
            String abTestVariant = localStore.getConfigVariant();
            userProperties.put("configVariant", (Object)abTestVariant);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("getUserProperties: parsing issue" + e.toString()));
            e.printStackTrace();
        }
        return userProperties;
    }

    private void sendBroadcast(EventProperties eventProperties) {
        Intent intent = new Intent();
        intent.setAction(TB_ANALYTICS_ACTION_NAME);
        intent.setPackage(this.appContext.getPackageName());
        intent.putExtra(TB_ANALYTICS_KEY_EVENT_NAME, eventProperties.getEventName());
        JSONObject eventsProperties = this.getEventProperties(this.appContext, eventProperties.getPlacement(), eventProperties.getResponseItemCount(), eventProperties.getError(), eventProperties.getUrl(), eventProperties.isclickIgnored(), eventProperties.getCollapsedNotificationLayout(), eventProperties.getExpandedNotificationLayout(), eventProperties.isBlocked(), eventProperties.isDeviceLocked(), eventProperties.isTrendingItem(), eventProperties.getUiMode(), eventProperties.getExceptionMessage(), eventProperties.getExceptionCount(), eventProperties.getExceptionCountPeriodMs(), eventProperties.getExceptionStackTrace(), eventProperties.getNewNotificationEngagementGroupName(), eventProperties.getPreviousNotificationEngagementGroupName(), eventProperties.getRecommendationItemId(), eventProperties.getErrorMessage(), eventProperties.getRandomCounter(), eventProperties.getMessageTitle(), eventProperties.getMessageId());
        intent.putExtra(TB_ANALYTICS_KEY_EVENT_PROPERTIES, eventsProperties.toString());
        if (eventProperties.getResponseItemCount() != -1) {
            intent.putExtra(TB_ANALYTICS_KEY_RESPONSE_ITEM_COUNT, eventProperties.getResponseItemCount());
        }
        JSONObject userProperties = this.getUserProperties(this.appContext, eventProperties.getPlacement(), eventProperties.getError());
        intent.putExtra(TB_ANALYTICS_KEY_USER_PROPERTIES, userProperties.toString());
        this.appContext.sendBroadcast(intent);
    }
}

