/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.Log;
import com.taboola.android.plus.ConfigManager;
import com.taboola.android.plus.notification.NotificationConfig;
import com.taboola.android.plus.notification.TBDeviceInfoUtil;
import com.taboola.android.plus.notification.TBNotificationAnalyticsManager;
import com.taboola.android.plus.notification.TBNotificationLocalStore;
import com.taboola.android.plus.notification.killSwitch.KillSwitchUtil;
import com.taboola.android.plus.shared.ConditionCheckUtil;

class NotificationRenderRestrictionUtil {
    private static final String TAG = NotificationRenderRestrictionUtil.class.getSimpleName();

    NotificationRenderRestrictionUtil() {
    }

    static boolean isBlockedByKillSwitch(@NonNull Context appContext) {
        ConfigManager.CachedSdkConfigContainer cachedSdkConfig = ConfigManager.getCurrentSdkConfig(appContext);
        if (cachedSdkConfig != null && KillSwitchUtil.isNotificationBlockedByFrequentCrashes(appContext, cachedSdkConfig.getSdkPlusConfig().getNotificationConfig().getKillSwitchConfig().getFrequentCrashBlockConfig())) {
            Log.i((String)TAG, (String)"Notification is blocked by frequent unhandled exceptions");
            return true;
        }
        return false;
    }

    @RequiresApi(api=21)
    static boolean isNotificationBlocked(@NonNull Context appContext, @NonNull TBNotificationLocalStore localStore, @NonNull TBNotificationAnalyticsManager analyticsManager, @NonNull NotificationConfig notificationConfig, @NonNull NotificationConfig.SmartNotificationFrequency.EngagementGroup currentGroup) {
        if (!NotificationRenderRestrictionUtil.areNetworkRestrictionsMet(notificationConfig, localStore, appContext)) {
            Log.i((String)TAG, (String)"No wifi connection");
            return true;
        }
        if (NotificationRenderRestrictionUtil.handleNotificationBlockByUser(analyticsManager, localStore, appContext)) {
            Log.i((String)TAG, (String)"Not refreshing notification: Notifications are blocked by user");
            return true;
        }
        if (!TBDeviceInfoUtil.isDeviceSupported(notificationConfig)) {
            Log.i((String)TAG, (String)"Notifications is blocked by config on the device");
            analyticsManager.sendNotificationBlockedByConfig();
            return true;
        }
        if (ConditionCheckUtil.isTriggerPerDayMaxCountReached(currentGroup.getMaxNotificationTriggerCountPerDay(), localStore.getCountOfRenderedNotificationsToday())) {
            Log.i((String)TAG, (String)"Notification is not shown because of max trigger times per day set in the config");
            return true;
        }
        if (!ConditionCheckUtil.didMinTriggerIntervalPass(localStore.getLastShownNotificationTimestamp(), currentGroup.getMinTriggerIntervalMs(), System.currentTimeMillis())) {
            Log.i((String)TAG, (String)"Notification is not shown because of min trigger interval set in the config");
            return true;
        }
        if (ConditionCheckUtil.isBlockedByAllowedTimeWindows(currentGroup.getAllowedIntervals())) {
            Log.i((String)TAG, (String)"Notification is not shown because of allow time windows set in the config");
            return true;
        }
        return false;
    }

    static boolean didRefreshIntervalPass(TBNotificationLocalStore localStore, NotificationConfig config) {
        long timeSinceLastRefreshMs = System.currentTimeMillis() - localStore.getRefreshedTimestamp();
        Log.d((String)"render", (String)("refresh: " + config.getRefreshIntervalMs() + "" + (timeSinceLastRefreshMs >= (long)config.getRefreshIntervalMs())));
        return timeSinceLastRefreshMs >= (long)config.getRefreshIntervalMs();
    }

    static boolean handleNotificationBlockByUser(@NonNull TBNotificationAnalyticsManager analyticsManager, @NonNull TBNotificationLocalStore localStore, @NonNull Context appContext) {
        boolean areNotificationsBlockedByUser = ConditionCheckUtil.areNotificationsBlockedByUser(appContext, "Taboola Content");
        analyticsManager.sendCheckNotificationDisabledStatusEvent(areNotificationsBlockedByUser);
        if (areNotificationsBlockedByUser) {
            if (!localStore.isNotificationBlockBySystem()) {
                analyticsManager.sendNotificationDisabledBySystemEvent();
                localStore.setIsNotificationBlockBySystem(true);
            }
            return true;
        }
        if (localStore.isNotificationBlockBySystem()) {
            analyticsManager.sendNotificationEnabledBySystemEvent();
            localStore.setIsNotificationBlockBySystem(false);
        }
        return false;
    }

    @RequiresApi(api=21)
    private static boolean areNetworkRestrictionsMet(NotificationConfig notificationConfig, TBNotificationLocalStore localStore, Context appContext) {
        Boolean isWifiOnlyMode = notificationConfig.isWifiOnlyMode();
        if (isWifiOnlyMode == null) {
            isWifiOnlyMode = localStore.isWifiOnlyModeRuntimeFlag();
        }
        if (isWifiOnlyMode.booleanValue()) {
            return ConditionCheckUtil.isWifiConnectionAvailable(appContext);
        }
        return true;
    }
}

