/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification.killSwitch;

import android.content.Context;
import android.support.annotation.NonNull;
import com.taboola.android.plus.notification.killSwitch.FrequentCrashBlockConfig;
import com.taboola.android.plus.notification.killSwitch.KillSwitchStorage;

public class KillSwitchUtil {
    public static final String ID_STRING = "id=";
    private static final String NOTIFICATION_ERROR_MESSAGE_STRING = "Bad notification posted from package";

    public static boolean isNotificationBlockedByFrequentCrashes(@NonNull Context applicationContext, @NonNull FrequentCrashBlockConfig blockConfig) {
        if (!blockConfig.isFrequentCrashBlockEnabled()) {
            return false;
        }
        KillSwitchStorage killSwitchStorage = new KillSwitchStorage(applicationContext);
        long blockTriggeredTimestamp = killSwitchStorage.getLastNotificationBlockTriggeredTimestamp();
        return blockTriggeredTimestamp + blockConfig.getKillTimeMs() > System.currentTimeMillis();
    }

    static boolean isNotificationException(Throwable throwable) {
        return throwable.getMessage().contains(NOTIFICATION_ERROR_MESSAGE_STRING);
    }

    static int getNotificationId(Throwable throwable) {
        String[] words = throwable.getMessage().split("\\s+");
        String exeptionID = "";
        for (String item : words) {
            if (!item.startsWith(ID_STRING)) continue;
            exeptionID = item.substring(3);
        }
        if (!exeptionID.isEmpty()) {
            return Integer.parseInt(exeptionID);
        }
        return -1;
    }
}

