/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBRecommendationItem;
import com.taboola.android.api.TaboolaApi;
import com.taboola.android.plus.content.ContentConfig;
import com.taboola.android.plus.content.TBContentManager;
import com.taboola.android.plus.notification.NotificationContentState;
import com.taboola.android.plus.notification.TBContent;
import com.taboola.android.plus.notification.TBNotificationAnalyticsManager;
import com.taboola.android.plus.notification.TBNotificationContentCallback;
import com.taboola.android.plus.notification.TBNotificationExecutors;
import com.taboola.android.plus.notification.TBNotificationLocalStore;
import com.taboola.android.plus.notification.TBNotificationUtil;
import com.taboola.android.plus.shared.PlacementValidationUtil;
import com.taboola.android.utils.UrlUtils;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

class TBNotificationRepository {
    private static final String TAG = TBNotificationRepository.class.getSimpleName();
    private final TBContentManager contentManager;
    private final TBNotificationLocalStore store;
    private final TBNotificationAnalyticsManager analyticsManager;
    private final TBNotificationExecutors executors;

    TBNotificationRepository(TBContentManager contentManager, TBNotificationLocalStore store, TBNotificationAnalyticsManager analyticsManager, TBNotificationExecutors executors) {
        this.contentManager = contentManager;
        this.store = store;
        this.analyticsManager = analyticsManager;
        this.executors = executors;
    }

    void loadNewContent(ContentConfig contentConfig, @NonNull String placementName, @NonNull List<String> categories, int numberOfItems, int imageWidth, int imageHeight, final @NonNull TBNotificationContentCallback callback) {
        Log.d((String)TAG, (String)("Fetching new content with: placementName = [" + placementName + "], categories = [" + categories + "], numberOfItems = [" + numberOfItems + "]"));
        this.contentManager.getNotificationContent(contentConfig, placementName, categories, numberOfItems, imageWidth, imageHeight, false, new TBContentManager.OnNotificationContentFetchedCallback(){

            @Override
            public void onNotificationContentFetched(List<TBPlacement> content) {
                TBNotificationRepository.this.store.setRefreshedTimestamp(System.currentTimeMillis());
                ArrayList<TBPlacement> validPlacements = new ArrayList<TBPlacement>();
                for (TBPlacement placement : content) {
                    if (PlacementValidationUtil.isPlacementValid(placement, TBNotificationRepository.this.analyticsManager)) {
                        validPlacements.add(placement);
                    } else {
                        Log.w((String)TAG, (String)"onNotificationContentFetched: invalid placement");
                    }
                    if (TaboolaApi.getInstance().isInitialized()) continue;
                    String info = "TBNotificationRepository: loadNewContent: getNotificationContent(): onNotificationContentFetched()";
                    TBNotificationAnalyticsManager.sendTaboolaApiNotInitializedEventWithoutContext(info);
                }
                TBContent tbContent = new TBContent(validPlacements);
                TBNotificationRepository.this.setNotificationContent(tbContent);
                TBNotificationRepository.this.analyticsManager.sendContentRefreshSuccessfulEvent(validPlacements.size());
                callback.onLoadedContent(tbContent);
            }

            @Override
            public void onNotificationContentFailed(Throwable throwable) {
                TBNotificationRepository.this.analyticsManager.sendContentRefreshFailedEvent();
                callback.onFailedToLoadContent(throwable);
            }
        });
    }

    void deletePlacement(final String imageUriToDelete, final OnDeletePlacementCallback callback) {
        this.executors.getDiskIOExecutor().execute(new Runnable(){

            @Override
            public void run() {
                final TBContent tbContent = TBNotificationRepository.this.store.getContent();
                final NotificationContentState contentState = TBNotificationRepository.this.store.getNotificationContentState();
                String zeroSizeUrlToDelete = UrlUtils.replaceImageSizeInUrl((String)imageUriToDelete, (int)0, (int)0);
                ArrayList<TBPlacement> placements = tbContent.getPlacements();
                for (int placementIndex = 0; placementIndex < placements.size(); ++placementIndex) {
                    TBRecommendationItem item = (TBRecommendationItem)((TBPlacement)placements.get(placementIndex)).getItems().get(0);
                    String zeroSizeImageUri = TBNotificationUtil.getItemThumbnailUrl(item, 0, 0);
                    if (!zeroSizeUrlToDelete.equals(zeroSizeImageUri)) continue;
                    placements.remove(placementIndex);
                    TBNotificationRepository.this.setNotificationContent(tbContent);
                    Log.d((String)TAG, (String)"deletePlacement by imageUri: found and deleted invalid item");
                    TBNotificationRepository.this.executors.getMainThreadExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            callback.onDeleted(tbContent, contentState);
                        }
                    });
                    return;
                }
                Log.d((String)TAG, (String)"deletePlacement by imageUri: deletion failed: didn't find an item (it's possible that item was already deleted by a different thumbnail fail)");
            }
        });
    }

    void deletePlacement(final TBPlacement placementToDelete, final OnDeletePlacementCallback callback) {
        this.executors.getDiskIOExecutor().execute(new Runnable(){

            @Override
            public void run() {
                final TBContent tbContent = TBNotificationRepository.this.store.getContent();
                final NotificationContentState contentState = TBNotificationRepository.this.store.getNotificationContentState();
                ArrayList<TBPlacement> placements = tbContent.getPlacements();
                for (int i = 0; i < placements.size(); ++i) {
                    TBPlacement tbPlacement = (TBPlacement)placements.get(i);
                    if (!TBNotificationRepository.this.arePlacementsEqual(placementToDelete, tbPlacement)) continue;
                    placements.remove(i);
                    TBNotificationRepository.this.setNotificationContent(tbContent);
                    TBNotificationRepository.this.executors.getMainThreadExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            callback.onDeleted(tbContent, contentState);
                        }
                    });
                    return;
                }
                Log.w((String)TAG, (String)"deletePlacement by imageUri : deletion failed: didn't find an item");
            }
        });
    }

    private boolean arePlacementsEqual(TBPlacement placement1, TBPlacement placement2) {
        String firstId = (String)((TBRecommendationItem)placement1.getItems().get(0)).getExtraDataMap().get("id");
        String secondId = (String)((TBRecommendationItem)placement2.getItems().get(0)).getExtraDataMap().get("id");
        return firstId.equals(secondId);
    }

    private String getImageUri(TBPlacement tbPlacement) {
        String rawThumbnail = (String)((TBRecommendationItem)tbPlacement.getItems().get(0)).getExtraDataMap().get("thumbnail");
        try {
            return new JSONArray(rawThumbnail).getJSONObject(0).getString("url");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return "";
        }
    }

    void fetchCurrentData(final FetchCurrentDataCallback callback) {
        this.executors.getDiskIOExecutor().execute(new Runnable(){

            @Override
            public void run() {
                final TBContent content = TBNotificationRepository.this.store.getContent();
                final NotificationContentState notificationContentState = TBNotificationRepository.this.store.getNotificationContentState();
                TBNotificationRepository.this.executors.getMainThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.onFetched(content, notificationContentState);
                    }
                });
            }
        });
    }

    void setNotificationState(final @Nullable NotificationContentState notificationContentState) {
        this.executors.getDiskIOExecutor().execute(new Runnable(){

            @Override
            public void run() {
                TBNotificationRepository.this.store.setNotificationContentState(notificationContentState);
            }
        });
    }

    private void setNotificationContent(final @Nullable TBContent content) {
        this.executors.getDiskIOExecutor().execute(new Runnable(){

            @Override
            public void run() {
                TBNotificationRepository.this.store.setContent(content);
            }
        });
    }

    public static interface OnDeletePlacementCallback {
        public void onDeleted(@NonNull TBContent var1, @NonNull NotificationContentState var2);
    }

    public static interface FetchCurrentDataCallback {
        public void onFetched(@Nullable TBContent var1, @Nullable NotificationContentState var2);
    }
}

