/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.util.Log;
import com.taboola.android.plus.BridgeInternal;
import com.taboola.android.plus.notification.NotificationConfig;
import com.taboola.android.plus.notification.TBDeviceInfoUtil;

class NotificationLayoutConfig {
    private static final String TAG = NotificationLayoutConfig.class.getSimpleName();
    static final String LAYOUT_COLLAPSED_SINGLE_DEFAULT_STRING = "layout_collapsed_single_default";
    static final String LAYOUT_COLLAPSED_SINGLE_ITEM_V1_STRING = "layout_collapsed_single_item_v1";
    static final String LAYOUT_COLLAPSED_SINGLE_ITEM_V2_STRING = "layout_collapsed_single_item_v2";
    static final String LAYOUT_COLLAPSED_MULTIPLE_THUMBNAILS_STRING = "layout_collapsed_multiple_thumbnails";
    static final String LAYOUT_EXPANDED_SINGLE_DEFAULT_STRING = "layout_expanded_single_default";
    static final String LAYOUT_EXPANDED_MULTIPLE_THUMBNAILS_STRING = "layout_expanded_multiple_thumbnails";
    static final String TEST_LAYOUT_COLLAPSED_INVALID = "test_layout_collapsed_invalid";
    private CollapsedLayout collapsedLayout;
    private ExpandedLayout expandedLayout;
    private NotificationConfig.LayoutSpecificConfigs layoutSpecificConfigs;
    private boolean shouldHideTime;
    private boolean shouldHideDescription;

    NotificationLayoutConfig() {
    }

    public static NotificationLayoutConfig determineNotificationLayout(@NonNull NotificationConfig.LayoutConfig config, @IntRange(from=1L) int availableItemCount) {
        if (availableItemCount < 1) {
            throw new IllegalArgumentException("Item count must be greater than 0");
        }
        NotificationLayoutConfig notificationLayoutConfig = new NotificationLayoutConfig();
        notificationLayoutConfig.setLayoutSpecificConfigs(config.getLayoutSpecificConfigs());
        notificationLayoutConfig.setShouldHideDescription(config.shouldHideDescription());
        notificationLayoutConfig.setShouldHideTime(config.shouldHideTime());
        CollapsedLayout preferredCollapsedLayout = CollapsedLayout.parseLayout(config.getPreferredCollapsedLayout());
        ExpandedLayout preferredExpandedLayout = ExpandedLayout.parseLayout(config.getPreferredExpandedLayout());
        if (!(preferredCollapsedLayout != CollapsedLayout.MultipleThumbnails && preferredExpandedLayout != ExpandedLayout.MultipleThumbnails || TBDeviceInfoUtil.isCustomScreenUnlockAvailable(BridgeInternal.getApplicationContext()))) {
            notificationLayoutConfig.setCollapsedLayout(CollapsedLayout.getDefaultLayout());
            notificationLayoutConfig.setExpandedLayout(ExpandedLayout.getDefaultLayout());
            return notificationLayoutConfig;
        }
        if (preferredCollapsedLayout.getMinNumberOfItems() <= availableItemCount && preferredExpandedLayout.getMinNumberOfItems() <= availableItemCount) {
            notificationLayoutConfig.setCollapsedLayout(preferredCollapsedLayout);
            notificationLayoutConfig.setExpandedLayout(preferredExpandedLayout);
            return notificationLayoutConfig;
        }
        notificationLayoutConfig.setCollapsedLayout(CollapsedLayout.getDefaultLayout());
        notificationLayoutConfig.setExpandedLayout(ExpandedLayout.getDefaultLayout());
        return notificationLayoutConfig;
    }

    public int getMinNumberOfItems() {
        return Math.min(this.collapsedLayout.getMinNumberOfItems(), this.collapsedLayout.getMinNumberOfItems());
    }

    public int getMaxNumberOfItems() {
        return Math.max(this.collapsedLayout.getMaxNumberOfItems(), this.expandedLayout.getMaxNumberOfItems());
    }

    public CollapsedLayout getCollapsedLayout() {
        return this.collapsedLayout;
    }

    public void setCollapsedLayout(CollapsedLayout collapsedLayout) {
        this.collapsedLayout = collapsedLayout;
    }

    public ExpandedLayout getExpandedLayout() {
        return this.expandedLayout;
    }

    public void setExpandedLayout(ExpandedLayout expandedLayout) {
        this.expandedLayout = expandedLayout;
    }

    public NotificationConfig.LayoutSpecificConfigs getLayoutSpecificConfigs() {
        return this.layoutSpecificConfigs;
    }

    public void setLayoutSpecificConfigs(NotificationConfig.LayoutSpecificConfigs layoutSpecificConfigs) {
        this.layoutSpecificConfigs = layoutSpecificConfigs;
    }

    public boolean shouldHideTime() {
        return this.shouldHideTime;
    }

    public void setShouldHideTime(boolean shouldHideTime) {
        this.shouldHideTime = shouldHideTime;
    }

    public boolean shouldHideDescription() {
        return this.shouldHideDescription;
    }

    public void setShouldHideDescription(boolean shouldHideDescription) {
        this.shouldHideDescription = shouldHideDescription;
    }

    public static enum ExpandedLayout {
        SingleDefault("layout_expanded_single_default", 1, 1),
        MultipleThumbnails("layout_expanded_multiple_thumbnails", 2, 6);

        private String LayoutStringKey;
        private int minNumberOfItems;
        private int maxNumberOfItems;

        static ExpandedLayout parseLayout(String preferredExpandedLayoutString) {
            switch (preferredExpandedLayoutString) {
                case "layout_expanded_single_default": {
                    return SingleDefault;
                }
                case "layout_expanded_multiple_thumbnails": {
                    return MultipleThumbnails;
                }
            }
            Log.e((String)TAG, (String)"parseLayout: unknown Expanded layout key. Using default");
            return ExpandedLayout.getDefaultLayout();
        }

        private ExpandedLayout(String layoutStringKey, int minNumberOfItems, int maxNumberOfItems) {
            this.LayoutStringKey = layoutStringKey;
            this.minNumberOfItems = minNumberOfItems;
            this.maxNumberOfItems = maxNumberOfItems;
        }

        public String getLayoutStringKey() {
            return this.LayoutStringKey;
        }

        public int getMinNumberOfItems() {
            return this.minNumberOfItems;
        }

        public int getMaxNumberOfItems() {
            return this.maxNumberOfItems;
        }

        public static ExpandedLayout getDefaultLayout() {
            return SingleDefault;
        }

        public String toString() {
            return this.getLayoutStringKey();
        }
    }

    public static enum CollapsedLayout {
        SingleDefault("layout_collapsed_single_default", 1, 1),
        SingleItemV1("layout_collapsed_single_item_v1", 1, 1),
        SingleItemV2("layout_collapsed_single_item_v2", 1, 1),
        SingleTestInvalid("layout_collapsed_single_default", 1, 1),
        MultipleThumbnails("layout_collapsed_multiple_thumbnails", 2, 3);

        private String LayoutStringKey;
        private int minNumberOfItems;
        private int maxNumberOfItems;

        static CollapsedLayout parseLayout(String preferredCollapsedLayoutString) {
            switch (preferredCollapsedLayoutString) {
                case "layout_collapsed_single_default": {
                    return SingleDefault;
                }
                case "layout_collapsed_single_item_v1": {
                    return SingleItemV1;
                }
                case "layout_collapsed_single_item_v2": {
                    return SingleItemV2;
                }
                case "layout_collapsed_multiple_thumbnails": {
                    return MultipleThumbnails;
                }
                case "test_layout_collapsed_invalid": {
                    return SingleTestInvalid;
                }
            }
            Log.e((String)TAG, (String)"parseLayout: unknown Collapsed layout key. Using default");
            return CollapsedLayout.getDefaultLayout();
        }

        private CollapsedLayout(String layoutStringKey, int minNumberOfItems, int maxNumberOfItems) {
            this.LayoutStringKey = layoutStringKey;
            this.minNumberOfItems = minNumberOfItems;
            this.maxNumberOfItems = maxNumberOfItems;
        }

        public String getLayoutStringKey() {
            return this.LayoutStringKey;
        }

        public int getMinNumberOfItems() {
            return this.minNumberOfItems;
        }

        public int getMaxNumberOfItems() {
            return this.maxNumberOfItems;
        }

        public static CollapsedLayout getDefaultLayout() {
            return SingleDefault;
        }

        public String toString() {
            return this.getLayoutStringKey();
        }
    }
}

