/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.shared;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.Gson;

public abstract class AbstractLocalStorage {
    protected static final Gson gson = new Gson();
    protected final SharedPreferences sharedPreferences;

    protected AbstractLocalStorage(@NonNull Context applicationContext, @NonNull String sharedPrefsFileName) {
        this.sharedPreferences = applicationContext.getSharedPreferences(sharedPrefsFileName, 0);
    }

    protected void putString(@NonNull String key, @Nullable String value) {
        this.sharedPreferences.edit().putString(key, value).apply();
    }

    @Nullable
    protected String getString(@NonNull String key) {
        return this.sharedPreferences.getString(key, null);
    }

    protected void putInt(@NonNull String key, int value) {
        this.sharedPreferences.edit().putInt(key, value).apply();
    }

    protected int getInt(@NonNull String key) {
        return this.sharedPreferences.getInt(key, -1);
    }

    protected void putLong(@NonNull String key, long value) {
        this.sharedPreferences.edit().putLong(key, value).apply();
    }

    protected long getLong(@NonNull String key) {
        return this.sharedPreferences.getLong(key, -1L);
    }

    protected void putBoolean(@NonNull String key, boolean value) {
        this.sharedPreferences.edit().putBoolean(key, value).apply();
    }

    protected boolean getBoolean(@NonNull String key) {
        return this.sharedPreferences.getBoolean(key, false);
    }
}

