/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification.killSwitch;

import android.content.Context;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.taboola.android.plus.notification.TBNotificationAnalyticsManager;
import com.taboola.android.plus.notification.killSwitch.FrequentCrashBlockConfig;
import com.taboola.android.plus.notification.killSwitch.KillSwitchStorage;
import com.taboola.android.plus.notification.killSwitch.KillSwitchUtil;
import com.taboola.android.utils.Logger;

public class SdkPlusUncaughtExceptionHandler {
    private static final String TAG = SdkPlusUncaughtExceptionHandler.class.getSimpleName();
    private static final String TABOOLA_SDK_PLUS_PACKAGE = "com.taboola.android.plus";
    @NonNull
    private Context applicationContext;
    @NonNull
    private Thread.UncaughtExceptionHandler sdkPlusExceptionHandler;
    @Nullable
    private Thread.UncaughtExceptionHandler defaultExceptionHandler;
    @Nullable
    private Throwable lastThrownException;
    @NonNull
    private FrequentCrashBlockConfig frequentCrashBlockConfig;

    public SdkPlusUncaughtExceptionHandler(@NonNull Context applicationContext, @NonNull FrequentCrashBlockConfig frequentCrashBlockConfig) {
        this.applicationContext = applicationContext;
        this.frequentCrashBlockConfig = frequentCrashBlockConfig;
        this.sdkPlusExceptionHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                Log.d((String)TAG, (String)("uncaughtException: new UncaughtException: " + throwable.getMessage()));
                if (SdkPlusUncaughtExceptionHandler.this.isSameException(SdkPlusUncaughtExceptionHandler.this.lastThrownException, throwable)) {
                    Log.d((String)TAG, (String)"uncaughtException: exception ignored: the same exception received multiple times. (Probably there is a loop between exception handlers)");
                    return;
                }
                SdkPlusUncaughtExceptionHandler.this.lastThrownException = throwable;
                if (SdkPlusUncaughtExceptionHandler.this.shouldHandleException(throwable)) {
                    Log.d((String)TAG, (String)"uncaughtException: exception is considered related to sdk+, handling");
                    SdkPlusUncaughtExceptionHandler.this.handleException(throwable);
                } else {
                    Log.d((String)TAG, (String)"uncaughtException: exception is not considered related to sdk+");
                }
                if (SdkPlusUncaughtExceptionHandler.this.defaultExceptionHandler != null) {
                    Logger.d((String)TAG, (String)("Returning exception to previous exception handler: " + throwable.getMessage()));
                    SdkPlusUncaughtExceptionHandler.this.defaultExceptionHandler.uncaughtException(thread, throwable);
                } else {
                    Log.d((String)TAG, (String)"uncaughtException: default exception handler is not set");
                }
            }
        };
    }

    @MainThread
    public void start() {
        Thread.UncaughtExceptionHandler currentUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (this.isRedundantStart(currentUncaughtExceptionHandler)) {
            Log.d((String)TAG, (String)"start: SdkPlusUncaughtExceptionHandler is already set as default. ignoring call to start()");
            return;
        }
        this.defaultExceptionHandler = currentUncaughtExceptionHandler;
        Thread.setDefaultUncaughtExceptionHandler(this.sdkPlusExceptionHandler);
        Log.d((String)TAG, (String)"start: everything is inited");
    }

    public void stop() {
        Log.d((String)TAG, (String)"stop() called");
        Thread.setDefaultUncaughtExceptionHandler(this.defaultExceptionHandler);
    }

    private void handleException(Throwable throwable) {
        KillSwitchStorage killSwitchStorage = new KillSwitchStorage(this.applicationContext);
        long currentTimestamp = System.currentTimeMillis();
        killSwitchStorage.addExceptionOccurred(currentTimestamp);
        int currentExceptionCountForPeriod = killSwitchStorage.getCurrentExceptionCountForPeriod(this.frequentCrashBlockConfig.getExceptionCountPeriodMs());
        Log.d((String)TAG, (String)("handleException: currentExceptionCountForPeriod: " + currentExceptionCountForPeriod));
        long exceptionCountThreshold = this.frequentCrashBlockConfig.getExceptionCountThreshold();
        Log.d((String)TAG, (String)("handleException: exceptionCountThreshold: " + exceptionCountThreshold));
        TBNotificationAnalyticsManager analyticsManager = new TBNotificationAnalyticsManager(this.applicationContext);
        if ((long)currentExceptionCountForPeriod > exceptionCountThreshold) {
            Log.d((String)TAG, (String)("handleException: more than max allowed " + exceptionCountThreshold + " exceptions were thrown, blocking notifications"));
            killSwitchStorage.setLastNotificationBlockTriggeredTimestamp(currentTimestamp);
            analyticsManager.sendNotificationBlockedByFrequentCrashes(currentExceptionCountForPeriod);
        }
        analyticsManager.sendUncaughtExceptionEvent(throwable, currentExceptionCountForPeriod, this.frequentCrashBlockConfig.getExceptionCountPeriodMs());
    }

    private boolean shouldHandleException(Throwable throwable) {
        StackTraceElement[] elements;
        if (KillSwitchUtil.isNotificationException(throwable)) {
            return true;
        }
        for (StackTraceElement ste : elements = throwable.getStackTrace()) {
            if (!ste.getClassName().contains(TABOOLA_SDK_PLUS_PACKAGE)) continue;
            return true;
        }
        return false;
    }

    private boolean isSameException(@Nullable Throwable lastThrownException, @NonNull Throwable newException) {
        if (lastThrownException == null) {
            return false;
        }
        String lastThrownMessage = lastThrownException.getMessage();
        String newThrownMessage = newException.getMessage();
        if (newThrownMessage == null && lastThrownMessage == null) {
            return true;
        }
        if (newThrownMessage != null && lastThrownMessage != null) {
            return newThrownMessage.equals(lastThrownMessage);
        }
        return false;
    }

    private boolean isRedundantStart(Thread.UncaughtExceptionHandler currentUncaughtExceptionHandler) {
        return currentUncaughtExceptionHandler != null && currentUncaughtExceptionHandler.toString().contains(SdkPlusUncaughtExceptionHandler.class.getSimpleName());
    }
}

