/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.homeScreenNews;

import android.content.Context;
import android.content.SharedPreferences;

class HomeScreenLocalRepository {
    private static final String SHARED_PREFS_KEY = "com.taboola.android.reader.SHARED_PREFERENCES_KEY.HomeScreen";
    private static final String IS_PERIODIC_INVITATION_ENABLED = "is_periodic_invitation_enabled";
    private static final String LAST_INVITATION_TIMESTAMP = "refreshed_timestamp";

    HomeScreenLocalRepository() {
    }

    public static void setPeriodicInvitationEnabled(Context appContext, boolean isEnabled) {
        SharedPreferences preferences = appContext.getSharedPreferences(SHARED_PREFS_KEY, 0);
        preferences.edit().putBoolean(IS_PERIODIC_INVITATION_ENABLED, isEnabled).apply();
    }

    public static boolean getPeriodicInvitationEnabled(Context appContext) {
        SharedPreferences preferences = appContext.getSharedPreferences(SHARED_PREFS_KEY, 0);
        return preferences.getBoolean(IS_PERIODIC_INVITATION_ENABLED, false);
    }

    public static long getLastInvitationTimestamp(Context appContext) {
        SharedPreferences preferences = appContext.getSharedPreferences(SHARED_PREFS_KEY, 0);
        return preferences.getLong(LAST_INVITATION_TIMESTAMP, 0L);
    }

    public static void setLastInvitationTimestamp(Context appContext, long timestamp) {
        SharedPreferences preferences = appContext.getSharedPreferences(SHARED_PREFS_KEY, 0);
        preferences.edit().putLong(LAST_INVITATION_TIMESTAMP, timestamp).apply();
    }

    public static long getLastUsedInvitationIntervalMs(Context appContext) {
        SharedPreferences preferences = appContext.getSharedPreferences(SHARED_PREFS_KEY, 0);
        return preferences.getLong(LAST_INVITATION_TIMESTAMP, 0L);
    }

    public static void setLastUsedInvitationIntervalMs(Context appContext, long timestamp) {
        SharedPreferences preferences = appContext.getSharedPreferences(SHARED_PREFS_KEY, 0);
        preferences.edit().putLong(LAST_INVITATION_TIMESTAMP, timestamp).apply();
    }
}

