/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.taboola.android.api.TaboolaApi;
import com.taboola.android.plus.ConfigManager;
import com.taboola.android.plus.PublicApi;
import com.taboola.android.plus.SdkPlusConfig;
import com.taboola.android.plus.content.ContentConfig;
import com.taboola.android.plus.content.LanguagesConfig;
import com.taboola.android.plus.content.TBContentManager;
import com.taboola.android.plus.notification.BridgeInternal;
import com.taboola.android.plus.notification.NotificationConfig;
import com.taboola.android.plus.notification.TBNotificationAnalyticsManager;
import com.taboola.android.plus.notification.TBNotificationLocalStore;
import com.taboola.android.plus.notification.TBNotificationManager;
import com.taboola.android.plus.notification.killSwitch.FrequentCrashBlockConfig;
import com.taboola.android.plus.notification.killSwitch.SdkPlusUncaughtExceptionHandler;
import java.util.HashMap;
import java.util.Map;

@Keep
@RequiresApi(api=21)
public class TaboolaPlus
implements PublicApi.PublicTaboolaPlus {
    private static final String TAG = TaboolaPlus.class.getSimpleName();
    private static TaboolaPlus singleton = null;
    private static Context applicationContext;
    private static SdkPlusUncaughtExceptionHandler sdkPlusUncaughtExceptionHandler;
    private boolean isInitialized = false;
    private TBNotificationManager notificationManager;
    private TBNotificationLocalStore notificationLocalStorage = new TBNotificationLocalStore(applicationContext);

    private TaboolaPlus() {
        this.notificationManager = BridgeInternal.newTBNotificationManager(applicationContext, new TBContentManager(applicationContext), this.notificationLocalStorage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TaboolaPlus getInstanceInternal() {
        if (singleton != null) return singleton;
        Class<TaboolaPlus> clazz = TaboolaPlus.class;
        synchronized (TaboolaPlus.class) {
            if (singleton != null) return singleton;
            singleton = new TaboolaPlus();
            TaboolaPlus.initSdkPlusUncaughtExceptionHandler(applicationContext);
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    static void setApplicationContext(@NonNull Context applicationContext) {
        TaboolaPlus.applicationContext = applicationContext;
        if (applicationContext == null) {
            Log.e((String)TAG, (String)"setApplicationContext: context is null");
        } else {
            Log.d((String)TAG, (String)"setApplicationContext: context is not null");
        }
    }

    @Nullable
    static Context getApplicationContext() {
        return applicationContext;
    }

    @UiThread
    public static void init(@NonNull String publisherName, @NonNull String configId, @NonNull TaboolaPlusRetrievedCallback onSuccessfulCallback) {
        TaboolaPlus.init(publisherName, configId, onSuccessfulCallback, null);
    }

    @UiThread
    public static void init(@NonNull String publisherName, @NonNull String configId, @NonNull TaboolaPlusRetrievedCallback onSuccessfulCallback, @Nullable TaboolaPlusRetrieveFailedCallback onFailedCallback) {
        TaboolaPlus.init(publisherName, configId, null, onSuccessfulCallback, onFailedCallback);
    }

    @UiThread
    public static void init(@NonNull String publisherName, @NonNull String configId, @Nullable Map<String, String> taboolaPlusExtraProperties, @NonNull TaboolaPlusRetrievedCallback onSuccessfulCallback, @Nullable TaboolaPlusRetrieveFailedCallback onFailedCallback) {
        TaboolaPlus taboolaPlus = TaboolaPlus.getInstanceInternal();
        TBNotificationLocalStore localStorage = taboolaPlus.notificationLocalStorage;
        if (Build.VERSION.SDK_INT < 21) {
            Log.i((String)TAG, (String)"isInitialized: Android version is less than LOLLIPOP. Ignoring call.");
            onSuccessfulCallback.onTaboolaPlusRetrieved(taboolaPlus);
            return;
        }
        TaboolaPlus.setDefaultSettings(localStorage);
        localStorage.setPublisher(publisherName);
        localStorage.setConfigId(configId);
        localStorage.setTaboolaPlusExtraProperties(taboolaPlusExtraProperties);
        TaboolaPlus.applyNewConfigs(publisherName, configId, taboolaPlusExtraProperties, onSuccessfulCallback, onFailedCallback, taboolaPlus);
        ConfigManager.triggerAsyncConfigsUpdate(applicationContext, publisherName, configId);
    }

    private static void setDefaultSettings(@NonNull TBNotificationLocalStore localStore) {
        localStore.setWifiOnlyModeRuntimeFlag(false);
        localStore.setEnabled(false);
        localStore.setApplicationName("");
        localStore.setTaboolaPlusExtraProperties(null);
    }

    @WorkerThread
    private static void initSdkPlusUncaughtExceptionHandler(Context applicationContext) {
        if (Build.VERSION.SDK_INT < 21) {
            Log.v((String)TAG, (String)"initSdkPlusUncaughtExceptionHandler: Android version is less than LOLLIPOP. Ignoring call.");
            return;
        }
        ConfigManager.CachedSdkConfigContainer currentSdkConfig = ConfigManager.getCurrentSdkConfig(applicationContext);
        if (currentSdkConfig == null) {
            Log.v((String)TAG, (String)"initSdkPlusUncaughtExceptionHandler: current sdkPlus config is empty skipping ExceptionHandler init");
        } else {
            FrequentCrashBlockConfig frequentCrashBlockConfig = currentSdkConfig.getSdkPlusConfig().getNotificationConfig().getKillSwitchConfig().getFrequentCrashBlockConfig();
            if (frequentCrashBlockConfig.isFrequentCrashBlockEnabled() && sdkPlusUncaughtExceptionHandler == null) {
                sdkPlusUncaughtExceptionHandler = new SdkPlusUncaughtExceptionHandler(applicationContext, frequentCrashBlockConfig);
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        sdkPlusUncaughtExceptionHandler.start();
                    }
                });
            }
        }
    }

    @Override
    public TBNotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    @UiThread
    static void reInit(@NonNull TaboolaPlusRetrievedCallback onSuccessfulCallback, @Nullable TaboolaPlusRetrieveFailedCallback onFailedCallback) {
        TaboolaPlus taboolaPlus = TaboolaPlus.getInstanceInternal();
        String publisherName = taboolaPlus.notificationLocalStorage.getPublisher();
        String configId = taboolaPlus.notificationLocalStorage.getConfigId();
        HashMap<String, String> extraProperties = taboolaPlus.notificationLocalStorage.getTaboolaPlusExtraProperties();
        TaboolaPlus.applyNewConfigs(publisherName, configId, extraProperties, onSuccessfulCallback, onFailedCallback, taboolaPlus);
        ConfigManager.triggerAsyncConfigsUpdate(applicationContext, publisherName, configId);
    }

    @UiThread
    private static void applyNewConfigs(@NonNull String publisherName, @NonNull String configId, final @Nullable Map<String, String> taboolaPlusExtraProperties, final @NonNull TaboolaPlusRetrievedCallback onSuccessfulCallback, final @Nullable TaboolaPlusRetrieveFailedCallback onFailedCallback, final @NonNull TaboolaPlus taboolaPlus) {
        ConfigManager.getNewConfigs(applicationContext, publisherName, configId, true, new ConfigManager.OnGetAllConfigsCallback(){

            @Override
            public void onConfigsFetched(SdkPlusConfig config, LanguagesConfig languagesConfig) {
                TBNotificationLocalStore localStore = new TBNotificationLocalStore(applicationContext);
                TBNotificationAnalyticsManager analyticsManager = new TBNotificationAnalyticsManager(applicationContext, localStore);
                analyticsManager.sendNotificationConfigRefreshedEvent();
                taboolaPlus.applyConfigs(config, languagesConfig, taboolaPlusExtraProperties, onSuccessfulCallback);
            }

            @Override
            public void onConfigsFailed(Throwable throwable) {
                Log.e((String)TAG, (String)("applyNewConfigs: failed to get configs: " + throwable.getMessage()));
                if (onFailedCallback != null) {
                    onFailedCallback.onTaboolaPlusRetrieveFailed(throwable);
                }
            }
        });
    }

    @UiThread
    static void restore(final @NonNull TaboolaPlusRetrievedCallback successfulCallback, final @Nullable TaboolaPlusRetrieveFailedCallback failedCallback) {
        final TaboolaPlus taboolaPlus = TaboolaPlus.getInstanceInternal();
        if (taboolaPlus.isInitialized() && TaboolaApi.getInstance().isInitialized()) {
            Log.i((String)TAG, (String)"restore: successful (already initialized)");
            successfulCallback.onTaboolaPlusRetrieved(taboolaPlus);
        } else {
            String publisherName = taboolaPlus.notificationLocalStorage.getPublisher();
            String configId = taboolaPlus.notificationLocalStorage.getConfigId();
            final HashMap<String, String> extraProperties = taboolaPlus.notificationLocalStorage.getTaboolaPlusExtraProperties();
            ConfigManager.getCurrentConfigs(applicationContext, publisherName, configId, new ConfigManager.OnGetAllConfigsCallback(){

                @Override
                public void onConfigsFetched(SdkPlusConfig config, LanguagesConfig languagesConfig) {
                    taboolaPlus.applyConfigs(config, languagesConfig, extraProperties, successfulCallback);
                }

                @Override
                public void onConfigsFailed(Throwable throwable) {
                    Log.e((String)TAG, (String)("restore: failed to get configs: " + throwable.getMessage()));
                    if (failedCallback != null) {
                        failedCallback.onTaboolaPlusRetrieveFailed(throwable);
                    }
                }
            });
        }
    }

    @UiThread
    private void applyConfigs(@NonNull SdkPlusConfig sdkPlusConfig, @NonNull LanguagesConfig languagesConfig, @Nullable Map<String, String> taboolaPlusExtraProperties, @NonNull TaboolaPlusRetrievedCallback successfulCallback) {
        NotificationConfig notificationConfig = sdkPlusConfig.getNotificationConfig();
        ContentConfig contentConfig = sdkPlusConfig.getContentConfig();
        this.notificationLocalStorage.setNonClickableUrlMarker(notificationConfig.getNonClickableUrlMarker());
        String configVariant = notificationConfig.getConfigVariant();
        if (configVariant != null) {
            this.notificationLocalStorage.setConfigVariant(configVariant);
        }
        TaboolaPlus.initTaboolaApi(applicationContext, contentConfig, languagesConfig, taboolaPlusExtraProperties);
        BridgeInternal.applyConfig(this.notificationManager, notificationConfig, contentConfig);
        this.isInitialized = true;
        successfulCallback.onTaboolaPlusRetrieved(this);
    }

    @UiThread
    static void initTaboolaApi(Context appContext, @NonNull ContentConfig contentConfig, @NonNull LanguagesConfig languagesConfig, @Nullable Map<String, String> taboolaPlusExtraProperties) {
        HashMap<String, String> taboolaApiExtraProperties;
        String localizedPublisherName = ConfigManager.getLocalizedPublisherName(appContext, languagesConfig);
        String apiKey = contentConfig.getTaboolaApiConfig().getApiKey();
        HashMap<String, String> mergedExtraProperties = new HashMap<String, String>();
        if (taboolaPlusExtraProperties != null) {
            mergedExtraProperties.putAll(taboolaPlusExtraProperties);
        }
        if ((taboolaApiExtraProperties = contentConfig.getTaboolaApiConfig().getTaboolaApiExtraProperties()) != null) {
            mergedExtraProperties.putAll(taboolaApiExtraProperties);
        }
        mergedExtraProperties.put("enableFullRawDataResponse", "true");
        TaboolaApi.getInstance().init(appContext, localizedPublisherName, apiKey, mergedExtraProperties);
    }

    private boolean isInitialized() {
        return this.isInitialized;
    }

    public static interface TaboolaPlusRetrieveFailedCallback {
        public void onTaboolaPlusRetrieveFailed(Throwable var1);
    }

    public static interface TaboolaPlusRetrievedCallback {
        public void onTaboolaPlusRetrieved(TaboolaPlus var1);
    }
}

