/*
 * Decompiled with CFR 0.152.
 */
package com.ocamba.hoood.geo;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.v4.app.JobIntentService;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.ocamba.hoood.OcambaRequest;
import com.ocamba.hoood.R;
import com.ocamba.hoood.geo.OcambaGeofence;
import com.ocamba.hoood.geo.OcambaGeofenceError;
import com.ocamba.hoood.geo.OcambaGeofencePrefManager;
import com.ocamba.hoood.geo.OcambaLocationUpdateBroadcastReceiver;
import com.ocamba.hoood.util.OcambaLogUtils;
import java.util.List;

public class OcambaGeofenceTransitionsJobIntentService
extends JobIntentService {
    private static final int JOB_ID = 764;
    private static final String TAG = OcambaGeofenceTransitionsJobIntentService.class.getSimpleName();
    private FusedLocationProviderClient mFusedLocationClient;
    private LocationRequest mLocationRequest;
    private PendingIntent mLocationIntent;

    public static void enqueueWork(Context context, Intent intent) {
        OcambaGeofenceTransitionsJobIntentService.enqueueWork((Context)context, OcambaGeofenceTransitionsJobIntentService.class, (int)764, (Intent)intent);
    }

    @RequiresApi(api=16)
    protected void onHandleWork(@NonNull Intent intent) {
        GeofencingEvent geofencingEvent = GeofencingEvent.fromIntent((Intent)intent);
        if (geofencingEvent.hasError()) {
            String errorMessage = OcambaGeofenceError.getErrorString((Context)this, geofencingEvent.getErrorCode());
            OcambaLogUtils.e(TAG, errorMessage);
            return;
        }
        int transitionType = geofencingEvent.getGeofenceTransition();
        if (transitionType == 1 || transitionType == 2) {
            List triggeringGeofences = geofencingEvent.getTriggeringGeofences();
            for (Geofence geofence : triggeringGeofences) {
                OcambaGeofence ocambaGeofence = OcambaGeofencePrefManager.getGeofence(geofence.getRequestId());
                if (ocambaGeofence.isPolygon()) {
                    this.initLocationTracking(ocambaGeofence.getId());
                    if (transitionType == 1) {
                        this.startLocationTracking();
                        continue;
                    }
                    this.removeLocationUpdate();
                    continue;
                }
                OcambaRequest.geofenceTransition(transitionType == 1 ? 220 : 221, geofence.getRequestId());
            }
        } else {
            OcambaLogUtils.e(TAG, this.getString(R.string.geofence_transition_invalid_type, new Object[]{transitionType}));
        }
    }

    private void initLocationTracking(String geofenceId) {
        if (this.mFusedLocationClient == null && this.mLocationRequest == null && this.mLocationIntent == null) {
            OcambaLogUtils.d(TAG, "Init location tracking. [" + geofenceId + "]");
            this.mFusedLocationClient = LocationServices.getFusedLocationProviderClient((Context)this);
            this.mLocationRequest = LocationRequest.create();
            this.mLocationRequest.setInterval(10L);
            this.mLocationRequest.setPriority(100);
            this.mLocationIntent = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)new Intent((Context)this, OcambaLocationUpdateBroadcastReceiver.class).setAction(geofenceId), (int)0x10000000);
        }
    }

    private void startLocationTracking() {
        if (this.mFusedLocationClient != null && this.mLocationIntent != null && this.mLocationRequest != null) {
            OcambaLogUtils.d(TAG, "Start location tracking.");
            this.mFusedLocationClient.requestLocationUpdates(this.mLocationRequest, this.mLocationIntent);
        }
    }

    private void removeLocationUpdate() {
        if (this.mFusedLocationClient != null && this.mLocationIntent != null) {
            OcambaLogUtils.d(TAG, "Remove location tracking.");
            this.mFusedLocationClient.removeLocationUpdates(this.mLocationIntent);
        }
    }
}

