/*
 * Decompiled with CFR 0.152.
 */
package com.ocamba.hoood.geo;

import com.ocamba.hoood.geo.OcambaGeofenceLatLng;
import com.ocamba.hoood.util.MathUtils;
import java.util.List;

public class OcambaGeofencePolygonUtils {
    public static final String TAG = OcambaGeofencePolygonUtils.class.getSimpleName();

    public static boolean containsLocation(OcambaGeofenceLatLng point, List<OcambaGeofenceLatLng> polygon, boolean geodesic) {
        return OcambaGeofencePolygonUtils.containsLocation(point.latitude, point.longitude, polygon, geodesic);
    }

    public static boolean containsLocation(double latitude, double longitude, List<OcambaGeofenceLatLng> polygon, boolean geodesic) {
        try {
            int size = polygon.size();
            if (size == 0) {
                return false;
            }
            double lat = Math.toRadians(latitude);
            double lng = Math.toRadians(longitude);
            OcambaGeofenceLatLng prev = polygon.get(size - 1);
            double lat1 = Math.toRadians(prev.latitude);
            double lng1 = Math.toRadians(prev.longitude);
            int nIntersect = 0;
            for (OcambaGeofenceLatLng point2 : polygon) {
                double lng2;
                double dLng3 = MathUtils.wrap(lng - lng1, -Math.PI, Math.PI);
                if (lat == lat1 && dLng3 == 0.0) {
                    return true;
                }
                double lat2 = Math.toRadians(point2.latitude);
                if (OcambaGeofencePolygonUtils.intersects(lat1, lat2, MathUtils.wrap((lng2 = Math.toRadians(point2.longitude)) - lng1, -Math.PI, Math.PI), lat, dLng3, geodesic)) {
                    ++nIntersect;
                }
                lat1 = lat2;
                lng1 = lng2;
            }
            return nIntersect & true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean intersects(double lat1, double lat2, double lng2, double lat3, double lng3, boolean geodesic) {
        if ((lng3 < 0.0 || lng3 < lng2) && (lng3 >= 0.0 || lng3 >= lng2)) {
            if (lat3 <= -1.5707963267948966) {
                return false;
            }
            if (lat1 > -1.5707963267948966 && lat2 > -1.5707963267948966 && lat1 < 1.5707963267948966 && lat2 < 1.5707963267948966) {
                if (lng2 <= -Math.PI) {
                    return false;
                }
                double linearLat = (lat1 * (lng2 - lng3) + lat2 * lng3) / lng2;
                if (lat1 >= 0.0 && lat2 >= 0.0 && lat3 < linearLat) {
                    return false;
                }
                if (lat1 <= 0.0 && lat2 <= 0.0 && lat3 >= linearLat) {
                    return true;
                }
                if (lat3 >= 1.5707963267948966) {
                    return true;
                }
                return geodesic ? Math.tan(lat3) >= OcambaGeofencePolygonUtils.tanLatGC(lat1, lat2, lng2, lng3) : MathUtils.mercator(lat3) >= OcambaGeofencePolygonUtils.mercatorLatRhumb(lat1, lat2, lng2, lng3);
            }
            return false;
        }
        return false;
    }

    private static double tanLatGC(double lat1, double lat2, double lng2, double lng3) {
        return (Math.tan(lat1) * Math.sin(lng2 - lng3) + Math.tan(lat2) * Math.sin(lng3)) / Math.sin(lng2);
    }

    private static double mercatorLatRhumb(double lat1, double lat2, double lng2, double lng3) {
        return (MathUtils.mercator(lat1) * (lng2 - lng3) + MathUtils.mercator(lat2) * lng3) / lng2;
    }
}

