/*
 * Decompiled with CFR 0.152.
 */
package com.ocamba.hoood.geo;

import android.content.Context;
import android.content.res.Resources;
import com.google.android.gms.common.api.ApiException;
import com.ocamba.hoood.R;

class OcambaGeofenceError {
    private OcambaGeofenceError() {
    }

    public static String getErrorString(Context context, Exception e) {
        if (e instanceof ApiException) {
            return OcambaGeofenceError.getErrorString(context, ((ApiException)e).getStatusCode());
        }
        if (context == null) {
            return e.getMessage();
        }
        return context.getResources().getString(R.string.unknown_geofence_error);
    }

    public static String getErrorString(Context context, int errorCode) {
        if (context == null) {
            return String.valueOf(errorCode);
        }
        Resources mResources = context.getResources();
        switch (errorCode) {
            case 1000: {
                return mResources.getString(R.string.geofence_not_available);
            }
            case 1001: {
                return mResources.getString(R.string.geofence_too_many_geofences);
            }
            case 1002: {
                return mResources.getString(R.string.geofence_too_many_pending_intents);
            }
        }
        return mResources.getString(R.string.unknown_geofence_error);
    }
}

