/*
 * Decompiled with CFR 0.152.
 */
package com.ocamba.hoood;

import android.content.Context;
import android.os.SystemClock;
import android.webkit.URLUtil;
import com.google.firebase.messaging.RemoteMessage;
import com.ocamba.hoood.OcambaHoood;
import com.ocamba.hoood.OcambaPrefManager;
import com.ocamba.hoood.OcambaRequest;
import com.ocamba.hoood.beacon.OcambaBeaconUtils;
import com.ocamba.hoood.geo.OcambaGeofenceUtils;
import com.ocamba.hoood.notifications.OcambaNotificationObject;
import com.ocamba.hoood.notifications.OcambaNotificationRenderer;
import com.ocamba.hoood.util.OcambaLogUtils;
import com.ocamba.hoood.util.OcambaUtils;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OcambaNotificationParser {
    public static final String TAG = OcambaNotificationParser.class.getSimpleName();
    private Context mContext;
    private static String mCustomData = "";

    public OcambaNotificationParser(Context context) {
        this.mContext = context;
    }

    public void parseRemoteMessage(RemoteMessage remoteMessage) {
        block15: {
            JSONObject jsonObject;
            try {
                jsonObject = new JSONObject(remoteMessage.getData());
            }
            catch (Exception e) {
                OcambaRequest.postCrash(e.getMessage());
                return;
            }
            if (jsonObject.has("notification")) {
                try {
                    JSONObject jsonCheck = new JSONObject(jsonObject.getString("notification"));
                    OcambaLogUtils.d(TAG, "parseRemoteMessage() JSON: " + jsonCheck);
                    if (jsonCheck.has("c")) {
                        String customData;
                        mCustomData = customData = jsonCheck.getString("c");
                        OcambaUtils.sendOcambaCustomAction(OcambaHoood.getContext(), customData);
                    }
                    if (jsonCheck.has("a")) {
                        // empty if block
                    }
                    if (jsonCheck.has("n")) {
                        this.parse("n", jsonCheck);
                        break block15;
                    }
                    if (jsonCheck.has("e")) {
                        this.parse("e", jsonCheck);
                        break block15;
                    }
                    if (jsonCheck.has("gl")) {
                        if (OcambaHoood.getBuilder().isGeofenceDisabled()) {
                            return;
                        }
                        if (!OcambaUtils.isGooglePlayServicesAvailable(this.mContext)) {
                            return;
                        }
                        if (!OcambaUtils.checkLocationPermissions(this.mContext)) {
                            OcambaLogUtils.w(TAG, "initGeofence: Please, enable location permission!");
                            return;
                        }
                        this.parseGeofence(jsonCheck.getJSONArray("gl"));
                        break block15;
                    }
                    if (jsonCheck.has("bl")) {
                        this.parseBeacon(jsonCheck.getJSONArray("bl"));
                        break block15;
                    }
                    OcambaUtils.sendCustomMessageReceived(this.mContext, remoteMessage);
                }
                catch (JSONException e) {
                    OcambaUtils.sendCustomMessageReceived(this.mContext, remoteMessage);
                    e.printStackTrace();
                }
            } else {
                OcambaUtils.sendCustomMessageReceived(this.mContext, remoteMessage);
            }
        }
    }

    private void parseGeofence(JSONArray geofencesArray) {
        OcambaLogUtils.d(TAG, "parseGeofence() called with: geofencesArray = [" + geofencesArray + "]");
        OcambaGeofenceUtils.init(this.mContext);
        for (int i = 0; i < geofencesArray.length(); ++i) {
            try {
                JSONObject geofenceObject = geofencesArray.getJSONObject(i);
                String id2 = geofenceObject.getString("id");
                if (geofenceObject.has("c")) {
                    float radius = geofenceObject.getInt("r");
                    long expire = geofenceObject.getInt("ed");
                    JSONArray center = geofenceObject.getJSONArray("c");
                    String centerJson = center.getString(0);
                    String[] coordinates = centerJson.split("\\s*,\\s*");
                    String latitude = coordinates[0];
                    String longitude = coordinates[1];
                    if (geofenceObject.has("p")) {
                        JSONArray polygon = geofenceObject.getJSONArray("p");
                        ArrayList<String> polygonPoints = new ArrayList<String>(polygon.length());
                        for (int point = 0; point < polygon.length(); ++point) {
                            polygonPoints.add(polygon.getString(point));
                        }
                        OcambaGeofenceUtils.addGeofenceToList(id2, Double.valueOf(latitude), Double.valueOf(longitude), radius, expire, polygonPoints);
                        continue;
                    }
                    OcambaGeofenceUtils.addGeofenceToList(id2, Double.valueOf(latitude), Double.valueOf(longitude), radius, expire);
                    continue;
                }
                ArrayList<String> idToRemove = new ArrayList<String>();
                idToRemove.add(id2);
                OcambaGeofenceUtils.removeGeofences(idToRemove);
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void parseBeacon(JSONArray beaconArray) {
        OcambaLogUtils.d(TAG, "parseBeacon() called with: beaconArray = [" + beaconArray + "]");
        for (int i = 0; i < beaconArray.length(); ++i) {
            try {
                JSONObject beaconObject = beaconArray.getJSONObject(i);
                String id2 = beaconObject.getString("id");
                String namespaceId = beaconObject.getString("ed");
                long distance = beaconObject.getLong("distance");
                OcambaBeaconUtils.saveBeacon(id2, namespaceId, distance);
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    void parseMultiMessage(JSONObject jsonObject) throws JSONException {
        OcambaLogUtils.d(TAG, "parseMultiMessage() called with: jsonObject = [" + jsonObject + "]");
        if (!jsonObject.has("p")) {
            OcambaLogUtils.e("JSON doesn't have ['p'] object!");
            return;
        }
        JSONArray pArray = jsonObject.getJSONArray("p");
        if (pArray.length() == 0) {
            OcambaLogUtils.e(TAG, "parseMultiMessage: Empty notification objects array! Not rendering notifications.");
        } else if (pArray.length() == 1) {
            OcambaNotificationObject notificationObject = OcambaNotificationParser.createNotificationObject("p", pArray.getJSONObject(0));
            new OcambaNotificationRenderer(this.mContext).renderSingleNotification(notificationObject, false);
            OcambaUtils.sendOcambaMessageReceived(OcambaHoood.getContext(), notificationObject);
            OcambaUtils.setBadgeCount(this.mContext, OcambaPrefManager.getNotificationCount() + 1);
        } else if (jsonObject.has("s")) {
            for (int i = 0; i < pArray.length(); ++i) {
                OcambaNotificationObject ocambaNotificationObject = OcambaNotificationParser.createNotificationObject("p", pArray.getJSONObject(i));
                new OcambaNotificationRenderer(this.mContext).renderSingleNotification(ocambaNotificationObject, true);
                OcambaUtils.sendOcambaMessageReceived(OcambaHoood.getContext(), ocambaNotificationObject);
            }
            OcambaUtils.setBadgeCount(this.mContext, OcambaPrefManager.getNotificationCount() + 1);
        } else {
            OcambaNotificationObject ocambaNotificationObject = OcambaNotificationParser.createNotificationObject("p", pArray.getJSONObject(0));
            new OcambaNotificationRenderer(this.mContext).createMultiMessageNotification(jsonObject, ocambaNotificationObject, pArray.length());
            OcambaUtils.sendOcambaMultiMessageReceived(this.mContext);
            OcambaUtils.setBadgeCount(this.mContext, OcambaPrefManager.getNotificationCount() + 1);
        }
    }

    private void parse(String type, JSONObject jsonObject) {
        OcambaLogUtils.d("parse() called with: type = [" + type + "], jsonObject = [" + jsonObject + "]");
        OcambaNotificationObject ocambaNotificationObject = OcambaNotificationParser.createNotificationObject(type, jsonObject);
        if (ocambaNotificationObject != null) {
            OcambaLogUtils.i(TAG, "OcambaNotificationObject is not NULL.");
            if (type.equals("n")) {
                new OcambaNotificationRenderer(this.mContext).renderSingleNotification(ocambaNotificationObject, false);
                OcambaUtils.setBadgeCount(this.mContext, OcambaPrefManager.getNotificationCount() + 1);
            }
        }
    }

    public static OcambaNotificationObject createNotificationObject(String type, JSONObject jsonObject) {
        OcambaLogUtils.d(TAG, "createNotificationObject() json type: [" + type + "], Json object: " + jsonObject + "]");
        try {
            OcambaNotificationParser.viewTracker(jsonObject);
            switch (type) {
                case "e": {
                    if (jsonObject.has("e")) {
                        OcambaRequest.getNotification(jsonObject.getString("e"));
                    }
                    return null;
                }
                case "n": {
                    OcambaNotificationObject ocambaNotificationObject = OcambaNotificationParser.createNotificationObject(jsonObject, "t", "title", "n");
                    OcambaUtils.sendOcambaMessageReceived(OcambaHoood.getContext(), ocambaNotificationObject);
                    return ocambaNotificationObject;
                }
                case "p": {
                    return OcambaNotificationParser.createNotificationObject(jsonObject, "i", "t", "o");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            OcambaRequest.postCrash(e.toString());
        }
        return null;
    }

    private static void viewTracker(JSONObject jsonObject) throws Exception {
        if (jsonObject.has("v")) {
            String viewTracker = jsonObject.getString("v");
            OcambaLogUtils.i(TAG, "View tracker: " + viewTracker);
            if (viewTracker != null && URLUtil.isValidUrl((String)viewTracker)) {
                OcambaRequest.getTracker(viewTracker);
            }
        }
    }

    private static OcambaNotificationObject createNotificationObject(JSONObject jsonObject, String keyImpTracker, String keyTitle, String keyNotification) throws JSONException {
        OcambaNotificationObject ocambaNotificationObject = new OcambaNotificationObject();
        ocambaNotificationObject.setObject(jsonObject.toString());
        ocambaNotificationObject.setCustomData(mCustomData);
        mCustomData = "";
        ocambaNotificationObject.setNotificationId((int)SystemClock.uptimeMillis());
        if (jsonObject.has(keyImpTracker)) {
            JSONArray trackerArray = jsonObject.getJSONArray(keyImpTracker);
            ArrayList<String> tArray = new ArrayList<String>();
            for (int i = 0; i < trackerArray.length(); ++i) {
                String impTracker = trackerArray.getString(i);
                OcambaLogUtils.i(TAG, "Imp tracker: " + impTracker);
                tArray.add(impTracker);
                if (OcambaHoood.notification().isCustomTrack() || !URLUtil.isValidUrl((String)impTracker)) continue;
                OcambaRequest.getTracker(impTracker);
            }
            ocambaNotificationObject.setImpTrackerArray(tArray);
        }
        if (jsonObject.has(keyTitle)) {
            ocambaNotificationObject.setTitle(jsonObject.getString(keyTitle));
        }
        if (jsonObject.has(keyNotification)) {
            JSONObject n = jsonObject.getJSONObject(keyNotification);
            if (n.has("image")) {
                ocambaNotificationObject.setImage(n.getString("image"));
            }
            if (n.has("icon")) {
                ocambaNotificationObject.setIcon(n.getString("icon"));
            }
            if (n.has("body")) {
                ocambaNotificationObject.setDescription(n.getString("body"));
            }
            if (n.has("actions")) {
                ocambaNotificationObject.setActions(n.getJSONArray("actions").toString());
            }
            if (n.has("silent")) {
                ocambaNotificationObject.setSilent(n.getBoolean("silent") ? 1 : 0);
            }
            if (n.has("ac")) {
                ocambaNotificationObject.setAppNameColor(n.getString("ac"));
            }
            if (n.has("tc")) {
                ocambaNotificationObject.setTitleColor(n.getString("tc"));
            }
            if (n.has("dc")) {
                ocambaNotificationObject.setDescriptionColor(n.getString("dc"));
            }
            if (n.has("cl")) {
                ocambaNotificationObject.setCLayout(n.getInt("cl"));
            }
            if (n.has("el")) {
                ocambaNotificationObject.setELayout(n.getInt("el"));
            }
            if (n.has("vibrate")) {
                JSONArray vibrationPattern = n.getJSONArray("vibrate");
                long[] values = new long[vibrationPattern.length()];
                for (int i = 0; i < vibrationPattern.length(); ++i) {
                    values[i] = vibrationPattern.getLong(i);
                }
                ocambaNotificationObject.setVibration(values);
            }
            if (n.has("sound")) {
                ocambaNotificationObject.setSound(n.getString("sound"));
            }
            if (n.has("tag")) {
                ocambaNotificationObject.setTag(n.getString("tag"));
            }
            if (n.has("renotify")) {
                ocambaNotificationObject.setRenotify(n.getBoolean("renotify") ? 1 : 0);
            }
            if (n.has("data")) {
                JSONObject data = n.getJSONObject("data");
                if (data.has("url")) {
                    ocambaNotificationObject.setUrl(data.getString("url"));
                }
                if (data.has("t")) {
                    JSONArray trackerArray = data.getJSONArray("t");
                    ArrayList<String> cArray = new ArrayList<String>();
                    for (int i = 0; i < trackerArray.length(); ++i) {
                        String clickTracker = trackerArray.getString(i);
                        OcambaLogUtils.i(TAG, "Click tracker: " + clickTracker);
                        cArray.add(clickTracker);
                    }
                    ocambaNotificationObject.setClickTrackerArray(cArray);
                }
            }
            if (n.has("st")) {
                ocambaNotificationObject.setStyle(n.getString("st"));
            }
            if (n.has("in")) {
                ocambaNotificationObject.setMultiMessageIndicator(n.getString("in"));
            } else {
                ocambaNotificationObject.setMultiMessageIndicator("ocamba_multimessage_indicator");
            }
            if (n.has("an")) {
                ocambaNotificationObject.setMultiMessageNext(n.getString("an"));
            } else {
                ocambaNotificationObject.setMultiMessageNext("ocamba_multimessage_arrow_next");
            }
            if (n.has("ap")) {
                ocambaNotificationObject.setMultiMessagePrevious(n.getString("ap"));
            } else {
                ocambaNotificationObject.setMultiMessagePrevious("ocamba_multimessage_arrow_previous");
            }
            if (n.has("tid")) {
                ocambaNotificationObject.setTaskId(n.getString("tid"));
            }
        }
        return ocambaNotificationObject;
    }
}

