/*
 * Decompiled with CFR 0.152.
 */
package com.ocamba.hoood.util;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.os.Looper;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.ocamba.hoood.OcambaHoood;
import com.ocamba.hoood.util.OcambaLogUtils;
import com.ocamba.hoood.util.OcambaUtils;

public class OcambaAnalytics
implements Application.ActivityLifecycleCallbacks {
    public static final String TAG = OcambaAnalytics.class.getSimpleName();
    private FusedLocationProviderClient mFusedLocationClient;
    private LocationRequest mLocationRequest;
    private LocationCallback mLocationCallback;
    private Activity mActivity;
    private boolean mLocationMonitorActivated = true;

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        this.mActivity = activity;
        OcambaHoood.sendAnalytics();
        boolean bl = this.mLocationMonitorActivated = !OcambaHoood.getBuilder().isTrackLocationDisabled() || !OcambaHoood.getBuilder().isGeofenceDisabled();
        if (OcambaUtils.isGooglePlayServicesAvailable((Context)this.mActivity) && this.mLocationMonitorActivated) {
            if (!OcambaUtils.checkLocationPermissions((Context)this.mActivity)) {
                OcambaLogUtils.w("Please, enable location permission!");
            } else {
                this.initLocationTracking();
            }
        }
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        this.requestLocationUpdates();
    }

    public void onActivityPaused(Activity activity) {
        this.removeLocationUpdates();
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        this.mActivity = null;
    }

    public void initLocationTracking() {
        try {
            OcambaLogUtils.d("initLocationTracking() called.");
            if (!OcambaUtils.isGooglePlayServicesAvailable((Context)this.mActivity)) {
                return;
            }
            this.mFusedLocationClient = LocationServices.getFusedLocationProviderClient((Activity)this.mActivity);
            this.mLocationRequest = LocationRequest.create();
            this.mLocationRequest.setInterval(300000L);
            this.mLocationRequest.setPriority(100);
            this.mLocationCallback = new LocationCallback(){

                public void onLocationResult(LocationResult locationResult) {
                    if (locationResult == null) {
                        return;
                    }
                    for (Location location : locationResult.getLocations()) {
                        OcambaLogUtils.i("Location: " + location);
                        OcambaHoood.trackLocation(location);
                    }
                }
            };
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void requestLocationUpdates() {
        OcambaLogUtils.d(TAG, "requestLocationUpdates() called");
        if (!OcambaUtils.isGooglePlayServicesAvailable((Context)this.mActivity)) {
            return;
        }
        if (!this.mLocationMonitorActivated) {
            return;
        }
        if (this.mFusedLocationClient != null && this.mLocationCallback != null && this.mLocationRequest != null) {
            this.mFusedLocationClient.requestLocationUpdates(this.mLocationRequest, this.mLocationCallback, Looper.getMainLooper());
        }
    }

    public void removeLocationUpdates() {
        OcambaLogUtils.d(TAG, "removeLocationUpdates() called");
        if (!OcambaUtils.isGooglePlayServicesAvailable((Context)this.mActivity)) {
            return;
        }
        if (!this.mLocationMonitorActivated) {
            return;
        }
        if (this.mFusedLocationClient != null && this.mLocationCallback != null) {
            this.mFusedLocationClient.removeLocationUpdates(this.mLocationCallback);
        }
    }
}

