/*
 * Decompiled with CFR 0.152.
 */
package com.ocamba.hoood.images;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.ocamba.hoood.OcambaRequest;
import com.ocamba.hoood.images.OcambaLruCache;
import com.ocamba.hoood.util.OcambaLogUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class OcambaDiskCache {
    private static final String TAG = OcambaDiskCache.class.getSimpleName();
    private final OcambaLruCache diskLruCache;

    OcambaDiskCache(File cacheDir, int appVersion, int valueCount, long maxSize) throws IOException {
        this.diskLruCache = OcambaLruCache.open(cacheDir, appVersion, valueCount, maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bitmap getBitmapFromDiskCache(String key) {
        key = this.getIntegerValue(key);
        try (OcambaLruCache.Snapshot snapshot = null;){
            snapshot = this.diskLruCache.get(key);
            if (snapshot != null) {
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)snapshot.getInputStream(0));
                return bitmap;
            }
        }
        OcambaLogUtils.w(TAG, "Failed to load image from disk cache: " + key);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBitmapToDiskCache(String key, Bitmap bitmap) {
        key = this.getIntegerValue(key);
        OutputStream outputStream = null;
        try {
            OcambaLruCache.Editor editor = this.diskLruCache.edit(key);
            outputStream = editor.newOutputStream(0);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, outputStream);
            outputStream.flush();
            outputStream.close();
            editor.commit();
        }
        catch (Throwable t) {
            OcambaLogUtils.e(TAG, "Error while producing output stream or compressing bitmap for key " + key);
            OcambaRequest.postCrash(t.getMessage());
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    OcambaLogUtils.e(TAG, "Exception while closing disk cache output stream for key" + key, e);
                    OcambaRequest.postCrash(e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doesDiskCacheForKeyExist(String key) {
        key = this.getIntegerValue(key);
        try (OcambaLruCache.Snapshot snapshot = null;){
            snapshot = this.diskLruCache.get(key);
            boolean bl = snapshot != null;
            return bl;
        }
        return false;
    }

    private String getIntegerValue(String key) {
        return Integer.toString(key.hashCode());
    }
}

