/*
 * Decompiled with CFR 0.152.
 */
package com.ocamba.hoood.images;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.DisplayMetrics;
import android.webkit.URLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class OcambaImageHelper {
    public static int ICON = 0;
    public static int MAIN = 1;
    public static final String TAG = OcambaImageHelper.class.getSimpleName();

    public static Bitmap getScaledBitmapFromUrl(Context context, String imageUrl, int type, int screenWidth) throws IOException {
        if (imageUrl == null || !URLUtil.isValidUrl((String)imageUrl)) {
            throw new IOException("Image url [" + imageUrl + "] is null or not valid.");
        }
        int requiredWidth = type == ICON ? OcambaImageHelper.convertDpToPixel(context, 50) : screenWidth;
        int requiredHeight = type == ICON ? OcambaImageHelper.convertDpToPixel(context, 50) : OcambaImageHelper.convertDpToPixel(context, 186);
        URL url = new URL(imageUrl);
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)url.openConnection().getInputStream(), null, (BitmapFactory.Options)options);
        options.inSampleSize = OcambaImageHelper.calculateInSampleSize(options, requiredWidth, requiredHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeStream((InputStream)url.openConnection().getInputStream(), null, (BitmapFactory.Options)options);
    }

    private static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / inSampleSize >= reqHeight && halfWidth / inSampleSize >= reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    private static int convertDpToPixel(Context context, int dp) {
        if (context != null) {
            Resources resources = context.getResources();
            DisplayMetrics metrics = resources.getDisplayMetrics();
            return dp * (metrics.densityDpi / 160);
        }
        return dp * (dp / 160);
    }

    public static int getImageLoaderCacheSize() {
        long runtimeMaxMemory = Runtime.getRuntime().maxMemory() / 8L;
        long max = Integer.MAX_VALUE;
        int diff = (int)Math.min(runtimeMaxMemory, max);
        return Math.max(1024, Math.min(diff, 0x2000000));
    }
}

