/*
 * Decompiled with CFR 0.152.
 */
package com.ocamba.hoood.beacon;

import com.ocamba.hoood.OcambaRequest;
import com.ocamba.hoood.beacon.OcambaBeacon;
import com.ocamba.hoood.beacon.OcambaBeaconPrefManager;
import com.ocamba.hoood.util.OcambaLogUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class OcambaBeaconUtils {
    public static final String TAG = OcambaBeaconUtils.class.getSimpleName();
    private static ArrayList<String> mBeaconListId = new ArrayList();

    public static List<OcambaBeacon> getBeacons() {
        ArrayList<OcambaBeacon> beacons = new ArrayList<OcambaBeacon>();
        for (String beaconId : OcambaBeaconPrefManager.getBeaconId()) {
            beacons.add(OcambaBeaconPrefManager.getBeacon(beaconId));
        }
        return beacons;
    }

    public static void saveBeacon(String id2, String namespaceId, long distance) {
        if (mBeaconListId != null) {
            mBeaconListId.clear();
            mBeaconListId.addAll(OcambaBeaconPrefManager.getBeaconId());
            OcambaBeaconUtils.buildBeacon(id2, namespaceId, "", distance);
            OcambaBeaconPrefManager.setBeaconsIds(new HashSet<String>(mBeaconListId));
        }
    }

    public static void saveBeacon(String id2, String namespaceId, String instanceId, long distance) {
        if (mBeaconListId != null) {
            mBeaconListId.clear();
            mBeaconListId.addAll(OcambaBeaconPrefManager.getBeaconId());
            OcambaBeaconUtils.buildBeacon(id2, namespaceId, instanceId, distance);
            OcambaBeaconPrefManager.setBeaconsIds(new HashSet<String>(mBeaconListId));
        }
    }

    private static void buildBeacon(String id2, String namespaceId, String instanceId, long distance) {
        if (!mBeaconListId.contains(id2)) {
            mBeaconListId.add(id2);
        }
        OcambaBeaconPrefManager.setBeacon(new OcambaBeacon(id2, namespaceId, instanceId, distance));
    }

    public static void trackBeacon(String namespaceId, long trackTime) {
        long mBeaconSyncPeriod;
        OcambaLogUtils.d(TAG, "trackBeacon() called with: namespaceId = [" + namespaceId + "]");
        String beaconUniqueId = OcambaBeaconUtils.isBeaconNamespaceIdStored(namespaceId);
        if (beaconUniqueId.equals("")) {
            OcambaLogUtils.w(TAG, "Tried to track beacon but it is not saved in local storage.");
            if (OcambaBeaconPrefManager.getActive()) {
                OcambaBeaconUtils.saveBeacon(namespaceId, namespaceId, 0L);
                beaconUniqueId = OcambaBeaconUtils.isBeaconNamespaceIdStored(namespaceId);
            } else {
                OcambaLogUtils.w(TAG, "No public beacons allowed.");
                return;
            }
        }
        long lastTimeSent = OcambaBeaconPrefManager.getBeaconSentTime(beaconUniqueId);
        long currentTimeMillis = System.currentTimeMillis();
        long l = mBeaconSyncPeriod = trackTime > 60000L ? trackTime : 60000L;
        if (lastTimeSent + mBeaconSyncPeriod < currentTimeMillis) {
            OcambaBeaconPrefManager.setBeaconSentTime(beaconUniqueId, currentTimeMillis);
            OcambaBeaconUtils.sendBeaconToServer(beaconUniqueId);
        }
    }

    private static void sendBeaconToServer(String beaconId) {
        OcambaLogUtils.d(TAG, "sendBeaconToServer() called with: beaconId = [" + beaconId + "]");
        OcambaRequest.beaconProximity(beaconId);
    }

    private static String isBeaconNamespaceIdStored(String namespaceId) {
        try {
            for (OcambaBeacon beacon : OcambaBeaconUtils.getBeacons()) {
                if (!beacon.getNamespaceId().equals(namespaceId)) continue;
                return beacon.getUniqueId();
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static void setActive(boolean active) {
        OcambaBeaconPrefManager.setActive(active);
    }
}

