/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.infra.persistence;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.arch.core.util.Function;
import com.taboola.android.infra.persistence.AbstractPersistentResource;

public class BuilderWithContext<T>
implements AbstractPersistentResource.Builder<T> {
    @StringRes
    private final int storageKey;
    private final Context context;
    private final Function<Context, T> defaultValueProvider;
    private final String sharedPreferencesName;

    public BuilderWithContext(Context context, @StringRes int storageKey, String sharedPreferencesName, Function<Context, T> defaultValueProvider) {
        this.storageKey = storageKey;
        this.context = context;
        this.sharedPreferencesName = sharedPreferencesName;
        this.defaultValueProvider = defaultValueProvider;
    }

    @Override
    @NonNull
    public T getDefaultValue() {
        return (T)this.defaultValueProvider.apply((Object)this.context);
    }

    @Override
    @NonNull
    public String getStorageKey() {
        return this.context.getString(this.storageKey);
    }

    @Override
    @NonNull
    public SharedPreferences getSharedPreferences() {
        return this.context.getSharedPreferences(this.sharedPreferencesName, 0);
    }
}

