/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.infra.inappupdate.internals;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Consumer;
import com.google.android.play.core.appupdate.AppUpdateInfo;
import com.google.android.play.core.appupdate.AppUpdateManager;
import com.google.android.play.core.appupdate.AppUpdateManagerFactory;
import com.google.android.play.core.tasks.Task;
import com.taboola.android.infra.R;
import com.taboola.android.infra.inappupdate.Configuration;
import com.taboola.android.infra.inappupdate.InAppUpdateException;
import com.taboola.android.infra.inappupdate.TriggerEventsCallback;
import com.taboola.android.infra.inappupdate.internals.AppData;
import com.taboola.android.infra.inappupdate.internals.AppInfoRetrieverImpl;
import com.taboola.android.infra.inappupdate.internals.PreconditionsChecker;
import com.taboola.android.infra.inappupdate.internals.UpdateInProgressMonitor;
import com.taboola.android.infra.inappupdate.internals.UpdateRunner;
import com.taboola.android.infra.persistence.AbstractPersistentResource;
import com.taboola.android.infra.persistence.BuilderWithContext;
import com.taboola.android.infra.persistence.IntegerPersistentResource;
import com.taboola.android.infra.persistence.LongPersistentResource;
import com.taboola.android.infra.persistence.PersistentResource;
import com.taboola.android.infra.utilities.BackgroundExecutor;
import com.taboola.android.infra.utilities.Executor2;
import com.taboola.android.infra.utilities.GeneralizedSupplier;
import com.taboola.android.infra.utilities.UiExecutor;

public class Module {
    private static final String SHARED_PREFERENCES_NAME = "com.taboola.android.infra.inappupdate";
    private final Context context;
    private final Executor2 uiExecutor;
    private final PersistentResource<Long> lastAppearanceTime;
    private final PersistentResource<Integer> appearancesCount;

    public Module(Context context) {
        this.context = context.getApplicationContext();
        this.uiExecutor = new UiExecutor();
        this.lastAppearanceTime = new LongPersistentResource((AbstractPersistentResource.Builder<Long>)new BuilderWithContext<Long>(context, R.string.inappupdate__last_appearance_time_key, SHARED_PREFERENCES_NAME, ctx -> 0L));
        this.appearancesCount = new IntegerPersistentResource((AbstractPersistentResource.Builder<Integer>)new BuilderWithContext<Integer>(context, R.string.inappupdate__appearences_count_key, SHARED_PREFERENCES_NAME, ctx -> 0));
    }

    @NonNull
    PreconditionsChecker getPreconditionsChecker(@Nullable Configuration configuration, final TriggerEventsCallback triggerEventsCallback, final Consumer<AppUpdateInfo> onAllChecksPassed) {
        return new PreconditionsChecker(configuration, triggerEventsCallback, this.uiExecutor, this.lastAppearanceTime, this.appearancesCount){

            @Override
            @NonNull
            protected AppData getAppData() throws InAppUpdateException {
                return (AppData)Module.this.getAppDataRetriever().get();
            }

            @Override
            protected void onAllChecksPassed(AppUpdateInfo updateInfo) {
                onAllChecksPassed.accept((Object)updateInfo);
            }

            @Override
            protected void startMonitoringUpdateInProgress() {
                Runnable updateInProgressMonitor = Module.this.getUpdateInProgressMonitor(triggerEventsCallback);
                Module.this.getBackgroundExecutor().execute(updateInProgressMonitor);
            }

            @Override
            @NonNull
            protected Task<AppUpdateInfo> getAppUpdateInfoTask() {
                return Module.this.getAppUpdateManager().getAppUpdateInfo();
            }
        };
    }

    private AppUpdateManager getAppUpdateManager() {
        return AppUpdateManagerFactory.create((Context)this.context);
    }

    private GeneralizedSupplier<AppData, InAppUpdateException> getAppDataRetriever() {
        return new AppInfoRetrieverImpl(this.context);
    }

    public Runnable getUpdateController(AppUpdateInfo updateInfo, Configuration configuration, final TriggerEventsCallback callback, Activity activity) {
        return new UpdateRunner(this.uiExecutor, updateInfo, configuration, callback, this.getAppUpdateManager(), activity){

            @Override
            protected void startMonitoringUpdateInProgress() {
                Runnable updateInProgressMonitor = Module.this.getUpdateInProgressMonitor(callback);
                Module.this.getBackgroundExecutor().execute(updateInProgressMonitor);
            }
        };
    }

    public Runnable getUpdateInProgressMonitor(TriggerEventsCallback callback) {
        return new UpdateInProgressMonitor(this.uiExecutor, callback, this.getAppUpdateManager());
    }

    public BackgroundExecutor getBackgroundExecutor() {
        return new BackgroundExecutor();
    }

    Runnable getCountersReset() {
        return () -> {
            this.lastAppearanceTime.set(0L);
            this.appearancesCount.set(0);
        };
    }
}

