/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.infra.persistence;

import android.content.SharedPreferences;
import android.util.Log;
import androidx.annotation.NonNull;
import com.taboola.android.infra.persistence.PersistentResource;
import com.taboola.android.infra.utilities.Subscription;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public abstract class AbstractPersistentResource<T>
implements PersistentResource<T> {
    private static final String TAG = AbstractPersistentResource.class.getSimpleName();
    protected final Builder<T> builder;
    private final Set<PersistentResource.OnChangeListener<T>> onChangeListeners = new CopyOnWriteArraySet<PersistentResource.OnChangeListener<T>>();
    private final SharedPreferences.OnSharedPreferenceChangeListener spListener = (sharedPreferences, key) -> {
        if (!this.getStorageKey().equals(key)) {
            return;
        }
        for (PersistentResource.OnChangeListener<T> onChangeListener : this.onChangeListeners) {
            onChangeListener.onValueChanged(this);
        }
    };

    AbstractPersistentResource(Builder<T> builder) {
        this.builder = builder;
    }

    @NonNull
    protected String getStorageKey() {
        return this.builder.getStorageKey();
    }

    protected SharedPreferences getSharedPreferences() {
        return this.builder.getSharedPreferences();
    }

    @Override
    @NonNull
    public T get() {
        this.setIfAbsent(this.builder.getDefaultValue());
        return this.getStoredValue();
    }

    @Override
    public void set(T value) {
        SharedPreferences.Editor edit = this.getSharedPreferences().edit();
        this.storeValue(edit, value);
        edit.apply();
    }

    @Override
    @NonNull
    public Subscription registerListener(PersistentResource.OnChangeListener<T> onChangeListener) {
        boolean prevState = this.onChangeListeners.isEmpty();
        this.onChangeListeners.add(onChangeListener);
        boolean newState = this.onChangeListeners.isEmpty();
        if (prevState != newState) {
            this.ensureListenerState();
        }
        return () -> this.unregisterListener(onChangeListener);
    }

    private void ensureListenerState() {
        if (!this.onChangeListeners.isEmpty()) {
            this.getSharedPreferences().registerOnSharedPreferenceChangeListener(this.spListener);
        } else {
            this.getSharedPreferences().unregisterOnSharedPreferenceChangeListener(this.spListener);
        }
    }

    @Override
    public void unregisterListener(PersistentResource.OnChangeListener<T> onChangeListener) {
        boolean prevState = this.onChangeListeners.isEmpty();
        this.onChangeListeners.remove(onChangeListener);
        boolean newState = this.onChangeListeners.isEmpty();
        if (prevState != newState) {
            this.ensureListenerState();
        }
    }

    @NonNull
    public String toString() {
        return "[storageKey=" + this.getStorageKey() + ", builder=" + this.builder + ", get()=" + this.get() + "]";
    }

    protected abstract T getStoredValue();

    protected abstract void storeValue(SharedPreferences.Editor var1, T var2);

    private void setIfAbsent(T value) {
        if (!this.isSet()) {
            Log.d((String)TAG, (String)("setIfAbsent(" + this.getStorageKey() + ") - set: " + value));
            this.set(value);
        }
    }

    private boolean isSet() {
        return this.getSharedPreferences().contains(this.getStorageKey());
    }

    public static interface Builder<T> {
        @NonNull
        public T getDefaultValue();

        @NonNull
        public String getStorageKey();

        @NonNull
        public SharedPreferences getSharedPreferences();
    }
}

