/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.infra.inappupdate.internals;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.taboola.android.infra.inappupdate.InAppUpdateException;
import com.taboola.android.infra.inappupdate.internals.AppData;
import com.taboola.android.infra.utilities.GeneralizedSupplier;

class AppInfoRetrieverImpl
implements GeneralizedSupplier<AppData, InAppUpdateException> {
    private final Context context;

    AppInfoRetrieverImpl(Context context) {
        this.context = context;
    }

    @Override
    @NonNull
    @WorkerThread
    public AppData get() throws InAppUpdateException {
        try {
            PackageInfo pInfo = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
            long versionCode = Build.VERSION.SDK_INT >= 28 ? pInfo.getLongVersionCode() : (long)pInfo.versionCode;
            return () -> versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new InAppUpdateException((Exception)((Object)e), InAppUpdateException.ErrorCode.ERROR_UNEXPECTED);
        }
    }
}

