package com.taboola.android.infra.inappupdate.internals;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;

import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;

import com.taboola.android.infra.inappupdate.InAppUpdateException;
import com.taboola.android.infra.utilities.GeneralizedSupplier;

class AppInfoRetrieverImpl implements GeneralizedSupplier<AppData, InAppUpdateException> {
    private final Context context;

    AppInfoRetrieverImpl(Context context) {
        this.context = context;
    }

    @NonNull
    @WorkerThread
    @Override
    public AppData get() throws InAppUpdateException {
        try {
            PackageInfo pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            final long versionCode;
            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.P) {
                versionCode = pInfo.getLongVersionCode();
            } else {
                versionCode = pInfo.versionCode;
            }
            return () -> versionCode;
        } catch (PackageManager.NameNotFoundException e) {
            throw new InAppUpdateException(e, InAppUpdateException.ErrorCode.ERROR_UNEXPECTED);
        }
    }

}
