package com.taboola.android.infra.inappupdate;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;

@Keep
public class InAppUpdateException extends Exception {
    @Keep
    public enum ErrorCode {
        //general errors
        ERROR_UNEXPECTED,
        ERROR_INPUT_VALIDATION,

        //precondition check errors
        PRECONDITION_CONFIGURATION_NOT_SET,
        PRECONDITION_TARGET_VERSION,
        PRECONDITION_TOTAL_CAP,
        PRECONDITION_APPEARANCE_INTERVAL,
        PRECONDITION_NO_UPDATE_INFO,
        PRECONDITION_NO_UPDATE_AVAILABLE,
        PRECONDITION_AVAILABILITY_DELAY,
        PRECONDITION_UPDATE_TYPE,
        PRECONDITION_APP_BACKGROUND,

        // update flow errors
        UPDATE_NOT_STARTED,
        UPDATE_CANCELLED,
        UPDATE_FAILED;
    }


    private final ErrorCode errorCode;

    public InAppUpdateException(String message, ErrorCode errorCode) {
        super(message);
        this.errorCode = errorCode;
    }

    public InAppUpdateException(Exception e, ErrorCode errorCode) {
        super(e);
        this.errorCode = errorCode;
    }

    public ErrorCode getErrorCode() {
        return errorCode;
    }

    @NonNull
    @Override
    public String toString() {
        return "{" +
                "errorCode=" + errorCode +
                "} " + super.toString();
    }
}
