/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.infra.persistence;

import androidx.annotation.NonNull;
import androidx.arch.core.util.Function;
import androidx.core.util.Supplier;
import com.taboola.android.infra.utilities.Subscription;

public interface PersistentResource<T>
extends Supplier<T> {
    @NonNull
    public T get();

    public void set(@NonNull T var1);

    @NonNull
    public Subscription registerListener(@NonNull OnChangeListener<T> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public T transact(@NonNull Function<T, T> transaction) {
        PersistentResource persistentResource = this;
        synchronized (persistentResource) {
            T v = this.get();
            Object result = transaction.apply(v);
            this.set(result);
            return v;
        }
    }

    public void unregisterListener(@NonNull OnChangeListener<T> var1);

    @NonNull
    default public Subscription subscribe(@NonNull OnChangeListener<T> onChangeListener) {
        Subscription subscription = this.registerListener(onChangeListener);
        onChangeListener.onValueChanged(this);
        return subscription;
    }

    public static interface OnChangeListener<T> {
        public void onValueChanged(@NonNull PersistentResource<T> var1);
    }
}

