/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.infra.inappupdate.internals;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.util.Consumer;
import com.google.android.play.core.appupdate.AppUpdateInfo;
import com.taboola.android.infra.inappupdate.Configuration;
import com.taboola.android.infra.inappupdate.TriggerEventsCallback;
import com.taboola.android.infra.inappupdate.internals.Module;
import com.taboola.android.infra.inappupdate.internals.PreconditionsChecker;
import com.taboola.android.infra.utilities.Executor2;

public class Sdk {
    private static volatile Sdk instance;
    private final Executor2 backgroundExecutor;
    private final Module module;
    private final Runnable countersReset;
    @Nullable
    private Configuration configuration;
    @NonNull
    private TriggerEventsCallback triggerEventsCallback = TriggerEventsCallback.NULL;

    private Sdk(Context context) {
        this.module = new Module(context);
        this.backgroundExecutor = this.module.getBackgroundExecutor();
        this.countersReset = this.module.getCountersReset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @AnyThread
    public static void initialize(Context context) {
        if (instance != null) return;
        Class<Sdk> clazz = Sdk.class;
        synchronized (Sdk.class) {
            if (instance != null) return;
            instance = new Sdk(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static Sdk getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Not initialized. Did you call InAppUpdate.initialize()?");
        }
        return instance;
    }

    public void setConfiguration(@Nullable Configuration configuration) {
        this.configuration = configuration;
    }

    public void setTriggerEventsCallback(@Nullable TriggerEventsCallback triggerEventsCallback) {
        this.triggerEventsCallback = triggerEventsCallback != null ? triggerEventsCallback : TriggerEventsCallback.NULL;
    }

    @SuppressLint(value={"Assert"})
    @AnyThread
    public void onTriggerOccurred(Activity activity) {
        PreconditionsChecker preconditionsChecker = this.module.getPreconditionsChecker(this.configuration, this.triggerEventsCallback, (Consumer<AppUpdateInfo>)((Consumer)updateInfo -> {
            assert (updateInfo.updateAvailability() == 2);
            assert (this.configuration != null);
            Runnable updateController = this.module.getUpdateController((AppUpdateInfo)updateInfo, this.configuration, this.triggerEventsCallback, activity);
            this.backgroundExecutor.execute(updateController);
        }));
        this.backgroundExecutor.execute(preconditionsChecker);
    }

    public void resetCounters() {
        this.countersReset.run();
    }
}

