package com.taboola.android.infra.utilities;

import androidx.core.util.Predicate;
import androidx.core.util.Supplier;

import com.taboola.android.infra.inappupdate.ValidationException;


public class Validators {
    private final static Predicate<Long> IS_NON_NEGATIVE = n -> n >= 0;

    public static long isNonNegative(String parameterName, long subject) throws ValidationException {
        return validate(() -> parameterName + " cannot be negative", subject, IS_NON_NEGATIVE);
    }

    public static <T> T validate(Supplier<String> validationError, T subject, Predicate<T> predicate) throws ValidationException {
        if (!predicate.test(subject)) {
            throw new ValidationException(validationError.get());
        }
        return subject;
    }


}
